/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.ProvidingManager;
import jmri.server.json.Bundle;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNonProvidedNamedBeanHttpService;
import jmri.server.json.JsonRequest;

public abstract class JsonNamedBeanHttpService<T extends NamedBean>
extends JsonNonProvidedNamedBeanHttpService<T> {
    public JsonNamedBeanHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    @Nonnull
    public final JsonNode doGet(@Nonnull String type, @Nonnull String name, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        if (!type.equals(this.getType())) {
            throw new JsonException(500, Bundle.getMessage(request.locale, "LoggedError"), request.id);
        }
        return this.doGet(this.getManager().getNamedBean(name), name, type, request);
    }

    @Override
    @Nonnull
    public final JsonNode doPost(@Nonnull String type, @Nonnull String name, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        if (!type.equals(this.getType())) {
            throw new JsonException(500, Bundle.getMessage(request.locale, "LoggedError"), request.id);
        }
        Object bean = this.postNamedBean(this.getManager().getNamedBean(name), data, name, type, request);
        return this.doPost(bean, name, type, data, request);
    }

    @Override
    public JsonNode doPut(@Nonnull String type, @Nonnull String name, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        try {
            this.getManager().provide(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorInvalidSystemName", name, this.getType()), request.id);
        }
        catch (Exception exception) {
            throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorCreatingObject", this.getType(), name), request.id);
        }
        return this.doPost(type, name, data, request);
    }

    @Override
    @Nonnull
    public final JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        return this.doGetList(this.getManager(), type, data, request);
    }

    @Override
    public void doDelete(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        if (!type.equals(this.getType())) {
            throw new JsonException(500, Bundle.getMessage(request.locale, "LoggedError"), request.id);
        }
        this.doDelete(this.getManager().getNamedBean(name), name, type, data, request);
    }

    @Override
    @Nonnull
    protected abstract ObjectNode doGet(T var1, @Nonnull String var2, @Nonnull String var3, @Nonnull JsonRequest var4) throws JsonException;

    @Override
    @CheckForNull
    public T getNamedBean(@Nonnull String type, @Nonnull String name, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        try {
            if (!data.isEmpty() && !data.isNull()) {
                if ("put".equals(request.method)) {
                    this.doPut(type, name, data, request);
                } else if ("post".equals(request.method)) {
                    this.doPost(type, name, data, request);
                }
            }
            return (T)this.getManager().getBySystemName(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorInvalidSystemName", name, type), request.id);
        }
    }

    @Nonnull
    protected abstract ObjectNode doPost(T var1, @Nonnull String var2, @Nonnull String var3, @Nonnull JsonNode var4, @Nonnull JsonRequest var5) throws JsonException;

    protected void doDelete(@CheckForNull T bean, @Nonnull String name, @Nonnull String type, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        super.doDelete(type, name, data, request);
    }

    @Deprecated
    @Nonnull
    protected ObjectNode doPost(T bean, @Nonnull String name, @Nonnull String type, @Nonnull JsonNode data, @Nonnull Locale locale, int id) throws JsonException {
        return this.doPost(bean, name, type, data, new JsonRequest(locale, "v5", "post", id));
    }

    @Deprecated
    protected void doDelete(@CheckForNull T bean, @Nonnull String name, @Nonnull String type, @Nonnull JsonNode data, @Nonnull Locale locale, int id) throws JsonException {
        this.doDelete(type, name, data, new JsonRequest(locale, "v5", "delete", id));
    }

    protected final void deleteBean(@CheckForNull T bean, @Nonnull String name, @Nonnull String type, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        if (bean == null) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", type, name), request.id);
        }
        ArrayList<String> listeners = bean.getListenerRefs();
        if (!listeners.isEmpty() && !this.acceptForceDeleteToken(type, name, data.path("forceDelete").asText())) {
            ArrayNode conflicts = this.mapper.createArrayNode();
            listeners.forEach(arg_0 -> ((ArrayNode)conflicts).add(arg_0));
            this.throwDeleteConflictException(type, name, conflicts, request);
        } else {
            this.getManager().deregister(bean);
        }
    }

    @Deprecated
    protected final void deleteBean(@CheckForNull T bean, @Nonnull String name, @Nonnull String type, @Nonnull JsonNode data, @Nonnull Locale locale, int id) throws JsonException {
        this.deleteBean(bean, name, type, data, new JsonRequest(locale, "v5", "delete", id));
    }

    @Nonnull
    protected abstract String getType();

    @Nonnull
    protected abstract ProvidingManager<T> getManager();
}

