/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.server.json.JsonHttpService;

public class JsonException
extends Exception {
    public static final String ERROR = "error";
    public static final String CODE = "code";
    public static final String MESSAGE = "message";
    public static final String ERROR_BAD_PROPERTY_VALUE = "ErrorBadPropertyValue";
    public static final String ERROR_MISSING_PROPERTY_PUT = "ErrorMissingPropertyPut";
    public static final String ERROR_NOT_FOUND = "ErrorNotFound";
    public static final String ERROR_OBJECT = "ErrorObject";
    public static final String ERROR_UNKNOWN_TYPE = "ErrorUnknownType";
    public static final String LOGGED_ERROR = "LoggedError";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final int errorCode;
    private final transient ObjectNode additionalData;
    private final int id;

    public JsonException(int code, String message, Throwable throwable, int id) {
        this(code, message, throwable, null, id);
    }

    public JsonException(int code, String message, Throwable throwable, ObjectNode additionalData, int id) {
        super(message, throwable);
        this.errorCode = code;
        this.additionalData = additionalData;
        this.id = id;
    }

    public JsonException(int code, Throwable throwable, int id) {
        this(code, throwable, null, id);
    }

    public JsonException(int code, Throwable throwable, ObjectNode additionalData, int id) {
        super(throwable);
        this.errorCode = code;
        this.additionalData = additionalData;
        this.id = id;
    }

    public JsonException(int code, String message, int id) {
        this(code, message, (ObjectNode)null, id);
    }

    public JsonException(int code, String message, ObjectNode additionalData, int id) {
        super(message);
        this.errorCode = code;
        this.additionalData = additionalData;
        this.id = id;
    }

    public int getCode() {
        return this.errorCode;
    }

    public ObjectNode getAdditionalData() {
        return this.additionalData.deepCopy();
    }

    public int getId() {
        return Math.abs(this.id);
    }

    public JsonNode getJsonMessage() {
        ObjectNode data = MAPPER.createObjectNode();
        data.put(CODE, this.getCode());
        data.put(MESSAGE, this.getMessage());
        if (this.additionalData != null) {
            data.setAll(this.additionalData);
        }
        return JsonHttpService.message(MAPPER, ERROR, (JsonNode)data, null, this.getId());
    }
}

