/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;

class JsonDeleteTokenManager {
    private final Map<String, String> tokens = new HashMap<String, String>();

    static JsonDeleteTokenManager getDefault() {
        if (InstanceManager.getNullableDefault(JsonDeleteTokenManager.class) == null) {
            InstanceManager.setDefault(JsonDeleteTokenManager.class, new JsonDeleteTokenManager());
        }
        return InstanceManager.getDefault(JsonDeleteTokenManager.class);
    }

    JsonDeleteTokenManager() {
    }

    boolean acceptToken(@Nonnull String type, @Nonnull String name, @CheckForNull String token) {
        String value = this.tokens.getOrDefault(this.getKey(type, name), UUID.randomUUID().toString());
        return value.equals(token);
    }

    String getToken(@Nonnull String type, @Nonnull String name) {
        String key = this.getKey(type, name);
        this.tokens.put(key, UUID.randomUUID().toString());
        return this.tokens.get(key);
    }

    private String getKey(@Nonnull String type, @Nonnull String name) {
        return String.valueOf(type) + name;
    }
}

