/*
 * Decompiled with CFR 0.152.
 */
package jmri.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.script.Bundle;
import jmri.script.JmriScriptEngineManager;
import jmri.util.FileUtil;

public class ScriptFileChooser
extends JFileChooser {
    public ScriptFileChooser() {
        super(FileUtil.getScriptsPath());
        this.init();
    }

    public ScriptFileChooser(String path) {
        super(path);
        this.init();
    }

    public ScriptFileChooser(File dir) {
        super(dir);
        this.init();
    }

    private void init() {
        ArrayList allExtensions = new ArrayList();
        HashMap filters = new HashMap();
        ArrayList filterNames = new ArrayList();
        JmriScriptEngineManager.getDefault().getManager().getEngineFactories().stream().forEach(factory -> {
            List<String> extensions = factory.getExtensions();
            allExtensions.addAll(extensions);
            String name = this.fileForLanguage(factory.getLanguageName());
            filterNames.add(name);
            filters.put(name, new FileNameExtensionFilter(name, extensions.toArray(new String[extensions.size()])));
        });
        FileNameExtensionFilter allScripts = new FileNameExtensionFilter(Bundle.getMessage("allScripts"), allExtensions.toArray(new String[allExtensions.size()]));
        this.addChoosableFileFilter(allScripts);
        filterNames.stream().sorted().forEach(filter -> this.addChoosableFileFilter((FileFilter)filters.get(filter)));
        this.setFileFilter(allScripts);
        this.setFileSelectionMode(0);
    }

    private String fileForLanguage(String language) {
        try {
            return Bundle.getMessage(language);
        }
        catch (MissingResourceException missingResourceException) {
            if (!language.endsWith(Bundle.getMessage("files"))) {
                return String.valueOf(language) + " " + Bundle.getMessage("files");
            }
            return language;
        }
    }
}

