/*
 * Decompiled with CFR 0.152.
 */
package jmri.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import jmri.AddressedProgrammerManager;
import jmri.AudioManager;
import jmri.BlockManager;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.LightManager;
import jmri.MemoryManager;
import jmri.PowerManager;
import jmri.ReporterManager;
import jmri.RouteManager;
import jmri.SensorManager;
import jmri.ShutDownManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logix.WarrantManager;
import jmri.util.FileUtil;
import jmri.util.FileUtilSupport;
import org.apache.commons.io.FilenameUtils;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmriScriptEngineManager
implements InstanceManagerAutoDefault {
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final HashMap<String, String> names = new HashMap();
    private final HashMap<String, ScriptEngineFactory> factories = new HashMap();
    private final HashMap<String, ScriptEngine> engines = new HashMap();
    private final ScriptContext context;
    private static final Logger log = LoggerFactory.getLogger(JmriScriptEngineManager.class);
    static final String JYTHON_DEFAULTS = "jmri_defaults.py";
    private static final String EXTENSION = "extension";
    public static final String PYTHON = "jython";
    private PythonInterpreter jython = null;

    public JmriScriptEngineManager() {
        this.manager.getEngineFactories().stream().forEach(factory -> {
            log.info("{} {} is provided by {} {}", new Object[]{factory.getLanguageName(), factory.getLanguageVersion(), factory.getEngineName(), factory.getEngineVersion()});
            String engineName = factory.getEngineName();
            factory.getExtensions().stream().forEach(extension -> {
                this.names.put((String)extension, engineName);
                log.debug("\tExtension: {}", extension);
            });
            factory.getMimeTypes().stream().forEach(mimeType -> {
                this.names.put((String)mimeType, engineName);
                log.debug("\tMime type: {}", mimeType);
            });
            factory.getNames().stream().forEach(name -> {
                this.names.put((String)name, engineName);
                log.debug("\tNames: {}", name);
            });
            this.names.put(factory.getLanguageName(), engineName);
            this.names.put(engineName, engineName);
            this.factories.put(engineName, (ScriptEngineFactory)factory);
        });
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("sensors", (Object)InstanceManager.getNullableDefault(SensorManager.class));
        bindings.put("turnouts", (Object)InstanceManager.getNullableDefault(TurnoutManager.class));
        bindings.put("lights", (Object)InstanceManager.getNullableDefault(LightManager.class));
        bindings.put("signals", (Object)InstanceManager.getNullableDefault(SignalHeadManager.class));
        bindings.put("masts", (Object)InstanceManager.getNullableDefault(SignalMastManager.class));
        bindings.put("routes", (Object)InstanceManager.getNullableDefault(RouteManager.class));
        bindings.put("blocks", (Object)InstanceManager.getNullableDefault(BlockManager.class));
        bindings.put("reporters", (Object)InstanceManager.getNullableDefault(ReporterManager.class));
        bindings.put("memories", (Object)InstanceManager.getNullableDefault(MemoryManager.class));
        bindings.put("powermanager", (Object)InstanceManager.getNullableDefault(PowerManager.class));
        bindings.put("addressedProgrammers", (Object)InstanceManager.getNullableDefault(AddressedProgrammerManager.class));
        bindings.put("globalProgrammers", (Object)InstanceManager.getNullableDefault(GlobalProgrammerManager.class));
        bindings.put("dcc", (Object)InstanceManager.getNullableDefault(CommandStation.class));
        bindings.put("audio", (Object)InstanceManager.getNullableDefault(AudioManager.class));
        bindings.put("shutdown", (Object)InstanceManager.getNullableDefault(ShutDownManager.class));
        bindings.put("layoutblocks", (Object)InstanceManager.getNullableDefault(LayoutBlockManager.class));
        bindings.put("warrants", (Object)InstanceManager.getNullableDefault(WarrantManager.class));
        bindings.put("CLOSED", (Object)2);
        bindings.put("THROWN", (Object)4);
        bindings.put("CABLOCKOUT", (Object)1);
        bindings.put("PUSHBUTTONLOCKOUT", (Object)2);
        bindings.put("UNLOCKED", (Object)0);
        bindings.put("LOCKED", (Object)1);
        bindings.put("ACTIVE", (Object)2);
        bindings.put("INACTIVE", (Object)4);
        bindings.put("ON", (Object)2);
        bindings.put("OFF", (Object)4);
        bindings.put("UNKNOWN", (Object)1);
        bindings.put("INCONSISTENT", (Object)8);
        bindings.put("DARK", (Object)0);
        bindings.put("RED", (Object)1);
        bindings.put("YELLOW", (Object)4);
        bindings.put("GREEN", (Object)16);
        bindings.put("LUNAR", (Object)64);
        bindings.put("FLASHRED", (Object)2);
        bindings.put("FLASHYELLOW", (Object)8);
        bindings.put("FLASHGREEN", (Object)32);
        bindings.put("FLASHLUNAR", (Object)128);
        bindings.put("FileUtil", (Object)FileUtilSupport.getDefault());
        this.context = new SimpleScriptContext();
        this.context.setBindings(bindings, 200);
    }

    @Nonnull
    public static JmriScriptEngineManager getDefault() {
        return InstanceManager.getDefault(JmriScriptEngineManager.class);
    }

    @Nonnull
    public ScriptEngineManager getManager() {
        return this.manager;
    }

    @Nonnull
    public ScriptEngine getEngineByExtension(String extension) throws ScriptException {
        return this.getEngine(extension, EXTENSION);
    }

    @Nonnull
    public ScriptEngine getEngineByMimeType(String mimeType) throws ScriptException {
        return this.getEngine(mimeType, "mime type");
    }

    @Nonnull
    public ScriptEngine getEngineByName(String shortName) throws ScriptException {
        return this.getEngine(shortName, "name");
    }

    @Nonnull
    private ScriptEngine getEngine(@CheckForNull String engineName, @Nonnull String type) throws ScriptException {
        String name = this.names.get(engineName);
        ScriptEngine engine = this.getEngine(name);
        if (name == null || engine == null) {
            throw this.scriptEngineNotFound(engineName, type, false);
        }
        return engine;
    }

    @CheckForNull
    public ScriptEngine getEngine(@CheckForNull String name) {
        if (!this.engines.containsKey(name)) {
            if (PYTHON.equals(name = this.names.get(name))) {
                this.initializePython();
            } else {
                ScriptEngineFactory factory = this.factories.get(name);
                if (factory != null) {
                    log.debug("Create engine for {}", (Object)name);
                    ScriptEngine engine = factory.getScriptEngine();
                    engine.setContext(this.context);
                    this.engines.put(name, engine);
                }
            }
        }
        return this.engines.get(name);
    }

    public Object eval(String script, ScriptEngine engine) throws ScriptException {
        if (PYTHON.equals(engine.getFactory().getEngineName()) && this.jython != null) {
            this.jython.exec(script);
            return null;
        }
        return engine.eval(script);
    }

    @Deprecated
    public Object eval(Reader reader, ScriptEngine engine) throws ScriptException {
        return engine.eval(reader);
    }

    @Deprecated
    public Object eval(Reader reader, ScriptEngine engine, Bindings bindings) throws ScriptException {
        return engine.eval(reader, bindings);
    }

    @Deprecated
    public Object eval(Reader reader, ScriptEngine engine, ScriptContext context) throws ScriptException {
        return engine.eval(reader, context);
    }

    public Object eval(File file) throws ScriptException, IOException {
        return this.eval(file, null, null);
    }

    public Object eval(File file, Bindings bindings) throws ScriptException, IOException {
        return this.eval(file, null, bindings);
    }

    public Object eval(File file, ScriptContext context) throws ScriptException, IOException {
        return this.eval(file, context, null);
    }

    @CheckForNull
    private Object eval(File file, @CheckForNull ScriptContext context, @CheckForNull Bindings bindings) throws ScriptException, IOException {
        Object result = null;
        ScriptEngine engine = this.getEngineOrEval(file);
        if (engine != null) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                result = context != null ? engine.eval((Reader)reader, context) : (bindings != null ? engine.eval((Reader)reader, bindings) : engine.eval(reader));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return result;
    }

    @CheckForNull
    private ScriptEngine getEngineOrEval(File file) throws ScriptException, IOException {
        ScriptEngine engine = this.getEngine(FilenameUtils.getExtension((String)file.getName()), EXTENSION);
        if (PYTHON.equals(engine.getFactory().getEngineName()) && this.jython != null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream fi = new FileInputStream(file);){
                this.jython.execfile((InputStream)fi);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        }
        return engine;
    }

    public void runScript(File file) {
        try {
            this.eval(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("File {} not found.", (Object)file);
        }
        catch (IOException iOException) {
            log.error("Exception working with file {}", (Object)file);
        }
        catch (ScriptException ex) {
            log.error("Error in script {}.", (Object)file, (Object)ex);
        }
    }

    public void initializeAllEngines() {
        this.factories.keySet().stream().forEach(this::getEngine);
    }

    @Nonnull
    public ScriptContext getDefaultContext() {
        return this.context;
    }

    @Nonnull
    public ScriptEngineFactory getFactoryByExtension(String extension) throws ScriptException {
        return this.getFactory(extension, EXTENSION);
    }

    @Nonnull
    public ScriptEngineFactory getFactoryByMimeType(String mimeType) throws ScriptException {
        return this.getFactory(mimeType, "mime type");
    }

    @Nonnull
    public ScriptEngineFactory getFactoryByName(String shortName) throws ScriptException {
        return this.getFactory(shortName, "name");
    }

    @Nonnull
    private ScriptEngineFactory getFactory(@CheckForNull String factoryName, @Nonnull String type) throws ScriptException {
        String name = this.names.get(factoryName);
        ScriptEngineFactory factory = this.getFactory(name);
        if (name == null || factory == null) {
            throw this.scriptEngineNotFound(factoryName, type, true);
        }
        return factory;
    }

    @CheckForNull
    public ScriptEngineFactory getFactory(@CheckForNull String name) {
        if (!this.factories.containsKey(name)) {
            name = this.names.get(name);
        }
        return this.factories.get(name);
    }

    public void initializePython() {
        if (!this.engines.containsKey(PYTHON)) {
            this.initializePythonInterpreter(this.initializePythonState());
        }
    }

    public PythonInterpreter newPythonInterpreter() {
        this.initializePython();
        PythonInterpreter pi = new PythonInterpreter();
        this.context.getBindings(200).forEach((arg_0, arg_1) -> ((PythonInterpreter)pi).set(arg_0, arg_1));
        return pi;
    }

    private boolean initializePythonState() {
        InputStream is = FileUtil.findInputStream("python.properties", FileUtil.getUserFilesPath(), FileUtil.getProfilePath(), FileUtil.getPreferencesPath(), FileUtil.getProgramPath());
        Properties properties = new Properties(System.getProperties());
        properties.setProperty("python.console.encoding", StandardCharsets.UTF_8.name());
        properties.setProperty("python.cachedir", FileUtil.getAbsoluteFilename(properties.getProperty("python.cachedir", "settings:jython/cache")));
        boolean execJython = false;
        if (is != null) {
            String pythonPath = "python.path";
            try {
                properties.load(is);
                String path = properties.getProperty(pythonPath, "");
                if (path.length() != 0) {
                    path = path.concat(File.pathSeparator);
                }
                properties.setProperty(pythonPath, path.concat(FileUtil.getScriptsPath().concat(File.pathSeparator).concat(FileUtil.getAbsoluteFilename("program:jython"))));
                execJython = Boolean.valueOf(properties.getProperty("jython.exec", Boolean.toString(execJython)));
            }
            catch (IOException ex) {
                log.error("Found, but unable to read python.properties: {}", (Object)ex.getMessage());
            }
            log.debug("Jython path is {}", (Object)PySystemState.getBaseProperties().getProperty(pythonPath));
        }
        PySystemState.initialize(null, (Properties)properties);
        return execJython;
    }

    private void initializePythonInterpreter(boolean execJython) {
        try {
            log.debug("create interpreter");
            ScriptEngine python = this.manager.getEngineByName(PYTHON);
            python.setContext(this.context);
            this.engines.put(PYTHON, python);
            InputStream is = FileUtil.findInputStream(JYTHON_DEFAULTS, FileUtil.getUserFilesPath(), FileUtil.getProfilePath(), FileUtil.getPreferencesPath());
            if (execJython) {
                this.jython = this.newPythonInterpreter();
            }
            if (is != null) {
                python.eval(new InputStreamReader(is));
                if (this.jython != null) {
                    this.jython.execfile(is);
                }
            }
        }
        catch (ScriptException e) {
            log.error("Exception creating jython system objects", (Throwable)e);
        }
    }

    @CheckForNull
    PythonInterpreter getPythonInterpreter() {
        return this.jython;
    }

    private ScriptException scriptEngineNotFound(@CheckForNull String key, @Nonnull String type, boolean isFactory) {
        String expected = String.join((CharSequence)",", this.names.keySet());
        String factory = isFactory ? " factory" : "";
        log.error("Could not find script engine{} for {} \"{}\", expected one of {}", new Object[]{factory, type, key, expected});
        return new ScriptException(String.format("Could not find script engine%s for %s \"%s\" expected one of %s", factory, type, key, expected));
    }
}

