/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.table.AbstractTableModel;
import jmri.profile.Bundle;
import jmri.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchPathTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(SearchPathTableModel.class);

    public SearchPathTableModel() {
        ProfileManager.getDefault().addPropertyChangeListener(this);
    }

    @Override
    public int getRowCount() {
        return ProfileManager.getDefault().getSearchPaths().length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        File p = ProfileManager.getDefault().getSearchPaths(rowIndex);
        switch (columnIndex) {
            case -1: {
                return Bundle.getMessage("SearchPathTableModel.tooltip", ProfileManager.getDefault().getDefaultSearchPath().getPath());
            }
            case 0: {
                return p;
            }
            case 1: {
                return ProfileManager.getDefault().getDefaultSearchPath().equals(p);
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Bundle.getMessage("SearchPathTableModel.searchPath");
            }
            case 1: {
                return Bundle.getMessage("SearchPathTableModel.isDefault");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return File.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                try {
                    ProfileManager.getDefault().setDefaultSearchPath((File)this.getValueAt(rowIndex, 0));
                    break;
                }
                catch (IOException ex) {
                    log.warn("Unable to write profiles while setting default search path", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }
}

