/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.profile.AddProfileDialog;
import jmri.profile.Bundle;
import jmri.profile.Profile;
import jmri.profile.ProfileFileFilter;
import jmri.profile.ProfileFileView;
import jmri.profile.ProfileListCellRenderer;
import jmri.profile.ProfileListModel;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileManagerDialog
extends JDialog {
    private Timer timer;
    private int countDown;
    private boolean disableTimer;
    private JButton btnCreate;
    private JButton btnSelect;
    private JButton btnUseExisting;
    private JLabel countDownLbl;
    private JScrollPane jScrollPane1;
    private JLabel listLabel;
    private JList<Profile> profiles;
    private static final Logger log = LoggerFactory.getLogger(ProfileManagerDialog.class);

    public ProfileManagerDialog(Frame parent, boolean modal) {
        this(parent, modal, false);
    }

    public ProfileManagerDialog(Frame parent, boolean modal, boolean disableTimer) {
        super(parent, modal);
        this.disableTimer = disableTimer;
        this.initComponents();
        ProfileManager.getDefault().addPropertyChangeListener("activeProfile", evt -> {
            this.profiles.setSelectedValue(ProfileManager.getDefault().getActiveProfile(), true);
            this.profiles.ensureIndexIsVisible(this.profiles.getSelectedIndex());
            this.profiles.repaint();
        });
        ProfileManager.getDefault().addPropertyChangeListener("name", evt -> {
            if (evt.getSource().getClass().equals(Profile.class) && evt.getPropertyName().equals("name")) {
                this.profileNameChanged((Profile)evt.getSource());
            }
        });
        this.jScrollPane1.getVerticalScrollBar().addAdjustmentListener(e -> this.profilesValueChanged(null));
    }

    private void initComponents() {
        this.listLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.profiles = new JList();
        this.btnSelect = new JButton();
        this.btnCreate = new JButton();
        this.btnUseExisting = new JButton();
        this.countDownLbl = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(Bundle.getMessage("ProfileManagerDialog.title"));
        this.setMinimumSize(new Dimension(310, 110));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ProfileManagerDialog.this.formMousePressed(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                ProfileManagerDialog.this.formWindowOpened(evt);
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                ProfileManagerDialog.this.formWindowClosed(evt);
            }
        });
        this.listLabel.setText(Bundle.getMessage("ProfileManagerDialog.listLabel.text"));
        this.profiles.setModel(new ProfileListModel());
        this.profiles.setSelectedValue(ProfileManager.getDefault().getActiveProfile(), true);
        this.profiles.setSelectionMode(0);
        this.profiles.setToolTipText(Bundle.getMessage("ProfileManagerDialog.profiles.toolTipText"));
        this.profiles.setCellRenderer(new ProfileListCellRenderer());
        this.profiles.setNextFocusableComponent(this.btnSelect);
        this.profiles.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ProfileManagerDialog.this.profilesKeyPressed(evt);
            }
        });
        this.profiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ProfileManagerDialog.this.profilesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.profiles);
        this.profiles.ensureIndexIsVisible(this.profiles.getSelectedIndex());
        this.profiles.getAccessibleContext().setAccessibleName(Bundle.getMessage("ProfileManagerDialog.profiles.AccessibleContext.accessibleName"));
        this.profiles.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ProfileManagerDialog.profiles.toolTipText"));
        this.btnSelect.setText(Bundle.getMessage("ProfileManagerDialog.btnSelect.text"));
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileManagerDialog.this.btnSelectActionPerformed(evt);
            }
        });
        this.btnCreate.setText(Bundle.getMessage("ProfileManagerDialog.btnCreate.text"));
        this.btnCreate.setToolTipText(Bundle.getMessage("ProfilePreferencesPanel.btnCreateNewProfile.toolTipText"));
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileManagerDialog.this.btnCreateActionPerformed(evt);
            }
        });
        this.btnUseExisting.setText(Bundle.getMessage("ProfileManagerDialog.btnUseExisting.text"));
        this.btnUseExisting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileManagerDialog.this.btnUseExistingActionPerformed(evt);
            }
        });
        this.countDownLbl.setText(Bundle.getMessage("ProfileManagerDialog.countDownLbl.text"));
        this.countDownLbl.setToolTipText(Bundle.getMessage("ProfileManagerDialog.countDownLbl.toolTipText"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.listLabel).addComponent(this.countDownLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnUseExisting).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelect)).addComponent(this.jScrollPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 168, Short.MAX_VALUE).addComponent(this.listLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelect).addComponent(this.btnCreate).addComponent(this.btnUseExisting).addComponent(this.countDownLbl)).addContainerGap()));
        this.listLabel.getAccessibleContext().setAccessibleName(Bundle.getMessage("ProfileManagerDialog.listLabel.text"));
        this.pack();
    }

    private void btnSelectActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.countDown = -1;
        this.countDownLbl.setVisible(false);
        if (this.profiles.getSelectedValue() != null) {
            ProfileManager.getDefault().setActiveProfile(this.profiles.getSelectedValue());
            this.dispose();
        }
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.countDownLbl.setVisible(false);
        AddProfileDialog apd = new AddProfileDialog((Dialog)this, true, false);
        apd.setLocationRelativeTo(this);
        apd.setVisible(true);
    }

    private void btnUseExistingActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.countDownLbl.setVisible(false);
        JFileChooser chooser = new JFileChooser(FileUtil.getHomePath());
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new ProfileFileFilter());
        chooser.setFileView(new ProfileFileView());
        if (chooser.showOpenDialog(this) == 0) {
            try {
                Profile p = new Profile(chooser.getSelectedFile());
                ProfileManager.getDefault().addProfile(p);
                this.profiles.setSelectedValue(p, true);
            }
            catch (IOException iOException) {
                log.warn("{} is not a profile directory", (Object)chooser.getSelectedFile());
            }
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        this.countDown = ProfileManager.getDefault().getAutoStartActiveProfileTimeout();
        if (this.disableTimer) {
            this.countDownLbl.setText("");
        } else {
            this.countDownLbl.setText(Integer.toString(this.countDown));
        }
        this.timer = new Timer(1000, e -> {
            if (this.disableTimer) {
                return;
            }
            if (this.countDown > 0) {
                --this.countDown;
                this.countDownLbl.setText(Integer.toString(this.countDown));
            } else {
                this.setVisible(false);
                Profile profile = this.profiles.getSelectedValue();
                ProfileManager.getDefault().setActiveProfile(profile);
                if (profile != null) {
                    log.info("Automatically starting with profile {} after timeout.", (Object)profile.getId());
                } else {
                    log.info("Automatically starting without a profile");
                }
                this.timer.stop();
                this.countDown = -1;
                this.dispose();
            }
        });
        this.timer.setRepeats(true);
        if (this.profiles.getModel().getSize() > 0 && ProfileManager.getDefault().getActiveProfile() != null && this.countDown > 0) {
            this.timer.start();
        } else {
            this.countDownLbl.setVisible(false);
            this.btnSelect.setEnabled(false);
        }
    }

    public static Profile getStartingProfile(Frame f) throws IOException {
        ProfileManager manager = ProfileManager.getDefault();
        if (ProfileManager.getStartingProfile() == null || System.getProperty("org.jmri.profile") == null && !manager.isAutoStartActiveProfile()) {
            Profile last = manager.getActiveProfile();
            ProfileManagerDialog pmd = new ProfileManagerDialog(f, true);
            pmd.setLocationRelativeTo(f);
            pmd.setVisible(true);
            if (last == null || !last.equals(manager.getActiveProfile())) {
                manager.saveActiveProfile();
            }
        }
        return manager.getActiveProfile();
    }

    private void profileNameChanged(Profile p) {
        p.save();
        log.info("Saving profile {}", (Object)p.getId());
    }

    private void profilesValueChanged(ListSelectionEvent evt) {
        this.timer.stop();
        this.countDownLbl.setVisible(false);
        this.btnSelect.setEnabled(true);
    }

    private void formMousePressed(MouseEvent evt) {
        this.profilesValueChanged(null);
    }

    private void profilesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.btnSelect.doClick();
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="This exit ensures launch is aborted if a profile is not selected or autostarted")
    private void formWindowClosed(WindowEvent evt) {
        if (this.countDown != -1) {
            this.countDown = -1;
            System.exit(255);
        }
    }
}

