/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Application;
import jmri.InstanceManager;
import jmri.beans.Bean;
import jmri.implementation.FileLocationsPreferences;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.profile.Bundle;
import jmri.profile.Profile;
import jmri.util.FileUtil;
import jmri.util.prefs.InitializationException;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class ProfileManager
extends Bean {
    private final ArrayList<Profile> profiles = new ArrayList();
    private final ArrayList<File> searchPaths = new ArrayList();
    private Profile activeProfile = null;
    private Profile nextActiveProfile = null;
    private final File catalog;
    private File configFile = null;
    private boolean readingProfiles = false;
    private boolean autoStartActiveProfile = false;
    private File defaultSearchPath = new File(FileUtil.getPreferencesPath());
    private int autoStartActiveProfileTimeout = 10;
    private static volatile ProfileManager defaultInstance = null;
    public static final String ACTIVE_PROFILE = "activeProfile";
    public static final String NEXT_PROFILE = "nextProfile";
    private static final String AUTO_START = "autoStart";
    private static final String AUTO_START_TIMEOUT = "autoStartTimeout";
    private static final String CATALOG = "profiles.xml";
    private static final String PROFILE = "profile";
    public static final String PROFILES = "profiles";
    private static final String PROFILECONFIG = "profileConfig";
    public static final String SEARCH_PATHS = "searchPaths";
    public static final String DEFAULT = "default";
    public static final String DEFAULT_SEARCH_PATH = "defaultSearchPath";
    public static final String SYSTEM_PROPERTY = "org.jmri.profile";
    private static final Logger log = LoggerFactory.getLogger(ProfileManager.class);

    public ProfileManager() {
        this(new File(String.valueOf(FileUtil.getPreferencesPath()) + CATALOG));
    }

    public ProfileManager(File catalog) {
        this.catalog = catalog;
        try {
            this.readProfiles();
            this.findProfiles();
        }
        catch (IOException | JDOMException ex) {
            log.error(ex.getLocalizedMessage(), ex);
        }
    }

    @Nonnull
    public static ProfileManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfileManager();
        }
        return defaultInstance;
    }

    @CheckForNull
    public Profile getActiveProfile() {
        return this.activeProfile;
    }

    @CheckForNull
    public String getActiveProfileName() {
        return this.activeProfile != null ? this.activeProfile.getName() : null;
    }

    public void setActiveProfile(@CheckForNull String identifier) {
        log.debug("setActiveProfile called with {}", (Object)identifier);
        if (identifier == null) {
            Profile old = this.activeProfile;
            this.activeProfile = null;
            this.firePropertyChange(ACTIVE_PROFILE, old, null);
            log.debug("Setting active profile to null");
            return;
        }
        File profileFile = new File(identifier);
        File profileFileWithExt = new File(profileFile.getParent(), String.valueOf(profileFile.getName()) + ".jmri");
        if (Profile.isProfile(profileFileWithExt)) {
            profileFile = profileFileWithExt;
        }
        log.debug("profileFile exists(): {}", (Object)profileFile.exists());
        log.debug("profileFile isDirectory(): {}", (Object)profileFile.isDirectory());
        if (profileFile.exists() && profileFile.isDirectory()) {
            if (Profile.isProfile(profileFile)) {
                try {
                    log.debug("try setActiveProfile with new Profile({})", (Object)profileFile);
                    this.setActiveProfile(new Profile(profileFile));
                    log.debug("  success");
                    return;
                }
                catch (IOException ex) {
                    log.error("Unable to use profile path {} to set active profile.", (Object)identifier, (Object)ex);
                }
            } else {
                log.error("{} is not a profile folder.", (Object)identifier);
            }
        }
        for (Profile p : this.profiles) {
            log.debug("Looking for profile {}, found {}", (Object)identifier, (Object)p.getId());
            if (!p.getId().equals(identifier)) continue;
            this.setActiveProfile(p);
            return;
        }
        log.warn("Unable to set active profile. No profile with id {} could be found.", (Object)identifier);
    }

    public void setActiveProfile(@CheckForNull Profile profile) {
        Profile old = this.activeProfile;
        if (profile == null) {
            this.activeProfile = null;
            this.firePropertyChange(ACTIVE_PROFILE, old, null);
            log.debug("Setting active profile to null");
            return;
        }
        this.activeProfile = profile;
        this.firePropertyChange(ACTIVE_PROFILE, old, profile);
        log.debug("Setting active profile to {}", (Object)profile.getId());
    }

    @CheckForNull
    public Profile getNextActiveProfile() {
        return this.nextActiveProfile;
    }

    protected void setNextActiveProfile(@CheckForNull Profile profile) {
        Profile old = this.nextActiveProfile;
        if (profile == null) {
            this.nextActiveProfile = null;
            this.firePropertyChange(NEXT_PROFILE, old, null);
            log.debug("Setting next active profile to null");
            return;
        }
        this.nextActiveProfile = profile;
        this.firePropertyChange(NEXT_PROFILE, old, profile);
        log.debug("Setting next active profile to {}", (Object)profile.getId());
    }

    public void saveActiveProfile() throws IOException {
        this.saveActiveProfile(this.getActiveProfile(), this.autoStartActiveProfile);
    }

    protected void saveActiveProfile(@CheckForNull Profile profile, boolean autoStart) throws IOException {
        Properties p = new Properties();
        FileOutputStream os = null;
        File config = this.getConfigFile();
        if (config == null) {
            log.debug("No config file defined, not attempting to save active profile.");
            return;
        }
        if (profile != null) {
            p.setProperty(ACTIVE_PROFILE, profile.getId());
            p.setProperty(AUTO_START, Boolean.toString(autoStart));
            p.setProperty(AUTO_START_TIMEOUT, Integer.toString(this.getAutoStartActiveProfileTimeout()));
        }
        if (!config.exists() && !config.createNewFile()) {
            throw new IOException("Unable to create file at " + config.getAbsolutePath());
        }
        try {
            os = new FileOutputStream(config);
            p.storeToXML(os, "Active profile configuration (saved at " + new Date().toString() + ")");
            os.close();
        }
        catch (IOException ex) {
            log.error("While trying to save active profile {}", (Object)config, (Object)ex);
            if (os != null) {
                os.close();
            }
            throw ex;
        }
    }

    public void readActiveProfile() throws IOException {
        Properties p = new Properties();
        FileInputStream is = null;
        File config = this.getConfigFile();
        if (config != null && config.exists() && config.length() != 0L) {
            try {
                is = new FileInputStream(config);
                try {
                    p.loadFromXML(is);
                }
                catch (IOException ex) {
                    is.close();
                    if (ex.getCause().getClass().equals(SAXParseException.class)) {
                        is = new FileInputStream(config);
                        p.load(is);
                    }
                    throw ex;
                }
                is.close();
            }
            catch (IOException ex) {
                if (is != null) {
                    is.close();
                }
                throw ex;
            }
            this.setActiveProfile(p.getProperty(ACTIVE_PROFILE));
            if (p.containsKey(AUTO_START)) {
                this.setAutoStartActiveProfile(Boolean.parseBoolean(p.getProperty(AUTO_START)));
            }
            if (p.containsKey(AUTO_START_TIMEOUT)) {
                this.setAutoStartActiveProfileTimeout(Integer.parseInt(p.getProperty(AUTO_START_TIMEOUT)));
            }
        }
    }

    @Nonnull
    public Profile[] getProfiles() {
        return this.profiles.toArray(new Profile[this.profiles.size()]);
    }

    @Nonnull
    public List<Profile> getAllProfiles() {
        return new ArrayList<Profile>(this.profiles);
    }

    @CheckForNull
    public Profile getProfiles(int index) {
        if (index >= 0 && index < this.profiles.size()) {
            return this.profiles.get(index);
        }
        return null;
    }

    public void setProfiles(Profile profile, int index) {
        Profile oldProfile = this.profiles.get(index);
        if (!this.readingProfiles) {
            this.profiles.set(index, profile);
            this.fireIndexedPropertyChange(PROFILES, index, oldProfile, profile);
        }
    }

    protected void addProfile(Profile profile) {
        if (!this.profiles.contains(profile)) {
            this.profiles.add(profile);
            if (!this.readingProfiles) {
                this.profiles.sort(null);
                int index = this.profiles.indexOf(profile);
                this.fireIndexedPropertyChange(PROFILES, index, null, profile);
                if (index != this.profiles.size() - 1) {
                    int i = index + 1;
                    while (i < this.profiles.size() - 1) {
                        this.fireIndexedPropertyChange(PROFILES, i, this.profiles.get(i + 1), this.profiles.get(i));
                        ++i;
                    }
                    this.fireIndexedPropertyChange(PROFILES, this.profiles.size() - 1, null, this.profiles.get(this.profiles.size() - 1));
                }
                try {
                    this.writeProfiles();
                }
                catch (IOException ex) {
                    log.warn("Unable to write profiles while adding profile {}.", (Object)profile.getId(), (Object)ex);
                }
            }
        }
    }

    protected void removeProfile(Profile profile) {
        try {
            int index = this.profiles.indexOf(profile);
            if (index >= 0) {
                if (this.profiles.remove(profile)) {
                    this.fireIndexedPropertyChange(PROFILES, index, profile, null);
                    this.writeProfiles();
                }
                if (profile != null && profile.equals(this.getNextActiveProfile())) {
                    this.setNextActiveProfile(null);
                    this.saveActiveProfile(this.getActiveProfile(), this.autoStartActiveProfile);
                }
            }
        }
        catch (IOException ex) {
            log.warn("Unable to write profiles while removing profile {}.", (Object)profile.getId(), (Object)ex);
        }
    }

    @Nonnull
    public File[] getSearchPaths() {
        return this.searchPaths.toArray(new File[this.searchPaths.size()]);
    }

    public ArrayList<File> getAllSearchPaths() {
        return this.searchPaths;
    }

    @CheckForNull
    public File getSearchPaths(int index) {
        if (index >= 0 && index < this.searchPaths.size()) {
            return this.searchPaths.get(index);
        }
        return null;
    }

    protected void addSearchPath(@Nonnull File path) throws IOException {
        if (!this.searchPaths.contains(path)) {
            this.searchPaths.add(path);
            if (!this.readingProfiles) {
                int index = this.searchPaths.indexOf(path);
                this.fireIndexedPropertyChange(SEARCH_PATHS, index, null, path);
                this.writeProfiles();
            }
            this.findProfiles(path);
        }
    }

    protected void removeSearchPath(@Nonnull File path) throws IOException {
        if (this.searchPaths.contains(path)) {
            int index = this.searchPaths.indexOf(path);
            this.searchPaths.remove(path);
            this.fireIndexedPropertyChange(SEARCH_PATHS, index, path, null);
            this.writeProfiles();
            if (this.getDefaultSearchPath().equals(path)) {
                this.setDefaultSearchPath(new File(FileUtil.getPreferencesPath()));
            }
        }
    }

    @Nonnull
    protected File getDefaultSearchPath() {
        return this.defaultSearchPath;
    }

    protected void setDefaultSearchPath(@Nonnull File defaultSearchPath) throws IOException {
        Objects.requireNonNull(defaultSearchPath);
        if (!defaultSearchPath.equals(this.defaultSearchPath)) {
            File oldDefault = this.defaultSearchPath;
            this.defaultSearchPath = defaultSearchPath;
            this.firePropertyChange(DEFAULT_SEARCH_PATH, oldDefault, this.defaultSearchPath);
            this.writeProfiles();
        }
    }

    private void readProfiles() throws JDOMException, IOException {
        try {
            boolean reWrite = false;
            if (!this.catalog.exists()) {
                this.writeProfiles();
            }
            if (!this.catalog.canRead()) {
                return;
            }
            this.readingProfiles = true;
            Document doc = new SAXBuilder().build(this.catalog);
            this.profiles.clear();
            for (Element e : doc.getRootElement().getChild(PROFILES).getChildren()) {
                File pp = FileUtil.getFile(null, e.getAttributeValue("path"));
                try {
                    Profile p = new Profile(pp);
                    this.addProfile(p);
                    if (p.getPath().equals(pp)) continue;
                    reWrite = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.info("Cataloged profile \"{}\" not in expected location\nSearching for it in {}", (Object)e.getAttributeValue("id"), (Object)pp.getParentFile());
                    this.findProfiles(pp.getParentFile());
                    reWrite = true;
                }
            }
            this.searchPaths.clear();
            for (Element e : doc.getRootElement().getChild(SEARCH_PATHS).getChildren()) {
                File path = FileUtil.getFile(null, e.getAttributeValue("path"));
                if (!this.searchPaths.contains(path)) {
                    this.addSearchPath(path);
                }
                if (!Boolean.parseBoolean(e.getAttributeValue(DEFAULT))) continue;
                this.defaultSearchPath = path;
            }
            if (this.searchPaths.isEmpty()) {
                this.addSearchPath(FileUtil.getFile(null, FileUtil.getPreferencesPath()));
            }
            this.readingProfiles = false;
            if (reWrite) {
                this.writeProfiles();
            }
            this.profiles.sort(null);
        }
        catch (IOException | JDOMException ex) {
            this.readingProfiles = false;
            throw ex;
        }
    }

    private void writeProfiles() throws IOException {
        if (!new File(FileUtil.getPreferencesPath()).canWrite()) {
            return;
        }
        FileWriter fw = null;
        Document doc = new Document();
        doc.setRootElement(new Element(PROFILECONFIG));
        Element profilesElement = new Element(PROFILES);
        Element pathsElement = new Element(SEARCH_PATHS);
        this.profiles.stream().map(p -> {
            Element e = new Element(PROFILE);
            e.setAttribute("id", p.getId());
            e.setAttribute("path", FileUtil.getPortableFilename(null, p.getPath(), true, true));
            return e;
        }).forEach(e -> profilesElement.addContent((Content)e));
        this.searchPaths.stream().map(f -> {
            Element e = new Element("path");
            e.setAttribute("path", FileUtil.getPortableFilename(null, f.getPath(), true, true));
            e.setAttribute(DEFAULT, Boolean.toString(f.equals(this.defaultSearchPath)));
            return e;
        }).forEach(e -> pathsElement.addContent((Content)e));
        doc.getRootElement().addContent((Content)profilesElement);
        doc.getRootElement().addContent((Content)pathsElement);
        try {
            fw = new FileWriter(this.catalog);
            XMLOutputter fmt = new XMLOutputter();
            fmt.setFormat(Format.getPrettyFormat().setLineSeparator(System.getProperty("line.separator")).setTextMode(Format.TextMode.NORMALIZE));
            fmt.output(doc, (Writer)fw);
            fw.close();
        }
        catch (IOException ex) {
            if (fw != null) {
                fw.close();
            }
            throw ex;
        }
    }

    private void findProfiles() {
        this.searchPaths.stream().forEach(searchPath -> this.findProfiles((File)searchPath));
    }

    private void findProfiles(@Nonnull File searchPath) {
        File[] profilePaths = searchPath.listFiles(pathname -> Profile.isProfile(pathname));
        if (profilePaths == null) {
            log.error("There was an error reading directory {}.", (Object)searchPath.getPath());
            return;
        }
        File[] fileArray = profilePaths;
        int n = profilePaths.length;
        int n2 = 0;
        while (n2 < n) {
            File pp = fileArray[n2];
            try {
                Profile p = new Profile(pp);
                this.addProfile(p);
            }
            catch (IOException ex) {
                log.error("Error attempting to read Profile at {}", (Object)pp, (Object)ex);
            }
            ++n2;
        }
    }

    @CheckForNull
    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(@Nonnull File configFile) {
        this.configFile = configFile;
        log.debug("Using config file {}", (Object)configFile);
    }

    public boolean isAutoStartActiveProfile() {
        return this.getActiveProfile() != null && this.autoStartActiveProfile;
    }

    public void setAutoStartActiveProfile(boolean autoStartActiveProfile) {
        this.autoStartActiveProfile = autoStartActiveProfile;
    }

    @CheckForNull
    public Profile createDefaultProfile() throws IllegalArgumentException, IOException {
        if (this.getAllProfiles().isEmpty()) {
            String pn = Bundle.getMessage("defaultProfileName");
            String pid = FileUtil.sanitizeFilename(pn);
            File pp = new File(String.valueOf(FileUtil.getPreferencesPath()) + pid + ".jmri");
            Profile profile = new Profile(pn, pid, pp);
            this.addProfile(profile);
            this.setAutoStartActiveProfile(true);
            log.info("Created default profile \"{}\"", (Object)pn);
            return profile;
        }
        return null;
    }

    @Nonnull
    public Profile migrateConfigToProfile(@Nonnull File config, @Nonnull String name) throws IllegalArgumentException, IOException {
        String pid = FileUtil.sanitizeFilename(name);
        File pp = new File(FileUtil.getPreferencesPath(), String.valueOf(pid) + ".jmri");
        Profile profile = new Profile(name, pid, pp);
        FileUtil.copy(config, new File(profile.getPath(), "ProfileConfig.xml"));
        FileUtil.copy(new File(config.getParentFile(), "UserPrefs" + config.getName()), new File(profile.getPath(), "UserPrefsProfileConfig.xml"));
        this.addProfile(profile);
        log.info("Migrated \"{}\" config to profile \"{}\"", (Object)name, (Object)name);
        return profile;
    }

    public boolean migrateToProfiles(@Nonnull String configFilename) throws IllegalArgumentException, IOException {
        File appConfigFile = new File(configFilename);
        boolean didMigrate = false;
        if (!appConfigFile.isAbsolute()) {
            appConfigFile = new File(String.valueOf(FileUtil.getPreferencesPath()) + configFilename);
        }
        if (this.getAllProfiles().isEmpty()) {
            if (!appConfigFile.exists()) {
                this.setActiveProfile(this.createDefaultProfile());
                this.saveActiveProfile();
            } else {
                this.setActiveProfile(this.migrateConfigToProfile(appConfigFile, Application.getApplicationName()));
                this.saveActiveProfile();
                didMigrate = true;
            }
        } else if (appConfigFile.exists()) {
            try {
                this.setActiveProfile(this.migrateConfigToProfile(appConfigFile, Application.getApplicationName()));
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().startsWith("A profile already exists at ")) {
                    this.setActiveProfile(this.migrateConfigToProfile(appConfigFile, appConfigFile.getName().substring(0, appConfigFile.getName().length() - 4)));
                }
                throw ex;
            }
            this.saveActiveProfile();
            didMigrate = true;
        }
        return didMigrate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void export(@Nonnull Profile profile, @Nonnull File target, boolean exportExternalUserFiles, boolean exportExternalRoster) throws IOException, JDOMException, InitializationException {
        File tempDir;
        block16: {
            if (!target.exists() && !target.createNewFile()) {
                throw new IOException("Unable to create file " + target);
            }
            String tempDirPath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "JMRI" + System.currentTimeMillis();
            FileUtil.createDirectory(tempDirPath);
            tempDir = new File(tempDirPath);
            File tempProfilePath = new File(tempDir, profile.getPath().getName());
            FileUtil.copy(profile.getPath(), tempProfilePath);
            Profile tempProfile = new Profile(tempProfilePath);
            InstanceManager.getDefault(FileLocationsPreferences.class).initialize(profile);
            InstanceManager.getDefault(FileLocationsPreferences.class).initialize(tempProfile);
            InstanceManager.getDefault(RosterConfigManager.class).initialize(profile);
            InstanceManager.getDefault(RosterConfigManager.class).initialize(tempProfile);
            if (exportExternalUserFiles) {
                FileUtil.copy(new File(FileUtil.getUserFilesPath(profile)), tempProfilePath);
                FileUtil.setUserFilesPath(tempProfile, FileUtil.getProfilePath(tempProfile));
                InstanceManager.getDefault(FileLocationsPreferences.class).savePreferences(tempProfile);
            }
            if (exportExternalRoster) {
                FileUtil.copy(new File(Roster.getRoster(profile).getRosterIndexPath()), new File(tempProfilePath, "roster.xml"));
                FileUtil.copy(new File(Roster.getRoster(profile).getRosterLocation(), "roster"), new File(tempProfilePath, "roster"));
                InstanceManager.getDefault(RosterConfigManager.class).setDirectory(profile, FileUtil.getPortableFilename(profile, tempProfilePath));
                InstanceManager.getDefault(RosterConfigManager.class).savePreferences(profile);
            }
            Throwable throwable = null;
            Object var10_11 = null;
            try {
                FileOutputStream out = new FileOutputStream(target);
                try {
                    try (ZipOutputStream zip = new ZipOutputStream(out);){
                        this.exportDirectory(zip, tempProfilePath, tempProfilePath.getPath());
                    }
                    if (out == null) break block16;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        FileUtil.delete(tempDir);
    }

    private void exportDirectory(@Nonnull ZipOutputStream zip, @Nonnull File source, @Nonnull String root) throws IOException {
        File[] files = source.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (!Profile.isProfile(file)) {
                        ZipEntry entry = new ZipEntry(this.relativeName(file, root));
                        entry.setTime(file.lastModified());
                        zip.putNextEntry(entry);
                        this.exportDirectory(zip, file, root);
                    }
                } else {
                    this.exportFile(zip, file, root);
                }
                ++n2;
            }
        }
    }

    private void exportFile(@Nonnull ZipOutputStream zip, @Nonnull File source, @Nonnull String root) throws IOException {
        byte[] buffer = new byte[1024];
        Throwable throwable = null;
        Object var7_7 = null;
        try (FileInputStream input = new FileInputStream(source);){
            int length;
            ZipEntry entry = new ZipEntry(this.relativeName(source, root));
            entry.setTime(source.lastModified());
            zip.putNextEntry(entry);
            while ((length = input.read(buffer)) > 0) {
                zip.write(buffer, 0, length);
            }
            zip.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nonnull
    private String relativeName(@Nonnull File file, @Nonnull String root) {
        String path = file.getPath();
        if (path.startsWith(root)) {
            path = path.substring(root.length());
        }
        if (file.isDirectory() && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path.replace(File.separator, "/");
    }

    @CheckForNull
    public static Profile getStartingProfile() throws IOException {
        if (ProfileManager.getDefault().getActiveProfile() == null) {
            ProfileManager.getDefault().readActiveProfile();
            if (ProfileManager.getDefault().getProfiles().length == 1) {
                ProfileManager.getDefault().setActiveProfile(ProfileManager.getDefault().getProfiles(0));
            } else if (!ProfileManager.getDefault().isAutoStartActiveProfile()) {
                return null;
            }
        }
        return ProfileManager.getDefault().getActiveProfile();
    }

    @Nonnull
    public static String createUniqueId() {
        return Integer.toHexString(Float.floatToIntBits((float)Math.random()));
    }

    void profileNameChange(Profile profile, String oldName) {
        this.firePropertyChange(new PropertyChangeEvent(profile, "name", oldName, profile.getName()));
    }

    public int getAutoStartActiveProfileTimeout() {
        return this.autoStartActiveProfileTimeout;
    }

    public void setAutoStartActiveProfileTimeout(int autoStartActiveProfileTimeout) {
        int old = this.autoStartActiveProfileTimeout;
        if (autoStartActiveProfileTimeout < 0 || autoStartActiveProfileTimeout > 500) {
            autoStartActiveProfileTimeout = 0;
        }
        if (old != autoStartActiveProfileTimeout) {
            this.autoStartActiveProfileTimeout = autoStartActiveProfileTimeout;
            this.firePropertyChange(AUTO_START_TIMEOUT, old, this.autoStartActiveProfileTimeout);
        }
    }
}

