/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileView;
import jmri.profile.Bundle;
import jmri.profile.Profile;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileFileView
extends FileView {
    private static final Logger log = LoggerFactory.getLogger(ProfileFileView.class);

    @Override
    public String getDescription(File f) {
        if (!this.isTraversable(f).booleanValue()) {
            return Bundle.getMessage("FileViewDescription", f.getName());
        }
        return null;
    }

    @Override
    public Boolean isTraversable(File f) {
        try {
            if (Profile.isProfile(f)) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            log.debug("Unable to list contents of {}", (Object)f.getPath());
        }
        return true;
    }

    @Override
    public Icon getIcon(File f) {
        if (!this.isTraversable(f).booleanValue()) {
            return new ImageIcon(FileUtil.findURL("resources/jmri16x16.gif"));
        }
        return null;
    }
}

