/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profile
implements Comparable<Profile> {
    private String name;
    private String id;
    private File path;
    public static final String PROFILE = "profile";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String PATH = "path";
    public static final String PROPERTIES = "profile.properties";
    public static final String CONFIG = "profile.xml";
    public static final String SHARED_PROPERTIES = "profile/profile.properties";
    public static final String SHARED_CONFIG = "profile/profile.xml";
    public static final String CONFIG_FILENAME = "ProfileConfig.xml";
    public static final String UI_CONFIG = "user-interface.xml";
    public static final String SHARED_UI_CONFIG = "profile/user-interface.xml";
    public static final String UI_CONFIG_FILENAME = "UserPrefsProfileConfig.xml";
    public static final String EXTENSION = ".jmri";
    private static final Logger log = LoggerFactory.getLogger(Profile.class);

    public Profile(@Nonnull File path) throws IOException {
        this(path, true);
    }

    public Profile(@Nonnull String name, @Nonnull String id, @Nonnull File path) throws IOException {
        File pathWithExt = path.getName().endsWith(EXTENSION) ? path : new File(path.getParentFile(), String.valueOf(path.getName()) + EXTENSION);
        if (!pathWithExt.getName().equals(String.valueOf(id) + EXTENSION)) {
            throw new IllegalArgumentException(String.valueOf(id) + " " + path.getName() + " do not match");
        }
        if (Profile.isProfile(path) || Profile.isProfile(pathWithExt)) {
            throw new IllegalArgumentException("A profile already exists at " + path);
        }
        if (Profile.containsProfile(path) || Profile.containsProfile(pathWithExt)) {
            throw new IllegalArgumentException(path + " contains a profile in a subdirectory.");
        }
        if (Profile.inProfile(path) || Profile.inProfile(pathWithExt)) {
            if (Profile.inProfile(path)) {
                log.warn("Exception: Path {} is within an existing profile.", (Object)path, (Object)new Exception("traceback"));
            }
            if (Profile.inProfile(pathWithExt)) {
                log.warn("Exception: pathWithExt {} is within an existing profile.", (Object)pathWithExt, (Object)new Exception("traceback"));
            }
            throw new IllegalArgumentException(path + " is within an existing profile.");
        }
        this.name = name;
        this.id = String.valueOf(id) + "." + ProfileManager.createUniqueId();
        this.path = pathWithExt;
        if (!this.path.exists() && !this.path.mkdirs()) {
            throw new IOException("Unable to create directory " + this.path);
        }
        if (!this.path.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory");
        }
        this.save();
        if (!Profile.isProfile(this.path)) {
            throw new IllegalArgumentException(path + " does not contain a profile.properties file");
        }
    }

    protected Profile(@Nonnull File path, boolean isReadable) throws IOException {
        this(path, ProfileManager.createUniqueId(), isReadable);
    }

    protected Profile(@Nonnull File path, @Nonnull String id, boolean isReadable) throws IOException {
        File pathWithExt = path.getName().endsWith(EXTENSION) ? path : new File(path.getParentFile(), String.valueOf(path.getName()) + EXTENSION);
        this.path = !path.exists() && pathWithExt.exists() ? pathWithExt : path;
        this.id = id;
        if (isReadable) {
            this.readProfile();
        }
    }

    protected final void save() {
        ProfileProperties p = new ProfileProperties(this);
        p.put(NAME, this.name, true);
        p.put(ID, this.id, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        ProfileManager.getDefault().profileNameChange(this, oldName);
    }

    protected final void setNameInConstructor(String name) {
        this.name = name;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public File getPath() {
        return this.path;
    }

    private void readProfile() {
        String readName;
        ProfileProperties p = new ProfileProperties(this.path);
        String readId = p.get(ID, true);
        if (readId != null) {
            this.id = readId;
        }
        if ((readName = p.get(NAME, true)) != null) {
            this.name = readName;
        }
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Profile other = (Profile)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean isComplete() {
        return new File(this.getPath(), SHARED_PROPERTIES).exists();
    }

    public String getUniqueId() {
        return this.id.substring(this.id.lastIndexOf(46) + 1);
    }

    public static boolean containsProfile(File path) {
        if (path.isDirectory()) {
            if (Profile.isProfile(path)) {
                return true;
            }
            File[] files = path.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (Profile.containsProfile(file)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public static boolean inProfile(File path) {
        if (path.getParentFile() != null) {
            if (Profile.isProfile(path.getParentFile())) {
                return true;
            }
            return Profile.inProfile(path.getParentFile());
        }
        return false;
    }

    public static boolean isProfile(File path) {
        if (path.exists() && path.isDirectory()) {
            if (new File(path, SHARED_PROPERTIES).canRead()) {
                return true;
            }
            if (new File(path, PROPERTIES).canRead() && !path.getName().equals(PROFILE)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(Profile o) {
        if (this.equals(o)) {
            return 0;
        }
        String thisString = this.getName() + this.getPath();
        String thatString = o.getName() + o.getPath();
        return thisString.compareTo(thatString);
    }
}

