/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.implementation.SignalMastRepeater;
import jmri.managers.DefaultSignalMastManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalMastManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalMastManagerXml.class);

    @Override
    public Element store(Object o) {
        Element signalmasts = new Element("signalmasts");
        signalmasts.setAttribute("class", this.getClass().getName());
        DefaultSignalMastManager smm = (DefaultSignalMastManager)o;
        if (smm != null) {
            SortedSet smList = smm.getNamedBeanSet();
            if (smList.isEmpty()) {
                return null;
            }
            for (SignalMast sm : smList) {
                Element e = ConfigXmlManager.elementFromObject(sm);
                if (e == null) continue;
                signalmasts.addContent((Content)e);
            }
            List<SignalMastRepeater> repeaterList = smm.getRepeaterList();
            if (repeaterList.size() > 0) {
                for (SignalMastRepeater smr : repeaterList) {
                    Element e = new Element("signalmastrepeater");
                    e.addContent((Content)new Element("masterMast").addContent(smr.getMasterMastName()));
                    e.addContent((Content)new Element("slaveMast").addContent(smr.getSlaveMastName()));
                    e.addContent((Content)new Element("enabled").addContent(smr.getEnabled() ? "true" : "false"));
                    switch (smr.getDirection()) {
                        case 1: {
                            e.addContent((Content)new Element("update").addContent("MasterToSlave"));
                            break;
                        }
                        case 2: {
                            e.addContent((Content)new Element("update").addContent("SlaveToMaster"));
                            break;
                        }
                        default: {
                            e.addContent((Content)new Element("update").addContent("BothWay"));
                        }
                    }
                    signalmasts.addContent((Content)e);
                }
            }
        }
        return signalmasts;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List mastList = shared.getChildren("signalmast");
        boolean result = true;
        for (Element e : mastList) {
            if (e.getAttribute("class") == null) {
                String sys = this.getSystemName(e);
                try {
                    SignalMast m = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(sys);
                    if (this.getUserName(e) != null) {
                        m.setUserName(this.getUserName(e));
                    }
                    this.loadCommon(m, e);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.warn("Failed to provide SignalMast \"{}\" in load", (Object)sys);
                }
                continue;
            }
            String adapterName = e.getAttribute("class").getValue();
            log.debug("load via {}", (Object)adapterName);
            try {
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.load(e, null);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JmriConfigureXmlException ex) {
                log.error("Exception while loading {}: {}", new Object[]{e.getName(), ex, ex});
            }
        }
        this.loadSignalMastClass(shared, "turnoutsignalmast");
        this.loadSignalMastClass(shared, "virtualsignalmast");
        this.loadSignalMastClass(shared, "matrixsignalmast");
        this.loadSignalMastClass(shared, "dccsignalmast");
        this.loadSignalMastClass(shared, "olcbsignalmast");
        mastList = shared.getChildren("signalmastrepeater");
        if (mastList != null) {
            DefaultSignalMastManager m = (DefaultSignalMastManager)InstanceManager.getDefault(SignalMastManager.class);
            for (Element e : mastList) {
                String masterName = e.getChild("masterMast").getText();
                String slaveName = e.getChild("slaveMast").getText();
                SignalMast masterMast = m.getSignalMast(masterName);
                if (masterMast == null) {
                    log.error("Unable to add mast repeater {}: {}. Master mast must exist.", (Object)masterName, (Object)slaveName);
                    result = false;
                    continue;
                }
                SignalMast slaveMast = m.getSignalMast(slaveName);
                if (slaveMast == null) {
                    log.error("Unable to add mast repeater {}: {}. Slave mast must exist.", (Object)masterName, (Object)slaveName);
                    result = false;
                    continue;
                }
                SignalMastRepeater smr = null;
                try {
                    smr = m.provideRepeater(masterMast, slaveMast);
                }
                catch (JmriException e1) {
                    log.error("Unable to add mast repeater {}: {}. {}", new Object[]{masterName, slaveName, e1});
                    result = false;
                    continue;
                }
                if (e.getChild("enabled") != null && e.getChild("enabled").getText().equals("false")) {
                    smr.setEnabled(false);
                }
                if (e.getChild("update") == null) continue;
                if (e.getChild("update").getText().equals("MasterToSlave")) {
                    smr.setDirection(1);
                    continue;
                }
                if (!e.getChild("update").getText().equals("SlaveToMaster")) continue;
                smr.setDirection(2);
            }
            m.initialiseRepeaters();
        }
        return result;
    }

    private void loadSignalMastClass(Element shared, String signalMastClass) {
        List mastClassList = shared.getChildren(signalMastClass);
        log.debug("Found {} signal masts", (Object)mastClassList.size());
        boolean result = this.loadInAdapter(mastClassList, null);
        if (!result) {
            log.warn("error loading signalmasts");
        }
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(SignalMastManager.class).getXMLOrder();
    }
}

