/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.NamedBeanComparator;
import jmri.util.NamedBeanHandleComparator;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalMastLogicManagerXml
extends AbstractNamedBeanManagerConfigXML {
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalMastLogicManagerXml.class);

    @Override
    public Element store(Object o) {
        Element signalMastLogic = new Element("signalmastlogics");
        this.setStoreElementClass(signalMastLogic);
        SignalMastLogicManager smlm = (SignalMastLogicManager)o;
        signalMastLogic.addContent((Content)new Element("logicDelay").addContent(Long.toString(smlm.getSignalLogicDelay())));
        List<SignalMastLogic> smll = smlm.getSignalMastLogicList();
        for (SignalMastLogic sml : smll) {
            List<SignalMast> destinations = sml.getDestinationList();
            NamedBeanComparator comparator = new NamedBeanComparator();
            Collections.sort(destinations, comparator);
            if (destinations.isEmpty()) {
                log.warn("Empty SML for source mast {} skipped", (Object)sml.getSourceMast().getDisplayName());
                continue;
            }
            Element source = new Element("signalmastlogic");
            source.setAttribute("source", sml.getSourceMast().getDisplayName());
            source.addContent((Content)new Element("sourceSignalMast").addContent(sml.getSourceMast().getDisplayName()));
            for (SignalMast dest : destinations) {
                if (sml.getStoreState(dest) == 4) continue;
                Element elem = new Element("destinationMast");
                elem.setAttribute("destination", dest.getDisplayName());
                elem.addContent((Content)new Element("destinationSignalMast").addContent(dest.getDisplayName()));
                elem.addContent((Content)new Element("comment").addContent(sml.getComment(dest)));
                if (sml.isEnabled(dest)) {
                    elem.addContent((Content)new Element("enabled").addContent("yes"));
                } else {
                    elem.addContent((Content)new Element("enabled").addContent("no"));
                }
                if (sml.allowAutoMaticSignalMastGeneration(dest)) {
                    elem.addContent((Content)new Element("allowAutoMaticSignalMastGeneration").addContent("yes"));
                } else {
                    elem.addContent((Content)new Element("allowAutoMaticSignalMastGeneration").addContent("no"));
                }
                if (sml.useLayoutEditor(dest)) {
                    elem.addContent((Content)new Element("useLayoutEditor").addContent("yes"));
                } else {
                    elem.addContent((Content)new Element("useLayoutEditor").addContent("no"));
                }
                if (sml.useLayoutEditorTurnouts(dest)) {
                    elem.addContent((Content)new Element("useLayoutEditorTurnouts").addContent("yes"));
                } else {
                    elem.addContent((Content)new Element("useLayoutEditorTurnouts").addContent("no"));
                }
                if (sml.useLayoutEditorBlocks(dest)) {
                    elem.addContent((Content)new Element("useLayoutEditorBlocks").addContent("yes"));
                } else {
                    elem.addContent((Content)new Element("useLayoutEditorBlocks").addContent("no"));
                }
                if (sml.getAssociatedSection(dest) != null) {
                    elem.addContent((Content)new Element("associatedSection").addContent(sml.getAssociatedSection(dest).getDisplayName()));
                }
                if (sml.isTurnoutLockAllowed(dest)) {
                    elem.addContent((Content)new Element("lockTurnouts").addContent("yes"));
                } else {
                    elem.addContent((Content)new Element("lockTurnouts").addContent("no"));
                }
                if (sml.getStoreState(dest) == 0) {
                    List<Block> blocks = sml.getBlocks(dest);
                    NamedBeanComparator blockComp = new NamedBeanComparator();
                    Collections.sort(blocks, blockComp);
                    if (blocks.size() > 0) {
                        Element blockElement = new Element("blocks");
                        for (Block bl : blocks) {
                            Element bloc = new Element("block");
                            bloc.addContent((Content)new Element("blockName").addContent(bl.getDisplayName()));
                            Object blkState = "anyState";
                            if (sml.getBlockState(bl, dest) == 2) {
                                blkState = "occupied";
                            } else if (sml.getBlockState(bl, dest) == 4) {
                                blkState = "unoccupied";
                            }
                            bloc.addContent((Content)new Element("blockState").addContent((String)blkState));
                            blockElement.addContent((Content)bloc);
                        }
                        elem.addContent((Content)blockElement);
                    }
                    List<NamedBeanHandle<Turnout>> turnouts = sml.getNamedTurnouts(dest);
                    NamedBeanHandleComparator turnoutComp = new NamedBeanHandleComparator();
                    Collections.sort(turnouts, turnoutComp);
                    if (turnouts.size() > 0) {
                        Element turnoutElement = new Element("turnouts");
                        for (NamedBeanHandle<Turnout> t : turnouts) {
                            Element turn = new Element("turnout");
                            turn.addContent((Content)new Element("turnoutName").addContent(t.getName()));
                            Object turnState = "thrown";
                            if (sml.getTurnoutState(t.getBean(), dest) == 2) {
                                turnState = "closed";
                            }
                            turn.addContent((Content)new Element("turnoutState").addContent((String)turnState));
                            turnoutElement.addContent((Content)turn);
                        }
                        elem.addContent((Content)turnoutElement);
                    }
                    List<NamedBeanHandle<Sensor>> sensors = sml.getNamedSensors(dest);
                    NamedBeanHandleComparator sensorsComp = new NamedBeanHandleComparator();
                    Collections.sort(sensors, sensorsComp);
                    if (sensors.size() > 0) {
                        Element sensorElement = new Element("sensors");
                        for (NamedBeanHandle<Sensor> s : sensors) {
                            Element sensor = new Element("sensor");
                            sensor.addContent((Content)new Element("sensorName").addContent(s.getName()));
                            String sensorState = "inActive";
                            if (sml.getSensorState(s.getBean(), dest) == 2) {
                                sensorState = "active";
                            }
                            sensor.addContent((Content)new Element("sensorState").addContent(sensorState));
                            sensorElement.addContent((Content)sensor);
                        }
                        elem.addContent((Content)sensorElement);
                    }
                    List<SignalMast> masts = sml.getSignalMasts(dest);
                    NamedBeanComparator mastComp = new NamedBeanComparator();
                    Collections.sort(masts, mastComp);
                    if (masts.size() > 0) {
                        Element mastElement = new Element("masts");
                        for (SignalMast sm : masts) {
                            Element mast = new Element("mast");
                            mast.addContent((Content)new Element("mastName").addContent(sm.getDisplayName()));
                            mast.addContent((Content)new Element("mastState").addContent(sml.getSignalMastState(sm, dest)));
                            mastElement.addContent((Content)mast);
                        }
                        elem.addContent((Content)mastElement);
                    }
                }
                source.addContent((Content)elem);
            }
            signalMastLogic.addContent((Content)source);
        }
        return signalMastLogic;
    }

    public void setStoreElementClass(Element signalMastLogic) {
        signalMastLogic.setAttribute("class", "jmri.managers.configurexml.DefaultSignalMastLogicManagerXml");
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        return this.loadSignalMastLogic(shared);
    }

    public boolean loadSignalMastLogic(Element signalMastLogic) {
        List logicList = signalMastLogic.getChildren("signalmastlogic");
        log.debug("Found {} signal mast logics", (Object)logicList.size());
        SignalMastManager sm = InstanceManager.getDefault(SignalMastManager.class);
        SignalMastLogicManager smlm = InstanceManager.getDefault(SignalMastLogicManager.class);
        try {
            String logicDelay = signalMastLogic.getChild("logicDelay").getText();
            smlm.setSignalLogicDelay(Integer.parseInt(logicDelay));
        }
        catch (NullPointerException nullPointerException) {}
        boolean loadOk = true;
        for (Element sml : logicList) {
            String source = sml.getChild("sourceSignalMast").getText();
            SignalMast sourceMast = sm.getSignalMast(source);
            if (sourceMast != null) {
                SignalMastLogic logic = smlm.newSignalMastLogic(sourceMast);
                List destList = sml.getChildren("destinationMast");
                for (Element d : destList) {
                    String destination = d.getChild("destinationSignalMast").getText();
                    SignalMast dest = sm.getSignalMast(destination);
                    if (dest != null) {
                        List mastList;
                        Element mastElem;
                        List blockList;
                        Element blockElem;
                        List sensorList;
                        Element sensorElem;
                        List turnoutList;
                        Element turnoutElem;
                        logic.setDestinationMast(dest);
                        if (d.getChild("comment") != null) {
                            logic.setComment(d.getChild("comment").getText(), dest);
                        }
                        if (d.getChild("enabled") != null) {
                            if (d.getChild("enabled").getText().equals("yes")) {
                                logic.setEnabled(dest);
                            } else {
                                logic.setDisabled(dest);
                            }
                        }
                        if (d.getChild("allowAutoMaticSignalMastGeneration") != null) {
                            if (d.getChild("allowAutoMaticSignalMastGeneration").getText().equals("no")) {
                                logic.allowAutoMaticSignalMastGeneration(false, dest);
                            } else {
                                logic.allowAutoMaticSignalMastGeneration(true, dest);
                            }
                        }
                        boolean useLayoutEditorTurnout = true;
                        boolean useLayoutEditorBlock = true;
                        if (d.getChild("useLayoutEditorTurnouts") != null && d.getChild("useLayoutEditorTurnouts").getText().equals("no")) {
                            useLayoutEditorTurnout = false;
                        }
                        if (d.getChild("useLayoutEditorBlocks") != null && d.getChild("useLayoutEditorBlocks").getText().equals("no")) {
                            useLayoutEditorBlock = false;
                        }
                        try {
                            logic.useLayoutEditorDetails(useLayoutEditorTurnout, useLayoutEditorBlock, dest);
                        }
                        catch (JmriException jmriException) {
                            log.error("use LayoutEditor details failed");
                        }
                        if (d.getChild("useLayoutEditor") != null) {
                            try {
                                if (d.getChild("useLayoutEditor").getText().equals("yes")) {
                                    logic.useLayoutEditor(true, dest);
                                } else {
                                    logic.useLayoutEditor(false, dest);
                                }
                            }
                            catch (JmriException jmriException) {}
                        }
                        if (d.getChild("associatedSection") != null) {
                            Section sect = InstanceManager.getDefault(SectionManager.class).getSection(d.getChild("associatedSection").getText());
                            logic.setAssociatedSection(sect, dest);
                        }
                        if ((turnoutElem = d.getChild("turnouts")) != null && (turnoutList = turnoutElem.getChildren("turnout")).size() > 0) {
                            Hashtable<NamedBeanHandle<Turnout>, Integer> list = new Hashtable<NamedBeanHandle<Turnout>, Integer>();
                            for (Element t : turnoutList) {
                                Turnout turn;
                                String turnout = t.getChild("turnoutName").getText();
                                String state = t.getChild("turnoutState").getText();
                                int value = 2;
                                if (state.equals("thrown")) {
                                    value = 4;
                                }
                                if ((turn = InstanceManager.turnoutManagerInstance().getTurnout(turnout)) != null) {
                                    NamedBeanHandle<Turnout> namedTurnout = this.nbhm.getNamedBeanHandle(turnout, turn);
                                    list.put(namedTurnout, value);
                                }
                                log.debug("Unable to add Turnout {} as it does not exist in the panel file", (Object)turnout);
                            }
                            logic.setTurnouts(list, dest);
                        }
                        if ((sensorElem = d.getChild("sensors")) != null && (sensorList = sensorElem.getChildren("sensor")).size() > 0) {
                            Hashtable<NamedBeanHandle<Sensor>, Integer> list = new Hashtable<NamedBeanHandle<Sensor>, Integer>();
                            for (Element sl : sensorList) {
                                Sensor sen;
                                String sensorName = sl.getChild("sensorName").getText();
                                String state = sl.getChild("sensorState").getText();
                                int value = 4;
                                if (state.equals("active")) {
                                    value = 2;
                                }
                                if ((sen = InstanceManager.sensorManagerInstance().getSensor(sensorName)) != null) {
                                    NamedBeanHandle<Sensor> namedSensor = this.nbhm.getNamedBeanHandle(sensorName, sen);
                                    list.put(namedSensor, value);
                                }
                                log.debug("Unable to add sensor {} as it does not exist in the panel file", (Object)sensorName);
                            }
                            logic.setSensors(list, dest);
                        }
                        if ((blockElem = d.getChild("blocks")) != null && (blockList = blockElem.getChildren("block")).size() > 0) {
                            Hashtable<Block, Integer> list = new Hashtable<Block, Integer>();
                            for (Element b : blockList) {
                                String block = b.getChild("blockName").getText();
                                String state = b.getChild("blockState").getText();
                                int value = 3;
                                if (state.equals("occupied")) {
                                    value = 2;
                                } else if (state.equals("unoccupied")) {
                                    value = 4;
                                }
                                Block blk = InstanceManager.getDefault(BlockManager.class).getBlock(block);
                                if (blk != null) {
                                    list.put(blk, value);
                                }
                                log.debug("Unable to add Block {} as it does not exist in the panel file", (Object)block);
                            }
                            logic.setBlocks(list, dest);
                        }
                        if ((mastElem = d.getChild("masts")) == null || (mastList = mastElem.getChildren("mast")).size() <= 0) continue;
                        Hashtable<SignalMast, String> list = new Hashtable<SignalMast, String>();
                        for (Element m : mastList) {
                            String mast = m.getChild("mastName").getText();
                            String state = m.getChild("mastState").getText();
                            SignalMast mst = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(mast);
                            if (mst != null) {
                                list.put(mst, state);
                            }
                            log.debug("Unable to add Signal Mast {} as it does not exist in the panel file", (Object)mast);
                        }
                        logic.setMasts(list, dest);
                        continue;
                    }
                    log.error("Destination Mast {} not found, logic not loaded", (Object)destination);
                    loadOk = false;
                }
                continue;
            }
            log.error("Source Mast {} Not found, logic not loaded", (Object)source);
            loadOk = false;
        }
        smlm.initialise();
        return loadOk;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(SignalMastLogicManager.class).getXMLOrder();
    }
}

