/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.List;
import java.util.SortedSet;
import javax.swing.JOptionPane;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.Turnout;
import jmri.managers.DefaultRouteManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.managers.configurexml.Bundle;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRouteManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultRouteManagerXml.class);

    @Override
    public Element store(Object o) {
        Element routes = new Element("routes");
        this.setStoreElementClass(routes);
        RouteManager rm = (RouteManager)o;
        if (rm != null) {
            SortedSet routeList = rm.getNamedBeanSet();
            if (routeList.isEmpty()) {
                return null;
            }
            for (Route r : routeList) {
                Element rsElem;
                int state;
                String rName = r.getSystemName();
                log.debug("system name is {}", (Object)rName);
                String cTurnout = r.getControlTurnout();
                int addedDelay = r.getRouteCommandDelay();
                boolean routeLocked = r.getLocked();
                String cLockTurnout = r.getLockControlTurnout();
                Element elem = new Element("route");
                elem.addContent((Content)new Element("systemName").addContent(rName));
                String uName = r.getUserName();
                if (uName != null && !uName.equals("")) {
                    elem.setAttribute("userName", uName);
                }
                this.storeCommon(r, elem);
                if (cTurnout != null && !cTurnout.equals("")) {
                    elem.setAttribute("controlTurnout", cTurnout);
                    state = r.getControlTurnoutState();
                    if (state == 4) {
                        elem.setAttribute("controlTurnoutState", "THROWN");
                    } else if (state == 32) {
                        elem.setAttribute("controlTurnoutState", "CHANGE");
                    } else if (state == 8) {
                        elem.setAttribute("controlTurnoutState", "VETOCLOSED");
                    } else if (state == 16) {
                        elem.setAttribute("controlTurnoutState", "VETOTHROWN");
                    } else {
                        elem.setAttribute("controlTurnoutState", "CLOSED");
                    }
                }
                if (cLockTurnout != null && !cLockTurnout.equals("")) {
                    elem.setAttribute("controlLockTurnout", cLockTurnout);
                    state = r.getLockControlTurnoutState();
                    if (state == 4) {
                        elem.setAttribute("controlLockTurnoutState", "THROWN");
                    } else if (state == 32) {
                        elem.setAttribute("controlLockTurnoutState", "CHANGE");
                    } else {
                        elem.setAttribute("controlLockTurnoutState", "CLOSED");
                    }
                }
                if (addedDelay > 0) {
                    elem.setAttribute("addedDelay", Integer.toString(addedDelay));
                }
                if (routeLocked) {
                    elem.setAttribute("routeLocked", "True");
                }
                int index = 0;
                String rTurnout = null;
                while ((rTurnout = r.getOutputTurnoutByIndex(index)) != null) {
                    Element rElem = new Element("routeOutputTurnout").setAttribute("systemName", rTurnout);
                    String sState = "CLOSED";
                    if (r.getOutputTurnoutSetState(rTurnout) == 4) {
                        sState = "THROWN";
                    } else if (r.getOutputTurnoutSetState(rTurnout) == 8) {
                        sState = "TOGGLE";
                    }
                    rElem.setAttribute("state", sState);
                    elem.addContent((Content)rElem);
                    ++index;
                }
                index = 0;
                String rSensor = null;
                while ((rSensor = r.getOutputSensorByIndex(index)) != null) {
                    Element rElem = new Element("routeOutputSensor").setAttribute("systemName", rSensor);
                    String sState = "INACTIVE";
                    if (r.getOutputSensorSetState(rSensor) == 2) {
                        sState = "ACTIVE";
                    } else if (r.getOutputSensorSetState(rSensor) == 8) {
                        sState = "TOGGLE";
                    }
                    rElem.setAttribute("state", sState);
                    elem.addContent((Content)rElem);
                    ++index;
                }
                index = 0;
                while ((rSensor = r.getRouteSensorName(index)) != null) {
                    String modeName;
                    rsElem = new Element("routeSensor").setAttribute("systemName", rSensor);
                    int mode = r.getRouteSensorMode(index);
                    switch (mode) {
                        case 0: {
                            modeName = "onActive";
                            break;
                        }
                        case 1: {
                            modeName = "onInactive";
                            break;
                        }
                        case 32: {
                            modeName = "onChange";
                            break;
                        }
                        case 2: {
                            modeName = "vetoActive";
                            break;
                        }
                        case 3: {
                            modeName = "vetoInactive";
                            break;
                        }
                        default: {
                            modeName = null;
                        }
                    }
                    if (modeName != null) {
                        rsElem.setAttribute("mode", modeName);
                    }
                    elem.addContent((Content)rsElem);
                    ++index;
                }
                if (r.getOutputSoundName() != null && !r.getOutputSoundName().equals("")) {
                    rsElem = new Element("routeSoundFile").setAttribute("name", FileUtil.getPortableFilename(new File(r.getOutputSoundName())));
                    elem.addContent((Content)rsElem);
                }
                if (r.getOutputScriptName() != null && !r.getOutputScriptName().equals("")) {
                    rsElem = new Element("routeScriptFile").setAttribute("name", FileUtil.getPortableFilename(new File(r.getOutputScriptName())));
                    elem.addContent((Content)rsElem);
                }
                if (!r.getTurnoutsAlignedSensor().equals("")) {
                    rsElem = new Element("turnoutsAlignedSensor").setAttribute("name", r.getTurnoutsAlignedSensor());
                    elem.addContent((Content)rsElem);
                }
                log.debug("store Route {}", (Object)rName);
                routes.addContent((Content)elem);
            }
        }
        return routes;
    }

    public void setStoreElementClass(Element routes) {
        routes.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedRoutes, Element perNodeRoutes) {
        this.replaceRouteManager();
        this.loadRoutes(sharedRoutes);
        return true;
    }

    public void loadRoutes(Element routes) {
        List routeList = routes.getChildren("route");
        log.debug("Found {} routes", (Object)routeList.size());
        RouteManager tm = InstanceManager.getDefault(RouteManager.class);
        int namesChanged = 0;
        for (Element el : routeList) {
            List routeTurnoutList;
            Route r;
            int addedDelay;
            String cLockTurnoutState;
            String cLockTurnout;
            String routeLockedTxt;
            String sysName;
            block81: {
                block82: {
                    String old;
                    sysName = this.getSystemName(el);
                    if (sysName == null) {
                        log.warn("unexpected null in systemName {}", (Object)el);
                        break;
                    }
                    if (sysName.startsWith(String.valueOf(tm.getSystemPrefix()) + 'R')) {
                        old = sysName;
                        sysName = String.valueOf(tm.getSystemNamePrefix()) + sysName.substring(tm.getSystemNamePrefix().length());
                        log.warn("Converting route system name {} to {}", (Object)old, (Object)sysName);
                        ++namesChanged;
                    }
                    if (!sysName.startsWith(tm.getSystemNamePrefix())) {
                        old = sysName;
                        sysName = String.valueOf(tm.getSystemNamePrefix()) + sysName;
                        log.warn("Converting route system name {} to {}", (Object)old, (Object)sysName);
                        ++namesChanged;
                    }
                    String userName = this.getUserName(el);
                    String cTurnout = null;
                    String cTurnoutState = null;
                    String addedDelayTxt = null;
                    routeLockedTxt = null;
                    cLockTurnout = null;
                    cLockTurnoutState = null;
                    addedDelay = 0;
                    if (el.getAttribute("controlTurnout") != null) {
                        cTurnout = el.getAttribute("controlTurnout").getValue();
                    }
                    if (el.getAttribute("controlTurnoutState") != null) {
                        cTurnoutState = el.getAttribute("controlTurnoutState").getValue();
                    }
                    if (el.getAttribute("controlLockTurnout") != null) {
                        cLockTurnout = el.getAttribute("controlLockTurnout").getValue();
                    }
                    if (el.getAttribute("controlLockTurnoutState") != null) {
                        cLockTurnoutState = el.getAttribute("controlLockTurnoutState").getValue();
                    }
                    if (el.getAttribute("addedDelay") != null && (addedDelayTxt = el.getAttribute("addedDelay").getValue()) != null) {
                        addedDelay = Integer.parseInt(addedDelayTxt);
                    }
                    if (el.getAttribute("routeLocked") != null) {
                        routeLockedTxt = el.getAttribute("routeLocked").getValue();
                    }
                    log.debug("create route: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
                    try {
                        r = tm.provideRoute(sysName, userName);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.error("failed to create Route: {}", (Object)sysName);
                        return;
                    }
                    this.loadCommon(r, el);
                    if (cTurnout == null) break block81;
                    r.setControlTurnout(cTurnout);
                    if (cTurnoutState == null) break block82;
                    switch (cTurnoutState) {
                        case "THROWN": {
                            r.setControlTurnoutState(4);
                            break;
                        }
                        case "CHANGE": {
                            r.setControlTurnoutState(32);
                            break;
                        }
                        case "VETOCLOSED": {
                            r.setControlTurnoutState(8);
                            break;
                        }
                        case "VETOTHROWN": {
                            r.setControlTurnoutState(16);
                            break;
                        }
                        default: {
                            r.setControlTurnoutState(2);
                            break;
                        }
                    }
                    break block81;
                }
                log.error("cTurnoutState was null!");
            }
            r.setRouteCommandDelay(addedDelay);
            if (routeLockedTxt != null && routeLockedTxt.equals("True")) {
                r.setLocked(true);
            }
            if (cLockTurnout != null) {
                r.setLockControlTurnout(cLockTurnout);
                if (cLockTurnoutState != null) {
                    if (cLockTurnoutState.equals("THROWN")) {
                        r.setLockControlTurnoutState(4);
                    } else if (cLockTurnoutState.equals("CHANGE")) {
                        r.setLockControlTurnoutState(32);
                    } else {
                        r.setLockControlTurnoutState(2);
                    }
                } else {
                    log.error("cLockTurnoutState was null!");
                }
            }
            if ((routeTurnoutList = el.getChildren("routeTurnout")).size() > 0) {
                for (Element element : routeTurnoutList) {
                    if (element.getAttribute("systemName") == null) {
                        log.warn("unexpected null in systemName {} {}", (Object)element, (Object)element.getAttributes());
                        break;
                    }
                    String tSysName = element.getAttribute("systemName").getValue();
                    String rState = element.getAttribute("state").getValue();
                    int tSetState = 2;
                    if (rState.equals("THROWN")) {
                        tSetState = 4;
                    } else if (rState.equals("TOGGLE")) {
                        tSetState = 8;
                    }
                    r.addOutputTurnout(tSysName, tSetState);
                }
            }
            if ((routeTurnoutList = el.getChildren("routeOutputTurnout")).size() > 0) {
                int k = 0;
                while (k < routeTurnoutList.size()) {
                    if (((Element)routeTurnoutList.get(k)).getAttribute("systemName") == null) {
                        log.warn("unexpected null in systemName {} {}", routeTurnoutList.get(k), (Object)((Element)routeTurnoutList.get(k)).getAttributes());
                        break;
                    }
                    String tSysName = ((Element)routeTurnoutList.get(k)).getAttribute("systemName").getValue();
                    String rState = ((Element)routeTurnoutList.get(k)).getAttribute("state").getValue();
                    int tSetState = 2;
                    if (rState.equals("THROWN")) {
                        tSetState = 4;
                    } else if (rState.equals("TOGGLE")) {
                        tSetState = 8;
                    }
                    if (!r.isOutputTurnoutIncluded(tSysName)) {
                        r.addOutputTurnout(tSysName, tSetState);
                        Turnout t = r.getOutputTurnout(k);
                        if (r.getLocked()) {
                            t.setLocked(3, true);
                        }
                    }
                    ++k;
                }
            }
            List routeSensorList = el.getChildren("routeOutputSensor");
            for (Element sen : routeSensorList) {
                if (sen.getAttribute("systemName") == null) {
                    log.warn("unexpected null in systemName {} {}", (Object)sen, (Object)sen.getAttributes());
                    break;
                }
                String tSysName = sen.getAttribute("systemName").getValue();
                String rState = sen.getAttribute("state").getValue();
                int tSetState = 4;
                if (rState.equals("ACTIVE")) {
                    tSetState = 2;
                } else if (rState.equals("TOGGLE")) {
                    tSetState = 8;
                }
                if (r.isOutputSensorIncluded(tSysName)) break;
                r.addOutputSensor(tSysName, tSetState);
            }
            Element fileElement = el.getChild("routeSoundFile");
            if (fileElement != null) {
                r.setOutputSoundName(FileUtil.getExternalFilename(fileElement.getAttribute("name").getValue()));
            }
            if ((fileElement = el.getChild("routeScriptFile")) != null) {
                r.setOutputScriptName(FileUtil.getExternalFilename(fileElement.getAttribute("name").getValue()));
            }
            if ((fileElement = el.getChild("turnoutsAlignedSensor")) != null) {
                r.setTurnoutsAlignedSensor(fileElement.getAttribute("name").getValue());
            }
            routeSensorList = el.getChildren("routeSensor");
            for (Element sen : routeSensorList) {
                String sm;
                if (sen.getAttribute("systemName") == null) {
                    log.warn("unexpected null in systemName {} {}", (Object)sen, (Object)sen.getAttributes());
                    break;
                }
                int mode = 0;
                if (sen.getAttribute("mode") == null) break;
                switch (sm = sen.getAttribute("mode").getValue()) {
                    case "onActive": {
                        mode = 0;
                        break;
                    }
                    case "onInactive": {
                        mode = 1;
                        break;
                    }
                    case "onChange": {
                        mode = 32;
                        break;
                    }
                    case "vetoActive": {
                        mode = 2;
                        break;
                    }
                    case "vetoInactive": {
                        mode = 3;
                        break;
                    }
                    default: {
                        log.warn("unexpected sensor mode in route {} was {}", (Object)sysName, (Object)sm);
                    }
                }
                r.addSensorToRoute(sen.getAttribute("systemName").getValue(), mode);
            }
            r.activateRoute();
        }
        if (namesChanged > 0) {
            if (!GraphicsEnvironment.isHeadless() && !Boolean.getBoolean("jmri.test.no-dialogs")) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage(namesChanged > 1 ? "RouteManager.SystemNamesChanged.Message" : "RouteManager.SystemNameChanged.Message", namesChanged), Bundle.getMessage("Manager.SystemNamesChanged.Title", namesChanged, tm.getBeanTypeHandled(namesChanged > 1)), 2);
            }
            log.warn("System names for {} Routes changed; this may have operational impacts.", (Object)namesChanged);
        }
    }

    protected void replaceRouteManager() {
        RouteManager current = InstanceManager.getNullableDefault(RouteManager.class);
        if (current != null && current.getClass().getName().equals(DefaultRouteManager.class.getName())) {
            return;
        }
        if (current != null) {
            InstanceManager.getDefault(ConfigureManager.class).deregister(current);
            InstanceManager.deregister(current, RouteManager.class);
        }
        DefaultRouteManager pManager = InstanceManager.getDefault(DefaultRouteManager.class);
        InstanceManager.store(pManager, RouteManager.class);
        InstanceManager.getDefault(ConfigureManager.class).registerConfig(pManager, 160);
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(RouteManager.class).getXMLOrder();
    }
}

