/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import jmri.Application;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdTagManagerXml
extends XmlFile {
    private final IdTagManager manager;
    private static final String IDTAG_DIRECTORY_NAME = "idtags";
    private String IDTAG_BASE_FILENAME = "IdTags.xml";
    private final String FILE_LOCATION = FileUtil.getUserFilesPath();
    private final Logger log = LoggerFactory.getLogger(DefaultIdTagManagerXml.class);

    public DefaultIdTagManagerXml(IdTagManager tagMan, String baseFileName) {
        this.manager = tagMan;
        this.IDTAG_BASE_FILENAME = baseFileName;
    }

    public void store() throws IOException {
        this.log.debug("Storing...");
        this.log.debug("Using file: {}", (Object)this.getDefaultIdTagFileName());
        this.createFile(this.getDefaultIdTagFileName(), true);
        try {
            this.writeFile(this.getDefaultIdTagFileName());
        }
        catch (FileNotFoundException ex) {
            this.log.error("File not found while writing IdTag file, may not be complete: {}", (Object)ex);
        }
    }

    public void load() {
        this.log.debug("Loading...");
        try {
            this.readFile(this.getDefaultIdTagFileName());
        }
        catch (IOException | JDOMException ex) {
            this.log.error("Exception during IdTag file reading: {}", (Object)ex);
        }
    }

    private File createFile(String fileName, boolean backup) {
        if (backup) {
            this.makeBackupFile(fileName);
        }
        File file = null;
        try {
            if (!this.checkFile(fileName)) {
                file = new File(fileName);
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    this.log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    this.log.debug("New file created");
                }
            } else {
                file = new File(fileName);
            }
        }
        catch (IOException ex) {
            this.log.error("Exception while creating IdTag file, may not be complete: {}", (Object)ex);
        }
        return file;
    }

    private void writeFile(String fileName) throws FileNotFoundException, IOException {
        this.log.debug("writeFile {}", (Object)fileName);
        File file = this.findFile(fileName);
        if (file == null) {
            file = new File(fileName);
        }
        Element root = new Element("idtagtable");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/idtags.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = DefaultIdTagManagerXml.newDocument(root);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/idtags.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        Element values = new Element("configuration");
        root.addContent((Content)values);
        values.addContent((Content)new Element("storeState").addContent(this.manager.isStateStored() ? "yes" : "no"));
        values.addContent((Content)new Element("useFastClock").addContent(this.manager.isFastClockUsed() ? "yes" : "no"));
        values = new Element(IDTAG_DIRECTORY_NAME);
        root.addContent((Content)values);
        for (IdTag t : this.manager.getNamedBeanSet()) {
            this.log.debug("Writing IdTag: {}", (Object)t.getSystemName());
            values.addContent((Content)t.store(this.manager.isStateStored()));
        }
        this.writeXML(file, doc);
    }

    private void readFile(String fileName) throws JDOMException, IOException, IllegalArgumentException {
        List l;
        if (this.findFile(fileName) == null) {
            this.log.debug("{} file could not be found", (Object)fileName);
            return;
        }
        Element root = this.rootFromName(fileName);
        if (root == null) {
            this.log.debug("{} file could not be read", (Object)fileName);
            return;
        }
        if (root.getChild("configuration") != null) {
            l = root.getChild("configuration").getChildren();
            this.log.debug("readFile sees {} configurations", (Object)l.size());
            for (Element e : l) {
                this.log.debug("Configuration {} value {}", (Object)e.getName(), (Object)e.getValue());
                if (e.getName().equals("storeState")) {
                    this.manager.setStateStored(e.getValue().equals("yes"));
                }
                if (!e.getName().equals("useFastClock")) continue;
                this.manager.setFastClockUsed(e.getValue().equals("yes"));
            }
        }
        if (root.getChild(IDTAG_DIRECTORY_NAME) != null) {
            l = root.getChild(IDTAG_DIRECTORY_NAME).getChildren("idtag");
            this.log.debug("readFile sees {} idtags", (Object)l.size());
            for (Element e : l) {
                String systemName = e.getChild("systemName").getText();
                IdTag t = this.manager.provideIdTag(systemName);
                t.load(e);
            }
        }
    }

    public String getDefaultIdTagFileName() {
        return String.valueOf(this.getFileLocation()) + this.getIdTagDirectoryName() + File.separator + this.getIdTagFileName();
    }

    public String getIdTagDirectoryName() {
        return IDTAG_DIRECTORY_NAME;
    }

    public String getIdTagFileName() {
        return String.valueOf(Application.getApplicationName()) + this.IDTAG_BASE_FILENAME;
    }

    public String getFileLocation() {
        return this.FILE_LOCATION;
    }
}

