/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSensorManagerConfigXML
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractSensorManagerConfigXML.class);

    @Override
    public Element store(Object o) {
        Element sensors = new Element("sensors");
        return this.store(o, sensors);
    }

    public Element store(Object o, Element sensors) {
        SortedSet sensorList;
        this.setStoreElementClass(sensors);
        SensorManager sm = (SensorManager)o;
        if (sm.getDefaultSensorDebounceGoingActive() > 0L || sm.getDefaultSensorDebounceGoingInActive() > 0L) {
            Element elem = new Element("globalDebounceTimers");
            elem.addContent((Content)new Element("goingActive").addContent(String.valueOf(sm.getDefaultSensorDebounceGoingActive())));
            elem.addContent((Content)new Element("goingInActive").addContent(String.valueOf(sm.getDefaultSensorDebounceGoingInActive())));
            sensors.addContent((Content)elem);
        }
        if ((sensorList = sm.getNamedBeanSet()).isEmpty()) {
            return null;
        }
        for (Sensor s : sensorList) {
            String sName = s.getSystemName();
            log.debug("system name is {}", (Object)sName);
            String inverted = s.getInverted() ? "true" : "false";
            Element elem = new Element("sensor").setAttribute("inverted", inverted);
            elem.addContent((Content)new Element("systemName").addContent(sName));
            this.storeCommon(s, elem);
            log.debug("store Sensor {}", (Object)sName);
            if (s.getUseDefaultTimerSettings()) {
                elem.addContent((Content)new Element("useGlobalDebounceTimer").addContent("yes"));
            } else if (s.getSensorDebounceGoingActiveTimer() > 0L || s.getSensorDebounceGoingInActiveTimer() > 0L) {
                Element timer = new Element("debounceTimers");
                timer.addContent((Content)new Element("goingActive").addContent(String.valueOf(s.getSensorDebounceGoingActiveTimer())));
                timer.addContent((Content)new Element("goingInActive").addContent(String.valueOf(s.getSensorDebounceGoingInActiveTimer())));
                elem.addContent((Content)timer);
            }
            if (sm.isPullResistanceConfigurable()) {
                elem.addContent((Content)new Element("pullResistance").addContent(s.getPullResistance().getShortName()));
            }
            sensors.addContent((Content)elem);
        }
        return sensors;
    }

    public abstract void setStoreElementClass(Element var1);

    @Override
    public abstract boolean load(Element var1, Element var2) throws JmriConfigureXmlException;

    public boolean loadSensors(Element sensors) throws JmriConfigureXmlException {
        boolean result = true;
        List sensorList = sensors.getChildren("sensor");
        log.debug("Found {} sensors", (Object)sensorList.size());
        SensorManager tm = InstanceManager.sensorManagerInstance();
        tm.setPropertyChangesSilenced("beans", true);
        long goingActive = 0L;
        long goingInActive = 0L;
        if (sensors.getChild("globalDebounceTimers") != null) {
            Element timer = sensors.getChild("globalDebounceTimers");
            try {
                if (timer.getChild("goingActive") != null) {
                    String active = timer.getChild("goingActive").getText();
                    goingActive = Long.parseLong(active);
                    tm.setDefaultSensorDebounceGoingActive(goingActive);
                }
            }
            catch (NumberFormatException ex) {
                log.error(ex.toString());
            }
            try {
                if (timer.getChild("goingInActive") != null) {
                    String inActive = timer.getChild("goingInActive").getText();
                    goingInActive = Long.parseLong(inActive);
                    tm.setDefaultSensorDebounceGoingInActive(goingInActive);
                }
            }
            catch (NumberFormatException ex) {
                log.error(ex.toString());
            }
        }
        for (Element sen : sensorList) {
            Sensor s;
            String sysName = this.getSystemName(sen);
            if (sysName == null) {
                this.handleException("Unexpected missing system name while loading sensors", null, null, null, null);
                result = false;
                break;
            }
            boolean inverted = false;
            String userName = this.getUserName(sen);
            this.checkNameNormalization(sysName, userName, tm);
            if (sen.getAttribute("inverted") != null && sen.getAttribute("inverted").getValue().equals("true")) {
                inverted = true;
            }
            log.debug("create sensor: ({})", (Object)sysName);
            try {
                s = tm.newSensor(sysName, userName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleException("Could not create sensor", null, sysName, userName, null);
                result = false;
                continue;
            }
            this.loadCommon(s, sen);
            if (sen.getChild("debounceTimers") != null) {
                Element timer = sen.getChild("debounceTimers");
                try {
                    if (timer.getChild("goingActive") != null) {
                        String active = timer.getChild("goingActive").getText();
                        s.setSensorDebounceGoingActiveTimer(Long.parseLong(active));
                    }
                }
                catch (NumberFormatException ex) {
                    log.error(ex.toString());
                }
                try {
                    if (timer.getChild("goingInActive") != null) {
                        String inActive = timer.getChild("goingInActive").getText();
                        s.setSensorDebounceGoingInActiveTimer(Long.parseLong(inActive));
                    }
                }
                catch (NumberFormatException ex) {
                    log.error(ex.toString());
                }
            }
            if (sen.getChild("useGlobalDebounceTimer") != null && sen.getChild("useGlobalDebounceTimer").getText().equals("yes")) {
                s.setUseDefaultTimerSettings(true);
            }
            s.setInverted(inverted);
            if (sen.getChild("pullResistance") == null) continue;
            String pull = sen.getChild("pullResistance").getText();
            log.debug("setting pull to {} for sensor {}", (Object)pull, (Object)s);
            s.setPullResistance(Sensor.PullResistance.getByShortName(pull));
        }
        tm.setPropertyChangesSilenced("beans", false);
        return result;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.sensorManagerInstance().getXMLOrder();
    }
}

