/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporterManagerConfigXML
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractReporterManagerConfigXML.class);

    @Override
    public Element store(Object o) {
        Element reporters = new Element("reporters");
        this.setStoreElementClass(reporters);
        ReporterManager rm = (ReporterManager)o;
        if (rm != null) {
            SortedSet rList = rm.getNamedBeanSet();
            if (rList.isEmpty()) {
                return null;
            }
            for (Reporter r : rList) {
                String rName = r.getSystemName();
                log.debug("system name is {}", (Object)rName);
                Element elem = new Element("reporter");
                elem.addContent((Content)new Element("systemName").addContent(rName));
                this.storeCommon(r, elem);
                log.debug("store Reporter {}", (Object)rName);
                reporters.addContent((Content)elem);
            }
        }
        return reporters;
    }

    public abstract void setStoreElementClass(Element var1);

    public boolean loadReporters(Element reporters) {
        boolean result = true;
        List reporterList = reporters.getChildren("reporter");
        log.debug("Found {} reporters", (Object)reporterList.size());
        ReporterManager tm = InstanceManager.getDefault(ReporterManager.class);
        tm.setPropertyChangesSilenced("beans", true);
        for (Element e : reporterList) {
            String sysName = this.getSystemName(e);
            if (sysName == null) {
                log.warn("unexpected null in systemName {} {}", (Object)e, (Object)e.getAttributes());
                result = false;
                break;
            }
            String userName = this.getUserName(e);
            log.debug("create Reporter: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            Reporter r = tm.newReporter(sysName, userName);
            this.loadCommon(r, e);
        }
        tm.setPropertyChangesSilenced("beans", false);
        return result;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(ReporterManager.class).getXMLOrder();
    }
}

