/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamedBeanManagerConfigXML
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractNamedBeanManagerConfigXML.class);

    protected void storeCommon(NamedBean t, Element elem) {
        this.storeUserName(t, elem);
        this.storeComment(t, elem);
        this.storeProperties(t, elem);
    }

    protected void loadCommon(NamedBean t, Element elem) {
        this.loadComment(t, elem);
        this.loadProperties(t, elem);
    }

    void storeComment(NamedBean t, Element elem) {
        if (t.getComment() != null) {
            Element c = new Element("comment");
            c.addContent(t.getComment());
            elem.addContent((Content)c);
        }
    }

    void storeUserName(NamedBean t, Element elem) {
        String uname = t.getUserName();
        if (uname != null && uname.length() > 0) {
            elem.addContent((Content)new Element("userName").addContent(uname));
        }
    }

    protected String getUserName(List<Element> beanList, int i) {
        return this.getUserName(beanList.get(i));
    }

    protected String getUserName(@Nonnull Element elem) {
        if (elem.getChild("userName") != null) {
            return elem.getChild("userName").getText();
        }
        if (elem.getAttribute("userName") != null) {
            return elem.getAttribute("userName").getValue();
        }
        return null;
    }

    protected String getSystemName(@Nonnull Element elem) {
        if (elem.getChild("systemName") != null) {
            return elem.getChild("systemName").getText();
        }
        if (elem.getAttribute("systemName") != null) {
            return elem.getAttribute("systemName").getValue();
        }
        return null;
    }

    void checkNameNormalization(@Nonnull String rawSystemName, String rawUserName, @Nonnull Manager manager) {
        if (rawUserName != null) {
            String normalizedUserName = NamedBean.normalizeUserName(rawUserName);
            if (!rawUserName.equals(normalizedUserName)) {
                log.warn("Requested user name \"{}\" for system name \"{}\" was normalized to \"{}\"", new Object[]{rawUserName, rawSystemName, normalizedUserName});
            }
            if (normalizedUserName != null) {
                Object bean = manager.getByUserName(normalizedUserName);
                if (bean != null && !bean.getSystemName().equals(rawSystemName)) {
                    log.warn("User name \"{}\" already exists as system name \"{}\"", (Object)normalizedUserName, (Object)bean.getSystemName());
                }
            } else {
                log.warn("User name \"{}\" was normalized into null", (Object)rawUserName);
            }
        }
    }

    public <T extends NamedBean> T checkedNamedBeanReference(String name, @Nonnull T type, @Nonnull Manager<T> m) {
        if (name == null) {
            return null;
        }
        if (name.equals("")) {
            return null;
        }
        T nb = m.getNamedBean(name);
        if (nb == null) {
            return null;
        }
        return nb;
    }

    public <T extends NamedBean> NamedBeanHandle<T> checkedNamedBeanHandle(String name, @Nonnull T type, @Nonnull Manager<T> m) {
        if (name == null) {
            return null;
        }
        if (name.equals("")) {
            return null;
        }
        T nb = m.getNamedBean(name);
        if (nb == null) {
            return null;
        }
        return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, nb);
    }

    public <T extends NamedBean> String checkedNamedBeanName(String name, T type, @Nonnull Manager m) {
        if (name == null) {
            return null;
        }
        if (name.equals("")) {
            return null;
        }
        Object nb = m.getNamedBean(name);
        if (nb == null) {
            return null;
        }
        return name;
    }

    void loadComment(NamedBean t, List<Element> beanList, int i) {
        this.loadComment(t, beanList.get(i));
    }

    void loadComment(NamedBean t, Element elem) {
        String c = elem.getChildText("comment");
        if (c != null) {
            t.setComment(c);
        }
    }

    String getAttributeString(Element elem, String name) {
        Attribute a = elem.getAttribute(name);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    boolean getAttributeBool(Element elem, String name, boolean def) {
        String v = this.getAttributeString(elem, name);
        if (v == null) {
            return def;
        }
        if (def) {
            return !v.equals("false");
        }
        return v.equals("true");
    }

    void storeProperties(NamedBean t, Element elem) {
        Set<String> s = t.getPropertyKeys();
        if (s.isEmpty()) {
            return;
        }
        Element ret = new Element("properties");
        elem.addContent((Content)ret);
        s.forEach(key -> {
            Object value = t.getProperty((String)key);
            Element p = new Element("property");
            ret.addContent((Content)p);
            p.addContent((Content)new Element("key").setText(key));
            if (value != null) {
                p.addContent((Content)new Element("value").setAttribute("class", value.getClass().getName()).setText(value.toString()));
            }
        });
    }

    void loadProperties(NamedBean t, Element elem) {
        Element p = elem.getChild("properties");
        if (p == null) {
            return;
        }
        p.getChildren("property").forEach(e -> {
            try {
                String key = e.getChild("key").getText();
                if (e.getChild("key").getAttributeValue("class") != null && !e.getChild("key").getAttributeValue("class").equals("") && !e.getChild("key").getAttributeValue("class").equals("java.lang.String")) {
                    log.warn("NamedBean {} property key of invalid non-String type {} not supported", (Object)t.getSystemName(), (Object)e.getChild("key").getAttributeValue("class"));
                }
                Object value = null;
                if (e.getChild("value") != null) {
                    Class<?> cl = Class.forName(e.getChild("value").getAttributeValue("class"));
                    Constructor<?> ctor = cl.getConstructor(String.class);
                    value = ctor.newInstance(e.getChild("value").getText());
                }
                t.setProperty(key, value);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                log.error("Error loading properties", (Throwable)ex);
            }
        });
    }

    boolean loadInAdapter(List<Element> list, Element perNode) {
        boolean result = true;
        for (Element item : list) {
            String adapterName = item.getAttribute("class").getValue();
            log.debug("load via {}", (Object)adapterName);
            try {
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.load(item, perNode);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JmriConfigureXmlException e) {
                log.error("Exception while loading {}: {}", new Object[]{item.getName(), e, e});
                result = false;
            }
        }
        return result;
    }
}

