/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemoryManagerConfigXML
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractMemoryManagerConfigXML.class);

    @Override
    public Element store(Object o) {
        Element memories = new Element("memories");
        this.setStoreElementClass(memories);
        MemoryManager mm = (MemoryManager)o;
        if (mm != null) {
            SortedSet memList = mm.getNamedBeanSet();
            if (memList.isEmpty()) {
                return null;
            }
            for (Memory m : memList) {
                String mName = m.getSystemName();
                log.debug("system name is {}", (Object)mName);
                Element elem = new Element("memory");
                elem.addContent((Content)new Element("systemName").addContent(mName));
                this.storeCommon(m, elem);
                Object obj = m.getValue();
                if (obj != null) {
                    if (obj instanceof RosterEntry) {
                        String valueClass = obj.getClass().getName();
                        String value = ((RosterEntry)obj).getId();
                        elem.setAttribute("value", value);
                        elem.setAttribute("valueClass", valueClass);
                    } else {
                        String value = obj.toString();
                        elem.setAttribute("value", value);
                    }
                }
                log.debug("store Memory {}", (Object)mName);
                memories.addContent((Content)elem);
            }
        }
        return memories;
    }

    public abstract void setStoreElementClass(Element var1);

    @Override
    public abstract boolean load(Element var1, Element var2) throws JmriConfigureXmlException;

    public void loadMemories(Element memories) {
        List memoryList = memories.getChildren("memory");
        log.debug("Found {} Memory objects", (Object)memoryList.size());
        MemoryManager mm = InstanceManager.memoryManagerInstance();
        for (Element el : memoryList) {
            String sysName = this.getSystemName(el);
            if (sysName == null) {
                log.warn("unexpected null in systemName {}", (Object)el);
                break;
            }
            String userName = this.getUserName(el);
            this.checkNameNormalization(sysName, userName, mm);
            log.debug("create Memory: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            Memory m = mm.newMemory(sysName, userName);
            if (el.getAttribute("value") != null) {
                this.loadValue(el, m);
            }
            this.loadCommon(m, el);
        }
    }

    @Override
    public int loadOrder() {
        return InstanceManager.memoryManagerInstance().getXMLOrder();
    }

    private void loadValue(Element memory, Memory m) {
        String adapter;
        String value = memory.getAttribute("value").getValue();
        if (memory.getAttribute("valueClass") != null && (adapter = memory.getAttribute("valueClass").getValue()).equals("jmri.jmrit.roster.RosterEntry")) {
            RosterEntry re = Roster.getDefault().getEntryForId(value);
            m.setValue(re);
            return;
        }
        m.setValue(value);
    }
}

