/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import jmri.ShutDownManager;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.managers.DefaultShutDownManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutDownManagerInitializer
extends AbstractInstanceInitializer {
    private static final Logger log = LoggerFactory.getLogger(ShutDownManagerInitializer.class);

    @Override
    public <T> Object getDefault(Class<T> type) {
        if (type.equals(ShutDownManager.class)) {
            String property = System.getProperty("jmri.shutdownmanager");
            if (property != null) {
                try {
                    Class<?> c = Class.forName(property);
                    if (ShutDownManager.class.isAssignableFrom(c)) {
                        return c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    log.error("Specified jmri.shutdownmanager value {} is not a jmri.ShutDownManager subclass", (Object)property);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    log.error("Unable to instanciate ShutDownManager class {} with default constructor", (Object)property);
                }
            }
            return new DefaultShutDownManager();
        }
        return super.getDefault(type);
    }

    @Override
    public Set<Class<?>> getInitalizes() {
        Set<Class<?>> set = super.getInitalizes();
        set.add(ShutDownManager.class);
        return set;
    }
}

