/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.TurnoutOperationManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.AbstractProvidingProxyManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyTurnoutManager
extends AbstractProvidingProxyManager<Turnout>
implements TurnoutManager {
    private static final Logger log = LoggerFactory.getLogger(ProxyTurnoutManager.class);

    @Override
    protected AbstractManager<Turnout> makeInternalManager() {
        return InstanceManager.getDefault(InternalSystemConnectionMemo.class).getTurnoutManager();
    }

    @Override
    public void addManager(@Nonnull Manager<Turnout> m) {
        super.addManager(m);
        InstanceManager.getDefault(TurnoutOperationManager.class).loadOperationTypes();
    }

    @Override
    public Turnout getTurnout(@Nonnull String name) {
        return (Turnout)super.getNamedBean(name);
    }

    @Override
    @Nonnull
    protected Turnout makeBean(Manager<Turnout> manager, String systemName, String userName) throws IllegalArgumentException {
        return ((TurnoutManager)manager).newTurnout(systemName, userName);
    }

    @Override
    @Nonnull
    public Turnout provideTurnout(@Nonnull String name) throws IllegalArgumentException {
        return (Turnout)super.provideNamedBean(name);
    }

    @Override
    @Nonnull
    public Turnout provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideTurnout(name);
    }

    @Override
    @Nonnull
    public Turnout newTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        return (Turnout)this.newNamedBean(systemName, userName);
    }

    @Override
    @Nonnull
    public String getClosedText() {
        return ((TurnoutManager)this.getDefaultManager()).getClosedText();
    }

    @Override
    @Nonnull
    public String getThrownText() {
        return ((TurnoutManager)this.getDefaultManager()).getThrownText();
    }

    @Override
    public int askNumControlBits(@Nonnull String systemName) {
        return ((TurnoutManager)this.getManagerOrDefault(systemName)).askNumControlBits(systemName);
    }

    @Override
    public int askControlType(@Nonnull String systemName) {
        return ((TurnoutManager)this.getManagerOrDefault(systemName)).askControlType(systemName);
    }

    @Override
    public boolean isControlTypeSupported(@Nonnull String systemName) {
        return ((TurnoutManager)this.getManagerOrDefault(systemName)).isControlTypeSupported(systemName);
    }

    @Override
    public boolean isNumControlBitsSupported(@Nonnull String systemName) {
        return ((TurnoutManager)this.getManagerOrDefault(systemName)).isNumControlBitsSupported(systemName);
    }

    @Override
    @Nonnull
    public String[] getValidOperationTypes() {
        LinkedList typeList = new LinkedList();
        this.getManagerList().forEach(m -> {
            boolean bl = typeList.addAll(Arrays.asList(((TurnoutManager)m).getValidOperationTypes()));
        });
        return TurnoutOperationManager.concatenateTypeLists(typeList.toArray(new String[0]));
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return ((TurnoutManager)this.getManagerOrDefault(systemName)).allowMultipleAdditions(systemName);
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return this.getNextValidAddress(curAddress, prefix, this.typeLetter());
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        return this.getNextValidAddress(curAddress, prefix, ignoreInitialExisting, this.typeLetter());
    }

    @Override
    public void setDefaultClosedSpeed(@Nonnull String speed) throws JmriException {
        for (Manager m : this.getManagerList()) {
            try {
                ((TurnoutManager)m).setDefaultClosedSpeed(speed);
            }
            catch (JmriException ex) {
                log.error(ex.toString());
                throw ex;
            }
        }
    }

    @Override
    public void setDefaultThrownSpeed(@Nonnull String speed) throws JmriException {
        for (Manager m : this.getManagerList()) {
            try {
                ((TurnoutManager)m).setDefaultThrownSpeed(speed);
            }
            catch (JmriException ex) {
                log.error(ex.toString());
                throw ex;
            }
        }
    }

    @Override
    public String getDefaultThrownSpeed() {
        return ((TurnoutManager)this.getDefaultManager()).getDefaultThrownSpeed();
    }

    @Override
    public String getDefaultClosedSpeed() {
        return ((TurnoutManager)this.getDefaultManager()).getDefaultClosedSpeed();
    }

    @Override
    public int getOutputInterval() {
        return ((TurnoutManager)this.getDefaultManager()).getOutputInterval();
    }

    @Override
    public void setOutputInterval(int newInterval) {
        log.debug("setOutputInterval called in ProxyTurnoutManager");
        for (Manager manager : this.getManagerList()) {
            ((TurnoutManager)manager).setOutputInterval(newInterval);
        }
    }

    @Override
    @Nonnull
    public LocalDateTime outputIntervalEnds() {
        log.debug("outputIntervalEnds called in ProxyTurnoutManager");
        return ((TurnoutManager)this.getDefaultManager()).outputIntervalEnds();
    }

    @Override
    public int getXMLOrder() {
        return 20;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameTurnouts" : "BeanNameTurnout");
    }

    @Override
    public Class<Turnout> getNamedBeanClass() {
        return Turnout.class;
    }
}

