/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.AnalogIO;
import jmri.AnalogIOManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.Manager;
import jmri.Meter;
import jmri.MeterManager;
import jmri.NamedBean;
import jmri.VariableLight;
import jmri.jmrix.internal.InternalAnalogIOManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.AbstractProxyManager;
import jmri.managers.Bundle;

public class ProxyAnalogIOManager
extends AbstractProxyManager<AnalogIO>
implements AnalogIOManager {
    private final InternalAnalogIOManager internalAnalogIOManager;
    private boolean muteUpdates = false;
    private final List<Class<? extends AnalogIO>> registerBeans = new ArrayList<Class<? extends AnalogIO>>();
    private final List<Manager<? extends NamedBean>> registerBeanManagers = new ArrayList<Manager<? extends NamedBean>>();

    public ProxyAnalogIOManager() {
        this.internalAnalogIOManager = new InternalAnalogIOManager(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
        this.addManager(this.internalAnalogIOManager);
    }

    @Nonnull
    public ProxyAnalogIOManager init() {
        this.addBeanType(Meter.class, InstanceManager.getDefault(MeterManager.class));
        this.addBeanType(VariableLight.class, InstanceManager.getDefault(LightManager.class));
        return this;
    }

    @Override
    public int getXMLOrder() {
        return 200;
    }

    @Override
    protected AbstractManager<AnalogIO> makeInternalManager() {
        return this.internalAnalogIOManager;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameAnalogIOs" : "BeanNameAnalogIO");
    }

    @Override
    public Class<AnalogIO> getNamedBeanClass() {
        return AnalogIO.class;
    }

    @Override
    @CheckReturnValue
    @CheckForNull
    public AnalogIO getBySystemName(@Nonnull String systemName) {
        AnalogIO analogIO = (AnalogIO)super.getBySystemName(systemName);
        if (analogIO == null) {
            analogIO = (AnalogIO)this.initInternal().getBySystemName(systemName);
        }
        return analogIO;
    }

    @Override
    @CheckForNull
    public AnalogIO getByUserName(@Nonnull String userName) {
        AnalogIO analogIO = (AnalogIO)super.getByUserName(userName);
        if (analogIO == null) {
            analogIO = (AnalogIO)this.initInternal().getByUserName(userName);
        }
        return analogIO;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (this.muteUpdates) {
            return;
        }
        if ("beans".equals(e.getPropertyName())) {
            for (Class<? extends AnalogIO> clazz : this.registerBeans) {
                Manager<AnalogIO> internalManager;
                if (e.getNewValue() != null && clazz.isAssignableFrom(e.getNewValue().getClass())) {
                    internalManager = this.initInternal();
                    this.muteUpdates = true;
                    internalManager.register((AnalogIO)e.getNewValue());
                    this.muteUpdates = false;
                }
                if (e.getOldValue() == null || !clazz.isAssignableFrom(e.getOldValue().getClass())) continue;
                internalManager = this.initInternal();
                this.muteUpdates = true;
                internalManager.deregister((AnalogIO)e.getOldValue());
                this.muteUpdates = false;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Manager<? extends NamedBean> manager : this.registerBeanManagers) {
            manager.removePropertyChangeListener("beans", this);
        }
    }

    @Override
    public void addBeanType(Class<? extends AnalogIO> clazz, Manager<? extends NamedBean> manager) {
        this.registerBeans.add(clazz);
        manager.addPropertyChangeListener("beans", this);
        Manager<AnalogIO> internalManager = this.initInternal();
        this.muteUpdates = true;
        for (NamedBean namedBean : manager.getNamedBeanSet()) {
            internalManager.register((AnalogIO)namedBean);
        }
        this.muteUpdates = false;
    }

    @Override
    public void removeBeanType(Class<? extends AnalogIO> clazz, Manager<? extends NamedBean> manager) {
        manager.removePropertyChangeListener("beans", this);
        this.registerBeans.remove(clazz);
    }
}

