/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.SignalSystem;
import jmri.SignalSystemManager;
import jmri.implementation.DefaultSignalSystem;
import jmri.jmrit.XmlFile;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import jmri.util.FileUtil;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalSystemManager
extends AbstractManager<SignalSystem>
implements SignalSystemManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalSystemManager.class);

    public DefaultSignalSystemManager(InternalSystemConnectionMemo memo) {
        super(memo);
        this.load();
    }

    @Override
    public int getXMLOrder() {
        return 65400;
    }

    @Override
    protected void registerSelf() {
    }

    @Override
    public char typeLetter() {
        return 'F';
    }

    @Override
    @CheckForNull
    public SignalSystem getSystem(String name) {
        SignalSystem t = (SignalSystem)this.getByUserName(name);
        return t != null ? t : (SignalSystem)this.getBySystemName(name);
    }

    final void load() {
        List<String> list = this.getListOfNames();
        int i = 0;
        while (i < list.size()) {
            try {
                SignalSystem s = this.makeBean(list.get(i));
                this.register(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
    }

    @Nonnull
    protected List<String> getListOfNames() {
        File aspects;
        File file;
        int n;
        int n2;
        File[] fileArray;
        File[] files;
        ArrayList<String> retval = new ArrayList<String>();
        File signalDir = null;
        try {
            signalDir = new File(FileUtil.findURL("xml/signals", FileUtil.Location.INSTALLED).toURI());
        }
        catch (NullPointerException | URISyntaxException ex) {
            log.error("Unable to get installed signals.", (Throwable)ex);
        }
        if (signalDir != null && (files = signalDir.listFiles()) != null) {
            fileArray = files;
            n2 = files.length;
            n = 0;
            while (n < n2) {
                file = fileArray[n];
                if (file.isDirectory() && (aspects = new File(String.valueOf(file.getPath()) + File.separator + "aspects.xml")).exists()) {
                    log.debug("found system: {}", (Object)file.getName());
                    retval.add(file.getName());
                }
                ++n;
            }
        }
        try {
            URL dir = FileUtil.findURL("signals", FileUtil.Location.USER, "resources", "xml");
            if (dir == null) {
                try {
                    if (!new File(FileUtil.getUserFilesPath(), "xml/signals").mkdirs()) {
                        log.error("Error while creating xml/signals directory");
                    }
                }
                catch (Exception ex) {
                    log.error("Unable to create user's signals directory.", (Throwable)ex);
                }
                dir = FileUtil.findURL("xml/signals", FileUtil.Location.USER);
            }
            signalDir = new File(dir.toURI());
        }
        catch (URISyntaxException ex) {
            log.error("Unable to get installed signals.", (Throwable)ex);
        }
        if (signalDir != null && (files = signalDir.listFiles()) != null) {
            fileArray = files;
            n2 = files.length;
            n = 0;
            while (n < n2) {
                file = fileArray[n];
                if (file.isDirectory() && (aspects = new File(String.valueOf(file.getPath()) + File.separator + "aspects.xml")).exists() && !retval.contains(file.getName())) {
                    log.debug("found system: {}", (Object)file.getName());
                    retval.add(file.getName());
                }
                ++n;
            }
        }
        return retval;
    }

    @Nonnull
    protected SignalSystem makeBean(String name) throws IllegalArgumentException {
        URL path = FileUtil.findURL("xml/signals/" + name + "/aspects.xml", FileUtil.Location.INSTALLED);
        log.debug("load from {}", (Object)path);
        AspectFile xf = new AspectFile();
        if (path != null) {
            try {
                Element root = xf.rootFromURL(path);
                DefaultSignalSystem s = new DefaultSignalSystem(name);
                this.loadBean(s, root);
                return s;
            }
            catch (IOException | JDOMException e) {
                log.error("Could not parse aspect file \"{}\" due to: {}", (Object)path, (Object)e);
            }
        }
        path = FileUtil.findURL("signals/" + name + "/aspects.xml", FileUtil.Location.USER, "xml", "resources");
        log.debug("load from {}", (Object)path);
        if (path != null) {
            xf = new AspectFile();
            try {
                Element root = xf.rootFromURL(path);
                DefaultSignalSystem s = new DefaultSignalSystem(name);
                this.loadBean(s, root);
                return s;
            }
            catch (IOException | JDOMException e) {
                log.error("Could not parse aspect file \"{}\" due to: {}", (Object)path, (Object)e);
            }
        }
        throw new IllegalArgumentException("Unable to parse aspect file " + path);
    }

    void loadBean(DefaultSignalSystem s, Element root) {
        List l = root.getChild("aspects").getChildren("aspect");
        s.setUserName(root.getChild("name").getText());
        int i = 0;
        while (i < l.size()) {
            String name = ((Element)l.get(i)).getChild("name").getText();
            log.debug("aspect name {}", (Object)name);
            List c = ((Element)l.get(i)).getChildren();
            int j = 0;
            while (j < c.size()) {
                s.setProperty(name, ((Element)c.get(j)).getName(), ((Element)c.get(j)).getText());
                ++j;
            }
            ++i;
        }
        if (root.getChild("imagetypes") != null) {
            List t = root.getChild("imagetypes").getChildren("imagetype");
            int i2 = 0;
            while (i2 < t.size()) {
                String type = ((Element)t.get(i2)).getAttribute("type").getValue();
                s.setImageType(type);
                ++i2;
            }
        }
        if (root.getChild("properties") != null) {
            for (Object next : root.getChild("properties").getChildren("property")) {
                Element e = (Element)next;
                try {
                    String key = e.getChild("key").getText();
                    if (e.getChild("key").getAttributeValue("class") != null && !e.getChild("key").getAttributeValue("class").isEmpty() && !e.getChild("key").getAttributeValue("class").equals("java.lang.String")) {
                        log.warn("SignalSystem {} property key of invalid non-String type {} not supported", (Object)s.getSystemName(), (Object)e.getChild("key").getAttributeValue("class"));
                    }
                    Object value = null;
                    if (e.getChild("value") != null) {
                        Class<?> cl = Class.forName(e.getChild("value").getAttributeValue("class"));
                        Constructor<?> ctor = cl.getConstructor(String.class);
                        value = ctor.newInstance(e.getChild("value").getText());
                    }
                    s.setProperty(key, value);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    log.error("Error loading properties", (Throwable)ex);
                }
            }
        }
    }

    void loadProperties(NamedBean t, Element elem) {
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSignalSystems" : "BeanNameSignalSystem");
    }

    @Override
    public Class<SignalSystem> getNamedBeanClass() {
        return SignalSystem.class;
    }

    static class AspectFile
    extends XmlFile {
        AspectFile() {
        }
    }
}

