/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.implementation.DefaultSignalMastLogic;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalMastLogicManager
extends AbstractManager<SignalMastLogic>
implements SignalMastLogicManager {
    private static final SignalSpeedMap _speedMap = InstanceManager.getDefault(SignalSpeedMap.class);
    int signalLogicDelay = 500;
    protected PropertyChangeListener propertyBlockManagerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean newValue;
            if (e.getPropertyName().equals("topology") && (newValue = ((Boolean)e.getNewValue()).booleanValue())) {
                for (SignalMastLogic signalMastLogic : DefaultSignalMastLogicManager.this._beans) {
                    signalMastLogic.setupLayoutEditorDetails();
                }
                if (DefaultSignalMastLogicManager.this.runWhenStablised) {
                    try {
                        DefaultSignalMastLogicManager.this.automaticallyDiscoverSignallingPairs();
                    }
                    catch (JmriException jmriException) {}
                }
            }
        }
    };
    boolean runWhenStablised = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalMastLogicManager.class);

    public DefaultSignalMastLogicManager(InternalSystemConnectionMemo memo) {
        super(memo);
        this.registerSelf();
        this.addListeners();
    }

    final void addListeners() {
        InstanceManager.getDefault(LayoutBlockManager.class).addPropertyChangeListener(this.propertyBlockManagerListener);
        InstanceManager.getDefault(SignalMastManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(TurnoutManager.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 180;
    }

    public static final SignalSpeedMap getSpeedMap() {
        return _speedMap;
    }

    @Override
    public SignalMastLogic getSignalMastLogic(SignalMast source) {
        for (SignalMastLogic signalMastLogic : this._beans) {
            if (signalMastLogic.getSourceMast() != source) continue;
            return signalMastLogic;
        }
        return null;
    }

    @Override
    @Nonnull
    public SignalMastLogic newSignalMastLogic(SignalMast source) throws IllegalArgumentException {
        for (SignalMastLogic signalMastLogic : this._beans) {
            if (signalMastLogic.getSourceMast() != source) continue;
            return signalMastLogic;
        }
        DefaultSignalMastLogic logic = new DefaultSignalMastLogic(source);
        this._beans.add(logic);
        this.firePropertyChange("length", null, (Object)this._beans.size());
        return logic;
    }

    @Override
    public void replaceSignalMast(SignalMast oldMast, SignalMast newMast) {
        if (oldMast == null || newMast == null) {
            return;
        }
        for (SignalMastLogic source : this._beans) {
            if (source.getSourceMast() == oldMast) {
                source.replaceSourceMast(oldMast, newMast);
                continue;
            }
            source.replaceDestinationMast(oldMast, newMast);
        }
    }

    @Override
    public void swapSignalMasts(SignalMast mastA, SignalMast mastB) {
        if (mastA == null || mastB == null) {
            return;
        }
        List<SignalMastLogic> mastALogicList = this.getLogicsByDestination(mastA);
        SignalMastLogic mastALogicSource = this.getSignalMastLogic(mastA);
        List<SignalMastLogic> mastBLogicList = this.getLogicsByDestination(mastB);
        SignalMastLogic mastBLogicSource = this.getSignalMastLogic(mastB);
        if (mastALogicSource != null) {
            mastALogicSource.replaceSourceMast(mastA, mastB);
        }
        if (mastBLogicSource != null) {
            mastBLogicSource.replaceSourceMast(mastB, mastA);
        }
        for (SignalMastLogic mastALogic : mastALogicList) {
            mastALogic.replaceDestinationMast(mastA, mastB);
        }
        for (SignalMastLogic mastBLogic : mastBLogicList) {
            mastBLogic.replaceDestinationMast(mastB, mastA);
        }
    }

    @Override
    @Nonnull
    public List<SignalMastLogic> getLogicsByDestination(SignalMast destination) {
        ArrayList<SignalMastLogic> list = new ArrayList<SignalMastLogic>();
        for (SignalMastLogic source : this._beans) {
            if (!source.isDestinationValid(destination)) continue;
            list.add(source);
        }
        return list;
    }

    @Override
    @Nonnull
    public List<SignalMastLogic> getSignalMastLogicList() {
        return new ArrayList<SignalMastLogic>(this._beans);
    }

    @Override
    public boolean isSignalMastUsed(@Nonnull SignalMast mast) {
        SignalMastLogic sml = this.getSignalMastLogic(mast);
        if (sml != null && !sml.getDestinationList().isEmpty()) {
            return true;
        }
        return !this.getLogicsByDestination(mast).isEmpty();
    }

    @Override
    public void removeSignalMastLogic(SignalMastLogic sml, SignalMast dest) {
        if (sml.removeDestination(dest)) {
            this.removeSignalMastLogic(sml);
        }
    }

    @Override
    public void removeSignalMastLogic(SignalMastLogic sml) {
        if (sml == null) {
            return;
        }
        sml.dispose();
        this._beans.remove(sml);
        this.firePropertyChange("length", null, (Object)this._beans.size());
    }

    @Override
    public void removeSignalMast(SignalMast mast) {
        if (mast == null) {
            return;
        }
        for (SignalMastLogic source : this._beans) {
            if (!source.isDestinationValid(mast)) continue;
            source.removeDestination(mast);
        }
        SignalMastLogic sml = this.getSignalMastLogic(mast);
        if (sml != null) {
            this.removeSignalMastLogic(sml);
        }
    }

    @Override
    public void disableLayoutEditorUse(SignalMast mast) {
        SignalMastLogic source = this.getSignalMastLogic(mast);
        if (source != null) {
            source.disableLayoutEditorUse();
        }
        for (SignalMastLogic sml : this.getLogicsByDestination(mast)) {
            try {
                sml.useLayoutEditor(false, mast);
            }
            catch (JmriException e) {
                log.error("Error occurred while trying to disable layout editor use {}", (Throwable)e);
            }
        }
    }

    @Override
    public void initialise() {
        for (SignalMastLogic signalMastLogic : this._beans) {
            signalMastLogic.initialise();
        }
    }

    @Override
    public char typeLetter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSignalLogicDelay() {
        return this.signalLogicDelay;
    }

    @Override
    public void setSignalLogicDelay(int l) {
        this.signalLogicDelay = l;
    }

    @Override
    public void discoverSignallingDest(SignalMast source, LayoutEditor layout) throws JmriException {
        this.firePropertyChange("autoSignalMastGenerateStart", null, source.getDisplayName());
        HashMap<SignalMast, List<NamedBean>> validPaths = new HashMap<SignalMast, List<NamedBean>>();
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        if (!lbm.isAdvancedRoutingEnabled()) {
            throw new JmriException("advanced routing not enabled");
        }
        if (!lbm.routingStablised()) {
            throw new JmriException("routing not stabilised");
        }
        validPaths.put(source, lbm.getLayoutBlockConnectivityTools().discoverPairDest(source, layout, SignalMast.class, LayoutBlockConnectivityTools.Routing.MASTTOMAST));
        validPaths.entrySet().forEach(entry -> {
            SignalMast key = (SignalMast)entry.getKey();
            SignalMastLogic sml = this.getSignalMastLogic(key);
            if (sml == null) {
                sml = this.newSignalMastLogic(key);
            }
            List validDestMast = (List)entry.getValue();
            for (NamedBean sm : validDestMast) {
                if (sml.isDestinationValid((SignalMast)sm)) continue;
                try {
                    sml.setDestinationMast((SignalMast)sm);
                    sml.useLayoutEditorDetails(true, true, (SignalMast)sm);
                    sml.useLayoutEditor(true, (SignalMast)sm);
                }
                catch (JmriException e) {
                    log.error("Exception found when adding pair {}  to destination {}/\n{}", new Object[]{source.getDisplayName(), sm.getDisplayName(), e.toString()});
                }
            }
            if (sml.getDestinationList().size() == 1 && sml.getAutoTurnouts(sml.getDestinationList().get(0)).isEmpty()) {
                key.setProperty("intermediateSignal", true);
            } else {
                key.removeProperty("intermediateSignal");
            }
        });
        this.initialise();
        this.firePropertyChange("autoSignalMastGenerateComplete", null, source.getDisplayName());
    }

    @Override
    public void automaticallyDiscoverSignallingPairs() throws JmriException {
        this.runWhenStablised = false;
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        if (!lbm.isAdvancedRoutingEnabled()) {
            throw new JmriException("advanced routing not enabled");
        }
        if (!lbm.routingStablised()) {
            this.runWhenStablised = true;
            return;
        }
        HashMap<NamedBean, List<NamedBean>> validPaths = lbm.getLayoutBlockConnectivityTools().discoverValidBeanPairs(null, SignalMast.class, LayoutBlockConnectivityTools.Routing.MASTTOMAST);
        this.firePropertyChange("autoGenerateUpdate", null, "Found " + validPaths.size() + " masts as sources for logic");
        InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet().forEach(nb -> nb.removeProperty("intermediateSignal"));
        for (Map.Entry<NamedBean, List<NamedBean>> e : validPaths.entrySet()) {
            SignalMast key = (SignalMast)e.getKey();
            SignalMastLogic sml = this.getSignalMastLogic(key);
            if (sml == null) {
                sml = this.newSignalMastLogic(key);
            }
            List<NamedBean> validDestMast = validPaths.get(key);
            for (NamedBean nb2 : validDestMast) {
                if (sml.isDestinationValid((SignalMast)nb2)) continue;
                try {
                    sml.setDestinationMast((SignalMast)nb2);
                    sml.useLayoutEditorDetails(true, true, (SignalMast)nb2);
                    sml.useLayoutEditor(true, (SignalMast)nb2);
                }
                catch (JmriException ex) {
                    log.debug(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            if (sml.getDestinationList().size() != 1 || !sml.getAutoTurnouts(sml.getDestinationList().get(0)).isEmpty()) continue;
            key.setProperty("intermediateSignal", true);
        }
        this.initialise();
        this.firePropertyChange("autoGenerateComplete", null, null);
    }

    public void generateSection() {
        SectionManager sm = InstanceManager.getDefault(SectionManager.class);
        sm.getNamedBeanSet().stream().map(nb -> {
            if (nb.getSectionType() == 2) {
                nb.removeProperty("intermediateSection");
            }
            return nb;
        }).forEachOrdered(nb -> nb.removeProperty("forwardMast"));
        block4: for (SignalMastLogic sml : this.getSignalMastLogicList()) {
            LayoutBlock faceLBlock = sml.getFacingBlock();
            if (faceLBlock != null) {
                boolean sourceIntermediate = false;
                Object intermSigProp = sml.getSourceMast().getProperty("intermediateSignal");
                if (intermSigProp != null) {
                    sourceIntermediate = (Boolean)intermSigProp;
                }
                for (SignalMast destMast : sml.getDestinationList()) {
                    if (sml.getAutoBlocksBetweenMasts(destMast).isEmpty()) continue;
                    String secUserName = String.valueOf(sml.getSourceMast().getDisplayName()) + ":" + destMast.getDisplayName();
                    Section sec = sm.getSection(secUserName);
                    if (sec != null) {
                        if (sec.getSectionType() != 2) {
                            continue block4;
                        }
                    } else {
                        try {
                            sec = sm.createNewSection(secUserName);
                        }
                        catch (IllegalArgumentException ex) {
                            log.warn("Unable to create section for {} {}", (Object)secUserName, (Object)ex.getMessage());
                            continue;
                        }
                        sec.setSectionType(2);
                        try {
                            Sensor sen = InstanceManager.sensorManagerInstance().provideSensor("IS:" + sec.getSystemName() + ":forward");
                            sen.setUserName(String.valueOf(sec.getSystemName()) + ":forward");
                            sen = InstanceManager.sensorManagerInstance().provideSensor("IS:" + sec.getSystemName() + ":reverse");
                            sen.setUserName(String.valueOf(sec.getSystemName()) + ":reverse");
                            sec.setForwardBlockingSensorName(String.valueOf(sec.getSystemName()) + ":forward");
                            sec.setReverseBlockingSensorName(String.valueOf(sec.getSystemName()) + ":reverse");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            log.warn("Failed to provide Sensor in generateSection");
                        }
                    }
                    sml.setAssociatedSection(sec, destMast);
                    sec.setProperty("forwardMast", destMast.getDisplayName());
                    boolean destIntermediate = false;
                    Object destMastImSigProp = destMast.getProperty("intermediateSignal");
                    if (destMastImSigProp != null) {
                        destIntermediate = (Boolean)destMastImSigProp;
                    }
                    if (sourceIntermediate || destIntermediate) {
                        sec.setProperty("intermediateSection", true);
                        continue;
                    }
                    sec.setProperty("intermediateSection", false);
                }
                continue;
            }
            log.info("No facing block found {}", (Object)sml.getSourceMast().getDisplayName());
        }
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSignalMastLogics" : "BeanNameSignalMastLogic");
    }

    @Override
    public Class<SignalMastLogic> getNamedBeanClass() {
        return SignalMastLogic.class;
    }

    @Override
    public int setupSignalMastsDirectionSensors() {
        int errorCount = 0;
        for (SignalMastLogic sml : this.getSignalMastLogicList()) {
            errorCount += sml.setupDirectionSensors();
        }
        return errorCount;
    }

    @Override
    public void removeSignalMastsDirectionSensors() {
        for (SignalMastLogic sml : this.getSignalMastLogicList()) {
            sml.removeDirectionSensors();
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(LayoutBlockManager.class).removePropertyChangeListener(this.propertyBlockManagerListener);
        InstanceManager.getDefault(SignalMastManager.class).removeVetoableChangeListener(this);
        InstanceManager.getDefault(TurnoutManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

