/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.beans.Bean;
import jmri.util.ThreadingUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultShutDownManager
extends Bean
implements ShutDownManager {
    private static boolean shuttingDown = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultShutDownManager.class);
    private final List<ShutDownTask> tasks = new ArrayList<ShutDownTask>();
    private final Set<Callable<Boolean>> callables = new HashSet<Callable<Boolean>>();
    private final Set<Runnable> runnables = new HashSet<Runnable>();
    protected final Thread shutdownHook = ThreadingUtil.newThread(() -> {
        boolean bl = this.shutdown(0, false);
    });
    private static final RequestProcessor RP = new RequestProcessor("On Start/Stop", 8);
    private static final String NO_NULL_TASK = "Shutdown task cannot be null.";
    private static final String PROP_SHUTTING_DOWN = "shuttingDown";

    public DefaultShutDownManager() {
        super(false);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Override
    public synchronized void register(ShutDownTask s) {
        Objects.requireNonNull(s, NO_NULL_TASK);
        if (!this.tasks.contains(s)) {
            this.tasks.add(s);
        } else {
            log.debug("already contains {}", (Object)s);
        }
        this.runnables.add(s);
        this.callables.add(s);
        this.addPropertyChangeListener(PROP_SHUTTING_DOWN, s);
    }

    @Override
    public synchronized void register(Callable<Boolean> task) {
        Objects.requireNonNull(task, NO_NULL_TASK);
        this.callables.add(task);
    }

    @Override
    public synchronized void register(Runnable task) {
        Objects.requireNonNull(task, NO_NULL_TASK);
        this.runnables.add(task);
    }

    @Override
    public synchronized void deregister(ShutDownTask s) {
        this.removePropertyChangeListener(PROP_SHUTTING_DOWN, s);
        this.tasks.remove(s);
        this.callables.remove(s);
        this.runnables.remove(s);
    }

    @Override
    public synchronized void deregister(Callable<Boolean> task) {
        this.callables.remove(task);
    }

    @Override
    public synchronized void deregister(Runnable task) {
        this.runnables.remove(task);
    }

    @Override
    public List<ShutDownTask> tasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    @Override
    public List<Callable<Boolean>> getCallables() {
        ArrayList<Callable<Boolean>> list = new ArrayList<Callable<Boolean>>();
        list.addAll(this.callables);
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<Runnable> getRunnables() {
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        list.addAll(this.runnables);
        return Collections.unmodifiableList(list);
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="OK to directly exit standalone main")
    public boolean shutdown() {
        return this.shutdown(0, true);
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="OK to directly exit standalone main")
    public boolean restart() {
        return this.shutdown(100, true);
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="OK to directly exit standalone main")
    public boolean restartOS() {
        return this.shutdown(210, true);
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="OK to directly exit standalone main")
    public boolean shutdownOS() {
        return this.shutdown(200, true);
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="OK to directly exit standalone main")
    protected boolean shutdown(int status, boolean exit) {
        if (!shuttingDown) {
            Date start = new Date();
            log.debug("Shutting down with {} tasks", (Object)this.tasks.size());
            this.setShuttingDown(true);
            for (Callable<Boolean> task2 : this.callables) {
                try {
                    if (!Boolean.FALSE.equals(task2.call())) continue;
                    this.setShuttingDown(false);
                    return false;
                }
                catch (Exception ex) {
                    log.error("Unable to stop", (Throwable)ex);
                    this.setShuttingDown(false);
                    return false;
                }
            }
            int timeout = 30000;
            if (!GraphicsEnvironment.isHeadless()) {
                Arrays.asList(Frame.getFrames()).stream().forEach(frame -> {
                    if (frame.isDisplayable()) {
                        log.debug("Closing frame \"{}\", title: \"{}\"", (Object)frame.getName(), (Object)frame.getTitle());
                        Date timer = new Date();
                        frame.dispatchEvent(new WindowEvent((Window)frame, 201));
                        log.debug("Frame \"{}\" took {} milliseconds to close", (Object)frame.getName(), (Object)(new Date().getTime() - timer.getTime()));
                    }
                });
            }
            log.debug("windows completed closing {} milliseconds after starting shutdown", (Object)(new Date().getTime() - start.getTime()));
            try {
                if (!this.runnables.isEmpty() && !new ProxyTask(new HashSet<Runnable>(this.runnables).stream().map(task -> RP.post(task, 0, Thread.currentThread().getPriority())).collect(Collectors.toSet())).waitFinished(timeout)) {
                    log.warn("Terminating without waiting for stop tasks to complete");
                }
            }
            catch (InterruptedException interruptedException) {}
            log.debug("Shutdown took {} milliseconds.", (Object)(new Date().getTime() - start.getTime()));
            log.info("Normal termination complete");
            if (exit) {
                System.exit(status);
            }
        }
        return false;
    }

    @Override
    public boolean isShuttingDown() {
        return shuttingDown;
    }

    protected void setShuttingDown(boolean state) {
        boolean old = shuttingDown;
        shuttingDown = state;
        log.debug("Setting shuttingDown to {}", (Object)state);
        this.firePropertyChange(PROP_SHUTTING_DOWN, old, state);
    }

    static final class ProxyTask
    extends Task
    implements TaskListener {
        private int cnt;

        public ProxyTask(Collection<? extends Task> waitFor) {
            super(null);
            this.cnt = waitFor.size();
            this.notifyRunning();
            waitFor.forEach(t -> t.addTaskListener((TaskListener)this));
        }

        public synchronized void taskFinished(Task task) {
            if (--this.cnt == 0) {
                this.notifyFinished();
            }
        }
    }
}

