/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.implementation.DefaultRoute;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRouteManager
extends AbstractManager<Route>
implements RouteManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultRouteManager.class);

    public DefaultRouteManager(InternalSystemConnectionMemo memo) {
        super(memo);
        this.addListeners();
    }

    final void addListeners() {
        InstanceManager.getDefault(TurnoutManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(SensorManager.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 160;
    }

    @Override
    public char typeLetter() {
        return 'O';
    }

    @Override
    @Nonnull
    public Route provideRoute(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        Route r;
        log.debug("provideRoute({})", (Object)systemName);
        if (userName != null && (r = (Route)this.getByUserName(userName)) != null) {
            return r;
        }
        r = (Route)this.getBySystemName(systemName);
        if (r != null) {
            return r;
        }
        r = new DefaultRoute(this.validateSystemNameFormat(systemName), userName);
        this.register(r);
        this.updateAutoNumber(systemName);
        return r;
    }

    @Override
    @Nonnull
    public Route newRoute(@Nonnull String userName) throws IllegalArgumentException {
        return this.provideRoute(this.getAutoSystemName(), userName);
    }

    @Override
    public void deleteRoute(@Nonnull Route r) {
        this.deregister(r);
    }

    @Override
    @CheckForNull
    public Route getRoute(@Nonnull String name) {
        Route r = (Route)this.getByUserName(name);
        return r != null ? r : (Route)this.getBySystemName(name);
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameRoutes" : "BeanNameRoute");
    }

    @Override
    public Class<Route> getNamedBeanClass() {
        return Route.class;
    }

    @Override
    @Nonnull
    public Route provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideRoute(name, null);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(TurnoutManager.class).removeVetoableChangeListener(this);
        InstanceManager.getDefault(SensorManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

