/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.implementation.DefaultRailCom;
import jmri.jmrix.ConflictingSystemConnectionMemo;
import jmri.managers.DefaultIdTagManager;
import jmri.managers.configurexml.DefaultIdTagManagerXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRailComManager
extends DefaultIdTagManager
implements RailComManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultRailComManager.class);

    public DefaultRailComManager() {
        super(new ConflictingSystemConnectionMemo("R", "RailCom"));
        this.setInstances();
    }

    final void setInstances() {
        InstanceManager.store(this, RailComManager.class);
        InstanceManager.setIdTagManager(this);
    }

    @Override
    protected RailCom createNewIdTag(@Nonnull String systemName, String userName) {
        if (!systemName.startsWith(String.valueOf(this.getSystemPrefix()) + "D")) {
            systemName = String.valueOf(this.getSystemPrefix()) + "D" + systemName;
        }
        return new DefaultRailCom(systemName, userName);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="defensive programming check of @Nonnull argument")
    private void checkSystemName(@Nonnull String systemName, @CheckForNull String userName) {
        if (systemName == null) {
            log.error("SystemName cannot be null. UserName was {}", (Object)(userName == null ? "null" : userName));
            throw new IllegalArgumentException("SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        }
    }

    @Override
    @Nonnull
    public IdTag newIdTag(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        RailCom s;
        log.debug("new IdTag: {};{}", (Object)systemName, (Object)(userName == null ? "null" : userName));
        this.checkSystemName(systemName, userName);
        if (userName != null && (s = (RailCom)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != s) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, s.getSystemName()});
            }
            return s;
        }
        s = (RailCom)this.getBySystemName(systemName);
        if (s != null) {
            if (s.getUserName() == null && userName != null) {
                s.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found IdTag via system name ({}) with non-null user name ({})", (Object)systemName, (Object)userName);
            }
            return s;
        }
        s = this.createNewIdTag(systemName, userName);
        this.register(s);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s;
    }

    @Override
    public void writeIdTagDetails() throws IOException {
        if (this.dirty) {
            new DefaultIdTagManagerXml(this, "RailComIdTags.xml").store();
            this.dirty = false;
            log.debug("...done writing IdTag details");
        }
    }

    @Override
    public void readIdTagDetails() {
        log.debug("reading idTag Details");
        new DefaultIdTagManagerXml(this, "RailComIdTags.xml").load();
        this.dirty = false;
        log.debug("...done reading IdTag details");
    }
}

