/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.LocoAddress;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.SystemConnectionMemo;
import jmri.beans.PropertyChangeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProgrammerManager
extends PropertyChangeSupport
implements AddressedProgrammerManager,
GlobalProgrammerManager {
    private Programmer programmer;
    private String userName = "<Default>";
    private static final Logger log = LoggerFactory.getLogger(DefaultProgrammerManager.class);

    public DefaultProgrammerManager() {
        this(null);
    }

    public DefaultProgrammerManager(@CheckForNull Programmer programmer) {
        this.programmer = programmer;
    }

    public DefaultProgrammerManager(@CheckForNull Programmer programmer, @Nonnull SystemConnectionMemo memo) {
        this(programmer);
        this.userName = memo.getUserName();
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String toString() {
        return this.getUserName();
    }

    @Override
    public Programmer getGlobalProgrammer() {
        log.debug("return default service-mode programmer of type {}", this.programmer != null ? this.programmer.getClass() : "(null)");
        return this.programmer;
    }

    @Override
    public AddressedProgrammer getAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return null;
    }

    @Override
    public Programmer reserveGlobalProgrammer() {
        return this.programmer;
    }

    @Override
    public void releaseGlobalProgrammer(@Nonnull Programmer p) {
    }

    @Override
    public AddressedProgrammer reserveAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return null;
    }

    @Override
    public void releaseAddressedProgrammer(@Nonnull AddressedProgrammer p) {
    }

    @Override
    public boolean isAddressedModePossible() {
        return false;
    }

    @Override
    public boolean isAddressedModePossible(@Nonnull LocoAddress l) {
        return this.isAddressedModePossible();
    }

    @Override
    public boolean isGlobalProgrammerAvailable() {
        return true;
    }

    @Override
    public List<ProgrammingMode> getDefaultModes() {
        ArrayList<ProgrammingMode> retval = new ArrayList<ProgrammingMode>();
        retval.add(ProgrammingMode.OPSBYTEMODE);
        return retval;
    }
}

