/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Disposable;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ShutDownManager;
import jmri.SystemConnectionMemo;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.implementation.DefaultIdTag;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import jmri.managers.configurexml.DefaultIdTagManagerXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdTagManager
extends AbstractManager<IdTag>
implements IdTagManager,
Disposable {
    protected boolean dirty = false;
    private boolean initialised = false;
    private boolean loading = false;
    private boolean storeState = false;
    private boolean useFastClock = false;
    private Runnable shutDownTask = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultIdTagManager.class);

    public DefaultIdTagManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 190;
    }

    @Override
    public boolean isInitialised() {
        return this.initialised;
    }

    @Override
    public void init() {
        log.debug("init called");
        if (!this.initialised && !this.loading) {
            log.debug("Initialising");
            this.loading = true;
            this.readIdTagDetails();
            this.loading = false;
            this.dirty = false;
            this.initShutdownTask();
            this.initialised = true;
        }
    }

    protected void initShutdownTask() {
        log.debug("Register ShutDown task");
        if (this.shutDownTask == null) {
            this.shutDownTask = () -> {
                log.debug("Start writing IdTag details...");
                try {
                    this.writeIdTagDetails();
                }
                catch (IOException ioe) {
                    log.error("Exception writing IdTags: {}", (Object)ioe);
                }
            };
            InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        }
    }

    @Override
    protected void registerSelf() {
    }

    @Override
    public char typeLetter() {
        return 'D';
    }

    @Override
    @Nonnull
    public IdTag provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideIdTag(name);
    }

    @Override
    @Nonnull
    public IdTag provideIdTag(@Nonnull String name) throws IllegalArgumentException {
        IdTag t;
        if (!this.initialised && !this.loading) {
            this.init();
        }
        if ((t = this.getIdTag(name)) != null) {
            return t;
        }
        if (name.startsWith(String.valueOf(this.getSystemPrefix()) + this.typeLetter())) {
            return this.newIdTag(name, null);
        }
        if (!name.isEmpty()) {
            return this.newIdTag(this.makeSystemName(name), null);
        }
        throw new IllegalArgumentException("\"" + name + "\" is invalid");
    }

    @Override
    @CheckForNull
    public IdTag getIdTag(@Nonnull String name) {
        IdTag t;
        if (!this.initialised && !this.loading) {
            this.init();
        }
        if ((t = this.getBySystemName(this.makeSystemName(name))) != null) {
            return t;
        }
        t = this.getByUserName(name);
        if (t != null) {
            return t;
        }
        return this.getBySystemName(name);
    }

    @Override
    @CheckForNull
    public IdTag getBySystemName(@Nonnull String name) {
        if (!this.initialised && !this.loading) {
            this.init();
        }
        return (IdTag)this._tsys.get(name);
    }

    @Override
    @CheckForNull
    public IdTag getByUserName(@Nonnull String key) {
        if (!this.initialised && !this.loading) {
            this.init();
        }
        return (IdTag)this._tuser.get(key);
    }

    @Override
    @CheckForNull
    public IdTag getByTagID(@Nonnull String tagID) {
        if (!this.initialised && !this.loading) {
            this.init();
        }
        return this.getBySystemName(this.makeSystemName(tagID));
    }

    @Nonnull
    protected IdTag createNewIdTag(String systemName, String userName) throws IllegalArgumentException {
        if (!systemName.startsWith(String.valueOf(this.getSystemPrefix()) + this.typeLetter())) {
            systemName = String.valueOf(this.getSystemPrefix()) + this.typeLetter() + systemName;
        }
        return new DefaultIdTag(systemName, userName);
    }

    @Override
    @Nonnull
    public IdTag newIdTag(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        IdTag s;
        if (!this.initialised && !this.loading) {
            this.init();
        }
        log.debug("new IdTag:{};{}", (Object)systemName, (Object)userName);
        Objects.requireNonNull(systemName, "SystemName cannot be null.");
        if (userName != null && (s = this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != s) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, s.getSystemName()});
            }
            return s;
        }
        s = this.getBySystemName(systemName);
        if (s != null) {
            if (s.getUserName() == null && userName != null) {
                s.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found IdTag via system name ({}) with non-null user name ({})", (Object)systemName, (Object)userName);
            }
            return s;
        }
        s = this.createNewIdTag(systemName, userName);
        this.register(s);
        return s;
    }

    @Override
    public void register(@Nonnull IdTag s) {
        super.register(s);
        this.setDirty(true);
    }

    @Override
    public void deregister(@Nonnull IdTag s) {
        super.deregister(s);
        this.setDirty(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        this.setDirty(true);
    }

    public void writeIdTagDetails() throws IOException {
        if (this.dirty) {
            new DefaultIdTagManagerXml(this, "IdTags.xml").store();
            this.dirty = false;
            log.debug("...done writing IdTag details");
        }
    }

    public void readIdTagDetails() {
        log.debug("reading idTag Details");
        new DefaultIdTagManagerXml(this, "IdTags.xml").load();
        this.dirty = false;
        log.debug("...done reading IdTag details");
    }

    @Override
    public void setStateStored(boolean state) {
        if (!this.initialised && !this.loading) {
            this.init();
        }
        if (state != this.storeState) {
            this.setDirty(true);
        }
        boolean old = this.storeState;
        this.storeState = state;
        this.firePropertyChange("StateStored", old, state);
    }

    @Override
    public boolean isStateStored() {
        if (!this.initialised && !this.loading) {
            this.init();
        }
        return this.storeState;
    }

    @Override
    public void setFastClockUsed(boolean fastClock) {
        if (!this.initialised && !this.loading) {
            this.init();
        }
        if (fastClock != this.useFastClock) {
            this.setDirty(true);
        }
        boolean old = this.useFastClock;
        this.useFastClock = fastClock;
        this.firePropertyChange("UseFastClock", old, fastClock);
    }

    @Override
    public boolean isFastClockUsed() {
        if (!this.initialised && !this.loading) {
            this.init();
        }
        return this.useFastClock;
    }

    @Override
    @Nonnull
    public List<IdTag> getTagsForReporter(@Nonnull Reporter reporter, long threshold) {
        ArrayList<IdTag> out = new ArrayList<IdTag>();
        Date lastWhenLastSeen = new Date(0L);
        for (IdTag n : this._tsys.values()) {
            IdTag t2 = n;
            if (t2.getWhereLastSeen() != reporter) continue;
            out.add(t2);
            Date tagLastSeen = t2.getWhenLastSeen();
            if (tagLastSeen == null || !tagLastSeen.after(lastWhenLastSeen)) continue;
            lastWhenLastSeen = tagLastSeen;
        }
        Date thresholdTime = new Date(lastWhenLastSeen.getTime() - threshold);
        out.removeIf(t -> {
            Date tagLastSeen = t.getWhenLastSeen();
            return tagLastSeen == null || tagLastSeen.before(thresholdTime);
        });
        return out;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void dispose() {
        if (this.shutDownTask != null) {
            InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
        }
        super.dispose();
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameReporters" : "BeanNameReporter");
    }

    @Override
    public Class<IdTag> getNamedBeanClass() {
        return IdTag.class;
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        @Nonnull
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(IdTagManager.class)) {
                return new DefaultIdTagManager(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
            }
            return super.getDefault(type);
        }

        @Override
        @Nonnull
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(IdTagManager.class);
            return set;
        }
    }
}

