/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.Conditional;
import jmri.ConditionalManager;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.implementation.DefaultConditional;
import jmri.implementation.SensorGroupConditional;
import jmri.jmrit.sensorgroup.SensorGroupFrame;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import jmri.util.LoggingUtil;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalManager
extends AbstractManager<Conditional>
implements ConditionalManager {
    private static final String[] PATTERNS = new String[]{"(.*?)(C\\d+$)", "(.*?)([1-9]{1}[ALT]$)", "(.*?)([0-9]{2}[ALT]$)", "(.*?)([0-9]{3}[ALT]$)"};
    private final HashMap<String, ArrayList<String>> conditionalWhereUsed = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalManager.class);

    public DefaultConditionalManager(InternalSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 240;
    }

    @Override
    public char typeLetter() {
        return 'X';
    }

    @Override
    public Conditional createNewConditional(String systemName, String userName) {
        Conditional c = null;
        if (systemName == null || systemName.length() < 1) {
            log.error("createNewConditional: systemName is null or empty");
            return null;
        }
        c = this.getBySystemName(systemName);
        if (c != null) {
            return null;
        }
        Logix lgx = this.getParentLogix(systemName);
        if (lgx == null) {
            log.error("Unable to find the parent logix for condtional '{}'", (Object)systemName);
            return null;
        }
        if (userName != null && userName.length() > 0 && (c = this.getByUserName(lgx, userName)) != null) {
            return null;
        }
        c = systemName.startsWith(SensorGroupFrame.logixSysName) ? new SensorGroupConditional(systemName, userName) : new DefaultConditional(systemName, userName);
        boolean addCompleted = lgx.addConditional(systemName, c);
        if (!addCompleted) {
            return null;
        }
        return c;
    }

    @Override
    protected void handleUserNameUniqueness(Conditional s) {
    }

    @Override
    public Logix getParentLogix(String name) {
        if (name == null || name.length() < 4) {
            return null;
        }
        String[] stringArray = PATTERNS;
        int n = PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            Logix lgx;
            String pattern = stringArray[n2];
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(name);
            if (m.find() && (lgx = InstanceManager.getDefault(LogixManager.class).getBySystemName(m.group(1))) != null) {
                return lgx;
            }
            ++n2;
        }
        LogixManager logixManager = InstanceManager.getDefault(LogixManager.class);
        for (Logix lgx : logixManager.getNamedBeanSet()) {
            int i = 0;
            while (i < lgx.getNumConditionals()) {
                String cdlName = lgx.getConditionalByNumberOrder(i);
                if (cdlName.equals(name)) {
                    return lgx;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void deleteConditional(Conditional c) {
    }

    @Override
    public Conditional getConditional(Logix x, String name) {
        Conditional c = null;
        if (x != null && (c = this.getByUserName(x, name)) != null) {
            return c;
        }
        return this.getBySystemName(name);
    }

    @Override
    public Conditional getConditional(String name) {
        Conditional c = this.getBySystemName(name);
        if (c == null) {
            c = this.getByUserName(name);
        }
        return c;
    }

    @Override
    public Conditional getByUserName(String key) {
        if (key == null) {
            return null;
        }
        Conditional c = null;
        for (Conditional chkC : this.getNamedBeanSet()) {
            if (!key.equals(chkC.getUserName())) continue;
            if (c == null) {
                c = chkC;
                continue;
            }
            log.warn("Duplicate conditional user names found, key = {}", (Object)key);
            return null;
        }
        return c;
    }

    @Override
    public Conditional getByUserName(Logix x, String key) {
        if (x == null) {
            return null;
        }
        int i = 0;
        while (i < x.getNumConditionals()) {
            String uName;
            Conditional c = this.getBySystemName(x.getConditionalByNumberOrder(i));
            if (c != null && key.equals(uName = c.getUserName())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Conditional getBySystemName(String name) {
        if (name == null) {
            return null;
        }
        Logix lgx = this.getParentLogix(name);
        if (lgx == null) {
            return null;
        }
        return lgx.getConditional(name);
    }

    @Override
    public List<String> getSystemNameListForLogix(Logix x) {
        if (x == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < x.getNumConditionals()) {
            nameList.add(x.getConditionalByNumberOrder(i));
            ++i;
        }
        return nameList;
    }

    @Override
    @Deprecated
    @Nonnull
    public List<String> getSystemNameList() {
        LoggingUtil.deprecationWarning(log, "getSystemNameList");
        ArrayList<String> nameList = new ArrayList<String>();
        LogixManager logixManager = InstanceManager.getDefault(LogixManager.class);
        for (Logix lgx : logixManager.getNamedBeanSet()) {
            int i = 0;
            while (i < lgx.getNumConditionals()) {
                nameList.add(lgx.getConditionalByNumberOrder(i));
                ++i;
            }
        }
        Collections.sort(nameList);
        return nameList;
    }

    @Override
    @Nonnull
    public SortedSet<Conditional> getNamedBeanSet() {
        TreeSet conditionals = new TreeSet(new NamedBeanComparator());
        LogixManager logixManager = InstanceManager.getDefault(LogixManager.class);
        for (Logix lgx : logixManager.getNamedBeanSet()) {
            int i = 0;
            while (i < lgx.getNumConditionals()) {
                Conditional cdl = this.getBySystemName(lgx.getConditionalByNumberOrder(i));
                if (cdl != null) {
                    conditionals.add(cdl);
                }
                ++i;
            }
        }
        return Collections.unmodifiableSortedSet(conditionals);
    }

    @Deprecated
    public static DefaultConditionalManager instance() {
        return InstanceManager.getDefault(DefaultConditionalManager.class);
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameConditionals" : "BeanNameConditional");
    }

    @Override
    public Class<Conditional> getNamedBeanClass() {
        return Conditional.class;
    }

    @Override
    public HashMap<String, ArrayList<String>> getWhereUsedMap() {
        return new HashMap<String, ArrayList<String>>(this.conditionalWhereUsed);
    }

    @Override
    public void addWhereUsed(String target, String reference) {
        if (target == null || target.equals("")) {
            log.error("Invalid target name for addWhereUsed");
            return;
        }
        if (reference == null || reference.equals("")) {
            log.error("Invalid reference name for addWhereUsed");
            return;
        }
        if (this.conditionalWhereUsed.containsKey(target)) {
            ArrayList<String> refList = this.conditionalWhereUsed.get(target);
            if (!refList.contains(reference)) {
                refList.add(reference);
                this.conditionalWhereUsed.replace(target, refList);
            }
        } else {
            ArrayList<String> refList = new ArrayList<String>();
            refList.add(reference);
            this.conditionalWhereUsed.put(target, refList);
        }
    }

    @Override
    public ArrayList<String> getWhereUsed(String target) {
        if (target == null || target.equals("")) {
            log.error("Invalid target name for getWhereUsed");
            return null;
        }
        return this.conditionalWhereUsed.get(target);
    }

    @Override
    public void removeWhereUsed(String target, String reference) {
        if (target == null || target.equals("")) {
            log.error("Invalid target name for removeWhereUsed");
            return;
        }
        if (reference == null || reference.equals("")) {
            log.error("Invalid reference name for removeWhereUsed");
            return;
        }
        if (this.conditionalWhereUsed.containsKey(target)) {
            ArrayList<String> refList = this.conditionalWhereUsed.get(target);
            refList.remove(reference);
            if (refList.size() == 0) {
                this.conditionalWhereUsed.remove(target);
            }
        }
    }

    @Override
    public void displayWhereUsed() {
        log.info("- Display Conditional Where Used     ");
        TreeSet<String> keys = new TreeSet<String>(this.conditionalWhereUsed.keySet());
        for (String key : keys) {
            log.info("    Target: {}                  ", (Object)key);
            ArrayList<String> refList = this.conditionalWhereUsed.get(key);
            for (String ref : refList) {
                log.info("      Reference: {}             ", (Object)ref);
            }
        }
    }

    @Override
    public ArrayList<String> getTargetList(String reference) {
        ArrayList<String> targetList = new ArrayList<String>();
        TreeSet<String> keys = new TreeSet<String>(this.conditionalWhereUsed.keySet());
        for (String key : keys) {
            ArrayList<String> refList = this.conditionalWhereUsed.get(key);
            for (String ref : refList) {
                if (!ref.equals(reference)) continue;
                targetList.add(key);
            }
        }
        return targetList;
    }
}

