/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.ProxyManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.beans.VetoableChangeSupport;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.util.LoggingUtil;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyManager<E extends NamedBean>
extends VetoableChangeSupport
implements ProxyManager<E>,
PropertyChangeListener,
Manager.ManagerDataListener<E> {
    private final List<String> boundPropertyNames = new ArrayList<String>();
    private final List<String> vetoablePropertyNames = new ArrayList<String>();
    protected final Map<String, Boolean> silencedProperties = new HashMap<String, Boolean>();
    protected final Set<String> silenceableProperties = new HashSet<String>();
    private final Set<Manager<E>> mgrs = new TreeSet<Manager<E>>((e1, e2) -> e1.getSystemPrefix().compareTo(e2.getSystemPrefix()));
    private Manager<E> internalManager = null;
    protected Manager<E> defaultManager = null;
    private TreeSet<E> namedBeanSet = null;
    final List<Manager.ManagerDataListener<E>> listeners = new ArrayList<Manager.ManagerDataListener<E>>();
    private boolean muted = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractProxyManager.class);

    @Override
    public List<Manager<E>> getManagerList() {
        this.initInternal();
        return new ArrayList<Manager<E>>(this.mgrs);
    }

    @Override
    public List<Manager<E>> getDisplayOrderManagerList() {
        this.initInternal();
        ArrayList<Manager<Manager<E>>> retval = new ArrayList<Manager<Manager<E>>>();
        if (this.defaultManager != null) {
            retval.add(this.defaultManager);
        }
        this.mgrs.stream().filter(manager -> manager != this.defaultManager && manager != this.internalManager).forEachOrdered(retval::add);
        if (this.internalManager != null && this.internalManager != this.defaultManager) {
            retval.add(this.internalManager);
        }
        return retval;
    }

    public Manager<E> getInternalManager() {
        this.initInternal();
        return this.internalManager;
    }

    @Override
    @Nonnull
    public Manager<E> getDefaultManager() {
        return this.defaultManager != null ? this.defaultManager : this.getInternalManager();
    }

    @Override
    public void addManager(@Nonnull Manager<E> m) {
        Objects.requireNonNull(m, "Can only add non-null manager");
        for (Manager<E> check : this.mgrs) {
            if (m != check) continue;
            log.warn("Manager already present: {}", m);
            return;
        }
        this.mgrs.add(m);
        if (this.defaultManager == null) {
            this.defaultManager = m;
        }
        Arrays.stream(this.getPropertyChangeListeners()).forEach(l -> m.addPropertyChangeListener((PropertyChangeListener)l));
        Arrays.stream(this.getVetoableChangeListeners()).forEach(l -> m.addVetoableChangeListener((VetoableChangeListener)l));
        this.boundPropertyNames.forEach(n -> Arrays.stream(this.getPropertyChangeListeners((String)n)).forEach(l -> m.addPropertyChangeListener((String)n, (PropertyChangeListener)l)));
        this.vetoablePropertyNames.forEach(n -> Arrays.stream(this.getVetoableChangeListeners((String)n)).forEach(l -> m.addVetoableChangeListener((String)n, (VetoableChangeListener)l)));
        m.addPropertyChangeListener("beans", this);
        m.addDataListener(this);
        this.recomputeNamedBeanSet();
        log.debug("added manager {}", m.getClass());
    }

    protected Manager<E> initInternal() {
        if (this.internalManager == null) {
            log.debug("create internal manager when first requested");
            this.internalManager = this.makeInternalManager();
        }
        return this.internalManager;
    }

    protected abstract Manager<E> makeInternalManager();

    @Override
    public E getNamedBean(@Nonnull String name) {
        E t = this.getByUserName(name);
        if (t != null) {
            return t;
        }
        return this.getBySystemName(name);
    }

    @Override
    @CheckReturnValue
    @CheckForNull
    public E getBySystemName(@Nonnull String systemName) {
        Manager<E> m = this.getManager(systemName);
        if (m == null) {
            log.debug("getBySystemName did not find manager from name {}, defer to default manager", (Object)systemName);
            m = this.getDefaultManager();
        }
        return m.getBySystemName(systemName);
    }

    @Override
    @CheckReturnValue
    @CheckForNull
    public E getByUserName(@Nonnull String userName) {
        for (Manager<E> m : this.mgrs) {
            E b = m.getByUserName(userName);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        Manager<E> manager = this.getManager(systemName);
        if (manager == null) {
            manager = this.getDefaultManager();
        }
        return manager.validateSystemNameFormat(systemName, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        Manager<E> m = this.getManager(systemName);
        return m == null ? Manager.NameValidity.INVALID : m.validSystemNameFormat(systemName);
    }

    @Override
    public void dispose() {
        this.mgrs.forEach(m -> m.dispose());
        this.mgrs.clear();
        if (this.internalManager != null) {
            this.internalManager.dispose();
        }
    }

    @CheckForNull
    protected Manager<E> getManager(@Nonnull String systemName) {
        this.initInternal();
        for (Manager<E> m : this.getManagerList()) {
            if (!systemName.startsWith(m.getSystemNamePrefix())) continue;
            return m;
        }
        return null;
    }

    @Nonnull
    protected Manager<E> getManagerOrDefault(@Nonnull String systemName) {
        Manager<E> manager = this.getManager(systemName);
        if (manager == null) {
            manager = this.getDefaultManager();
        }
        return manager;
    }

    String createSystemName(String curAddress, String prefix, Class<?> beanType) throws JmriException {
        for (Manager<E> m : this.mgrs) {
            if (!prefix.equals(m.getSystemPrefix()) || !beanType.equals(m.getNamedBeanClass())) continue;
            if (beanType == Turnout.class) {
                return ((TurnoutManager)m).createSystemName(curAddress, prefix);
            }
            if (beanType == Sensor.class) {
                return ((SensorManager)m).createSystemName(curAddress, prefix);
            }
            if (beanType == Light.class) {
                return ((LightManager)m).createSystemName(curAddress, prefix);
            }
            if (beanType == Reporter.class) {
                return ((ReporterManager)m).createSystemName(curAddress, prefix);
            }
            log.warn("createSystemName requested for incompatible Manager");
        }
        throw new JmriException("Manager could not be found for System Prefix " + prefix);
    }

    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return this.createSystemName(curAddress, prefix, this.getNamedBeanClass());
    }

    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, char typeLetter) throws JmriException {
        for (Manager<E> m : this.mgrs) {
            log.debug("NextValidAddress requested for {}", (Object)curAddress);
            if (!prefix.equals(m.getSystemPrefix()) || typeLetter != m.typeLetter()) continue;
            switch (typeLetter) {
                case 'T': {
                    return ((TurnoutManager)m).getNextValidAddress(curAddress, prefix);
                }
                case 'S': {
                    return ((SensorManager)m).getNextValidAddress(curAddress, prefix);
                }
                case 'R': {
                    return ((ReporterManager)m).getNextValidAddress(curAddress, prefix);
                }
            }
            return null;
        }
        return null;
    }

    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting, char typeLetter) throws JmriException {
        for (Manager<E> m : this.mgrs) {
            log.debug("NextValidAddress requested for {}", (Object)curAddress);
            if (!prefix.equals(m.getSystemPrefix()) || typeLetter != m.typeLetter()) continue;
            switch (typeLetter) {
                case 'T': {
                    return ((TurnoutManager)m).getNextValidAddress(curAddress, prefix, ignoreInitialExisting);
                }
                case 'S': {
                    return ((SensorManager)m).getNextValidAddress(curAddress, prefix, ignoreInitialExisting);
                }
                case 'L': {
                    return ((LightManager)m).getNextValidAddress(curAddress, prefix, ignoreInitialExisting);
                }
                case 'R': {
                    return ((ReporterManager)m).getNextValidAddress(curAddress, prefix, ignoreInitialExisting);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void deleteBean(@Nonnull E s, @Nonnull String property) throws PropertyVetoException {
        Manager<E> m = this.getManager(s.getSystemName());
        if (m != null) {
            m.deleteBean(s, property);
        }
    }

    protected Manager<E> createSystemManager(@Nonnull SystemConnectionMemo memo) {
        return null;
    }

    @Override
    public String getEntryToolTip() {
        return this.getDefaultManager().getEntryToolTip();
    }

    private Manager<E> createSystemManager(@Nonnull String systemPrefix) {
        ConnectionConfig[] connections;
        Manager<E> m = null;
        ConnectionConfigManager manager = InstanceManager.getNullableDefault(ConnectionConfigManager.class);
        if (manager == null) {
            return null;
        }
        ConnectionConfig[] connectionConfigArray = connections = manager.getConnections();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionConfig connection = connectionConfigArray[n2];
            if (systemPrefix.equals(connection.getAdapter().getSystemPrefix())) {
                m = this.createSystemManager(connection.getAdapter().getSystemConnectionMemo());
            }
            if (m != null) break;
            ++n2;
        }
        return m;
    }

    @Override
    public void register(@Nonnull E s) {
        Manager<E> m = this.getManager(s.getSystemName());
        if (m == null) {
            String systemPrefix = Manager.getSystemPrefix(s.getSystemName());
            m = this.createSystemManager(systemPrefix);
        }
        if (m != null) {
            m.register(s);
        } else {
            log.error("Unable to register {} in this proxy manager. No system specific manager supports this bean.", (Object)s.getSystemName());
        }
    }

    @Override
    public void deregister(@Nonnull E s) {
        Manager<E> m = this.getManager(s.getSystemName());
        if (m != null) {
            m.deregister(s);
        }
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        HashSet set = new HashSet();
        this.mgrs.forEach(m -> {
            boolean bl = set.addAll(m.getKnownBeanProperties());
        });
        return new ArrayList(set);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        this.mgrs.forEach(m -> m.addPropertyChangeListener(l));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        this.mgrs.forEach(m -> m.removePropertyChangeListener(l));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        this.boundPropertyNames.add(propertyName);
        this.mgrs.forEach(m -> m.addPropertyChangeListener(propertyName, listener));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        this.mgrs.forEach(m -> m.removePropertyChangeListener(propertyName, listener));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        super.addVetoableChangeListener(l);
        this.mgrs.forEach(m -> m.addVetoableChangeListener(l));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        super.removeVetoableChangeListener(l);
        this.mgrs.forEach(m -> m.removeVetoableChangeListener(l));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        super.addVetoableChangeListener(propertyName, listener);
        this.vetoablePropertyNames.add(propertyName);
        this.mgrs.forEach(m -> m.addVetoableChangeListener(propertyName, listener));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        super.removeVetoableChangeListener(propertyName, listener);
        this.mgrs.forEach(m -> m.removeVetoableChangeListener(propertyName, listener));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("beans")) {
            this.recomputeNamedBeanSet();
        }
        event.setPropagationId(this);
        if (!this.silencedProperties.getOrDefault(event.getPropertyName(), false).booleanValue()) {
            this.firePropertyChange(event);
        }
    }

    @Override
    @Nonnull
    public SystemConnectionMemo getMemo() {
        try {
            return this.getDefaultManager().getMemo();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return InstanceManager.getDefault(InternalSystemConnectionMemo.class);
        }
    }

    @Override
    @Nonnull
    public String getSystemPrefix() {
        try {
            return this.getDefaultManager().getSystemPrefix();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "?";
        }
    }

    @Override
    public char typeLetter() {
        return this.getDefaultManager().typeLetter();
    }

    @Override
    @Nonnull
    public String makeSystemName(@Nonnull String s) {
        return this.getDefaultManager().makeSystemName(s);
    }

    @Override
    @CheckReturnValue
    public int getObjectCount() {
        return this.mgrs.stream().map(m -> m.getObjectCount()).reduce(0, Integer::sum);
    }

    @Override
    @Nonnull
    @Deprecated
    public List<String> getSystemNameList() {
        LoggingUtil.deprecationWarning(log, "getSystemNameList");
        List<E> list = this.getNamedBeanList();
        ArrayList retval = new ArrayList(list.size());
        list.forEach(e -> {
            boolean bl = retval.add(e.getSystemName());
        });
        return Collections.unmodifiableList(retval);
    }

    @Override
    @Deprecated
    @Nonnull
    public List<E> getNamedBeanList() {
        LoggingUtil.deprecationWarning(log, "getNamedBeanList");
        ArrayList tl = new ArrayList();
        this.mgrs.forEach(m -> {
            boolean bl = tl.addAll(m.getNamedBeanSet());
        });
        return Collections.unmodifiableList(tl);
    }

    protected void recomputeNamedBeanSet() {
        if (this.namedBeanSet != null) {
            this.namedBeanSet.clear();
            this.mgrs.forEach(m -> {
                boolean bl = this.namedBeanSet.addAll(m.getNamedBeanSet());
            });
        }
    }

    @Override
    @Nonnull
    public SortedSet<E> getNamedBeanSet() {
        if (this.namedBeanSet == null) {
            this.namedBeanSet = new TreeSet(new NamedBeanComparator());
            this.recomputeNamedBeanSet();
        }
        return Collections.unmodifiableSortedSet(this.namedBeanSet);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setPropertyChangesSilenced(String propertyName, boolean silenced) {
        if (!"beans".equals(propertyName) && !this.silenceableProperties.contains(propertyName)) {
            throw new IllegalArgumentException("Property " + propertyName + " cannot be silenced.");
        }
        this.silencedProperties.put(propertyName, silenced);
        if (propertyName.equals("beans") && !silenced) {
            this.fireIndexedPropertyChange("beans", this.getNamedBeanSet().size(), null, null);
        }
    }

    @Override
    @Deprecated
    public void addDataListener(Manager.ManagerDataListener<E> e) {
        if (e != null) {
            this.listeners.add(e);
        }
    }

    @Override
    @Deprecated
    public void removeDataListener(Manager.ManagerDataListener<E> e) {
        if (e != null) {
            this.listeners.remove(e);
        }
    }

    @Override
    @Deprecated
    public void contentsChanged(Manager.ManagerDataEvent<E> e) {
    }

    @Override
    @Deprecated
    public void intervalAdded(Manager.ManagerDataEvent<E> e) {
        if (this.namedBeanSet != null && e.getIndex0() == e.getIndex1()) {
            this.namedBeanSet.add(e.getChangedBean());
        } else {
            this.recomputeNamedBeanSet();
        }
        if (this.muted) {
            return;
        }
        int offset = 0;
        for (Manager<E> m2 : this.mgrs) {
            if (m2 == e.getSource()) break;
            offset += m2.getObjectCount();
        }
        Manager.ManagerDataEvent eOut = new Manager.ManagerDataEvent(this, 1, e.getIndex0() + offset, e.getIndex1() + offset, e.getChangedBean());
        this.listeners.forEach(m -> m.intervalAdded(eOut));
    }

    @Override
    @Deprecated
    public void intervalRemoved(Manager.ManagerDataEvent<E> e) {
        this.recomputeNamedBeanSet();
        if (this.muted) {
            return;
        }
        int offset = 0;
        for (Manager<E> m2 : this.mgrs) {
            if (m2 == e.getSource()) break;
            offset += m2.getObjectCount();
        }
        Manager.ManagerDataEvent eOut = new Manager.ManagerDataEvent(this, 2, e.getIndex0() + offset, e.getIndex1() + offset, e.getChangedBean());
        this.listeners.forEach(m -> m.intervalRemoved(eOut));
    }

    @Override
    @Deprecated
    public void setDataListenerMute(boolean m) {
        if (this.muted && !m) {
            Manager.ManagerDataEvent<Object> e = new Manager.ManagerDataEvent<Object>(this, 0, 0, this.getObjectCount() - 1, null);
            this.listeners.forEach(listener -> listener.contentsChanged(e));
        }
        this.muted = m;
    }
}

