/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProvidingManager;
import jmri.managers.AbstractProxyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProvidingProxyManager<E extends NamedBean>
extends AbstractProxyManager<E>
implements ProvidingManager<E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractProvidingProxyManager.class);

    @Nonnull
    protected E provideNamedBean(String name) throws IllegalArgumentException {
        this.initInternal();
        Object t = this.getNamedBean(name);
        if (t != null) {
            return t;
        }
        Manager manager = this.getManager(name);
        if (manager != null) {
            return this.makeBean(manager, name, null);
        }
        log.debug("provideNamedBean did not find manager for name {}, defer to default", (Object)name);
        return this.makeBean(this.getDefaultManager(), this.getDefaultManager().makeSystemName(name), null);
    }

    @Nonnull
    public E newNamedBean(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        this.initInternal();
        Manager m = this.getManager(systemName);
        if (m != null) {
            return this.makeBean(m, systemName, userName);
        }
        log.debug("Did not find manager for system name {}, delegate to primary", (Object)systemName);
        return this.makeBean(this.getDefaultManager(), systemName, userName);
    }

    @Nonnull
    protected abstract E makeBean(Manager<E> var1, @Nonnull String var2, String var3) throws IllegalArgumentException;
}

