/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.Instant;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.SystemConnectionMemo;
import jmri.beans.PropertyChangeSupport;

public abstract class AbstractPowerManager<M extends SystemConnectionMemo>
extends PropertyChangeSupport
implements PowerManager {
    protected final M memo;
    protected int power = 1;
    private Instant lastOn;

    public AbstractPowerManager(M memo) {
        this.memo = memo;
        TimeKeeper tk = new TimeKeeper();
        this.addPropertyChangeListener(tk);
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPower(int state) throws JmriException {
        int old = this.power;
        this.power = state;
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public final String getUserName() {
        return this.memo.getUserName();
    }

    public long timeSinceLastPowerOn() {
        if (this.lastOn == null) {
            return Long.MAX_VALUE;
        }
        return Instant.now().toEpochMilli() - this.lastOn.toEpochMilli();
    }

    protected final void firePowerPropertyChange(int old, int current) {
        this.firePropertyChange("power", old, current);
        this.firePropertyChange("Power", old, current);
    }

    public class TimeKeeper
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            int newPowerState;
            if ("power".equals(e.getPropertyName()) && (newPowerState = AbstractPowerManager.this.getPower()) != AbstractPowerManager.this.power) {
                AbstractPowerManager.this.power = newPowerState;
                if (newPowerState == 2) {
                    AbstractPowerManager.this.lastOn = Instant.now();
                }
            }
        }
    }
}

