/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.LightManager;
import jmri.SystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLightManager
extends AbstractManager<Light>
implements LightManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractLightManager.class);

    public AbstractLightManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 30;
    }

    @Override
    public char typeLetter() {
        return 'L';
    }

    @Override
    @Nonnull
    public Light provideLight(@Nonnull String name) {
        Light light = this.getLight(name);
        return light == null ? this.newLight(this.makeSystemName(name, true), null) : light;
    }

    @Override
    @CheckForNull
    public Light getLight(@Nonnull String name) {
        Light result = (Light)this.getByUserName(name);
        if (result == null) {
            result = (Light)this.getBySystemName(name);
        }
        return result;
    }

    @Override
    @Nonnull
    public Light newLight(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        Light l;
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        log.debug("newLight: {};{}", (Object)systemName, (Object)userName);
        systemName = this.validateSystemNameFormat(systemName);
        if (userName != null && (l = (Light)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != l) {
                log.error("inconsistent user '{}' and system name '{}' results; user name related to {}", new Object[]{userName, systemName, l.getSystemName()});
            }
            return l;
        }
        l = (Light)this.getBySystemName(systemName);
        if (l != null) {
            if (l.getUserName() == null && userName != null) {
                l.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found light via system name '{}' with non-null user name '{}'", (Object)systemName, (Object)userName);
            }
            return l;
        }
        l = this.createNewLight(systemName, userName);
        this.register(l);
        return l;
    }

    @Nonnull
    protected abstract Light createNewLight(@Nonnull String var1, String var2) throws IllegalArgumentException;

    @Override
    public void activateAllLights() {
        for (Light l : this.getNamedBeanSet()) {
            log.debug("Activated Light system name is {}", (Object)l.getSystemName());
            l.activateLight();
        }
    }

    @Override
    @Nonnull
    public String convertSystemNameToAlternate(@Nonnull String systemName) {
        return "";
    }

    @Override
    public boolean supportsVariableLights(@Nonnull String systemName) {
        return false;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameLights" : "BeanNameLight");
    }

    @Override
    public Class<Light> getNamedBeanClass() {
        return Light.class;
    }

    @Override
    @CheckForNull
    public String getEntryToolTip() {
        return Bundle.getMessage("EnterNumber1to9999ToolTip");
    }
}

