/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import jmri.Block;
import jmri.BlockManager;
import jmri.CabSignal;
import jmri.CabSignalListListener;
import jmri.CabSignalManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCabSignalManager
implements CabSignalManager {
    protected HashMap<LocoAddress, CabSignal> signalList = new HashMap();
    protected ArrayList<CabSignalListListener> listListeners = new ArrayList();
    private ArrayList<PropertyChangeListener> mBlockListeners = new ArrayList();
    private boolean blockInit = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractCabSignalManager.class);

    @Override
    public CabSignal getCabSignal(LocoAddress address) {
        if (!this.blockInit) {
            this.initBlocks();
        }
        if (!this.signalList.containsKey(address)) {
            this.signalList.put(address, this.createCabSignal(address));
            this.notifyCabSignalListChanged();
        }
        return this.signalList.get(address);
    }

    protected abstract CabSignal createCabSignal(LocoAddress var1);

    @Override
    public void delCabSignal(LocoAddress address) {
        if (this.signalList.containsKey(address)) {
            this.signalList.remove(address);
            this.notifyCabSignalListChanged();
        }
    }

    @Override
    public Set getCabSignalList() {
        return this.signalList.keySet();
    }

    @Override
    public CabSignal[] getCabSignalArray() {
        return this.signalList.values().toArray(new CabSignal[1]);
    }

    @Override
    public void addCabSignalListListener(CabSignalListListener listener) {
        if (!this.listListeners.contains(listener)) {
            this.listListeners.add(listener);
        }
    }

    @Override
    public void removeCabSignalListListener(CabSignalListListener listener) {
        if (this.listListeners.contains(listener)) {
            this.listListeners.remove(listener);
        }
    }

    @Override
    public void notifyCabSignalListChanged() {
        for (CabSignalListListener l : this.listListeners) {
            l.notifyCabSignalListChanged();
        }
    }

    private void initBlocks() {
        this.blockInit = true;
        BlockManager bmgr = InstanceManager.getDefault(BlockManager.class);
        SortedSet blockSet = bmgr.getNamedBeanSet();
        for (Block b : blockSet) {
            PropertyChangeListener listener = e -> this.handleBlockChange(e);
            b.addPropertyChangeListener(listener);
            this.mBlockListeners.add(listener);
        }
    }

    private void handleBlockChange(PropertyChangeEvent e) {
        log.debug("property {} new value {} old value {}", new Object[]{e.getPropertyName(), e.getNewValue(), e.getOldValue()});
        if (e.getPropertyName().equals("value") && e.getOldValue() == null && e.getNewValue() != null) {
            for (CabSignal c : this.signalList.values()) {
                if (c.getBlock() != null) continue;
                c.setBlock();
            }
        }
    }
}

