/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo.swing.monitor;

import java.util.Date;
import javax.swing.JCheckBox;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.zimo.Mx1Listener;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.swing.Mx1NamedPaneAction;
import jmri.jmrix.zimo.swing.Mx1PanelInterface;
import jmri.util.StringUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1MonPanel
extends AbstractMonPane
implements Mx1Listener,
Mx1PanelInterface {
    Mx1SystemConnectionMemo memo;
    JCheckBox includePoll = new JCheckBox("Include Poll Messages");
    Date previousTimeStamp;
    private static final Logger log = LoggerFactory.getLogger(Mx1MonPanel.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.zimo.swing.monitor.Mx1MonPanel";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("Mx1_");
        }
        x.append(": ");
        x.append("Command Monitor");
        return x.toString();
    }

    @Override
    public void dispose() {
        if (this.memo.getMx1TrafficController() != null) {
            this.memo.getMx1TrafficController().removeMx1Listener(-1, this);
        }
        super.dispose();
    }

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof Mx1SystemConnectionMemo) {
            this.initComponents((Mx1SystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(Mx1SystemConnectionMemo memo) {
        this.memo = memo;
        if (memo.getMx1TrafficController() == null) {
            log.error("No traffic controller is available");
            return;
        }
        memo.getMx1TrafficController().addMx1Listener(-1, this);
    }

    public synchronized void notifyXmit(Date timestamp, Mx1Message m) {
        this.logMessage(timestamp, m, "Tx:");
    }

    public synchronized void notifyFailedXmit(Date timestamp, Mx1Message m) {
        this.logMessage(timestamp, m, "FAILED:");
    }

    public synchronized void notifyRcv(Date timestamp, Mx1Message m) {
        String prefix = "Rx:";
        this.logMessage(timestamp, m, prefix);
    }

    @Override
    public synchronized void message(Mx1Message l) {
        StringBuilder raw = new StringBuilder("packet: ");
        if (this.rawCheckBox.isSelected()) {
            int len = l.getNumDataElements();
            int i = 0;
            while (i < len) {
                raw.append(Integer.toHexString(l.getElement(i))).append(" ");
                ++i;
            }
        }
        this.nextLine(String.valueOf(l.getStringMsg()) + "\n", raw.toString());
    }

    private void logMessage(Date timestamp, Mx1Message m, String src) {
        StringBuilder raw = new StringBuilder("");
        int i = 0;
        while (i < m.getNumDataElements()) {
            if (i > 0) {
                raw.append(" ");
            }
            raw.append(StringUtil.twoHexFromInt(m.getElement(i) & 0xFF));
            ++i;
        }
        this.nextLineWithTime(timestamp, String.valueOf(src) + " " + m.toString() + "\n", raw.toString());
    }

    @Deprecated
    public static class Default
    extends Mx1NamedPaneAction {
        public Default() {
            super("Mx1 Command Monitor", new JmriJFrameInterface(), Mx1MonPanel.class.getName(), InstanceManager.getDefault(Mx1SystemConnectionMemo.class));
        }
    }
}

