/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo.mx1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.zimo.Mx1CommandStation;
import jmri.jmrix.zimo.Mx1Packetizer;
import jmri.jmrix.zimo.Mx1PortController;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.mx1.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class Mx1Adapter
extends Mx1PortController {
    SerialPort activeSerialPort = null;
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud1200"), Bundle.getMessage("Baud2400"), Bundle.getMessage("Baud4800"), Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400")};
    protected int[] validSpeedValues = new int[]{1200, 2400, 4800, 9600, 19200, 38400};
    protected String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionHwRecomm"), Bundle.getMessage("FlowOptionNo")};
    protected String[] validOption2 = new String[]{"3", "5"};
    InputStream serialStream = null;
    static Mx1Adapter mInstance = null;
    private static final Logger log = LoggerFactory.getLogger(Mx1Adapter.class);

    public Mx1Adapter() {
        super(new Mx1SystemConnectionMemo());
        this.option1Name = "FlowControl";
        this.options.put(this.option1Name, new AbstractPortController.Option("MX-1 connection uses : ", this.validOption1));
        this.manufacturerName = "Zimo";
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.setSerialPort();
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud with DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            if (log.isDebugEnabled()) {
                log.debug(" port flow control shows {}", (Object)(this.activeSerialPort.getFlowControlMode() == 2 ? "hardware flow control" : "no flow control"));
                this.setPortEventLogging(this.activeSerialPort);
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {} trace follows: ", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public boolean okToSend() {
        return this.activeSerialPort.isCTS();
    }

    @Override
    public void configure() {
        Mx1CommandStation cs = new Mx1CommandStation(this.getSystemConnectionMemo().getSystemPrefix(), this.getSystemConnectionMemo().getUserName());
        Mx1Packetizer packets = new Mx1Packetizer(cs, false);
        packets.connectPort(this);
        this.getSystemConnectionMemo().setMx1TrafficController(packets);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setSerialPort() throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 2;
        if (this.getOptionState(this.option1Name).equals(this.validOption1[1])) {
            flow = 0;
        }
        this.configureLeadsAndFlowControl(this.activeSerialPort, flow);
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Deprecated
    public static Mx1Adapter instance() {
        if (mInstance == null) {
            mInstance = new Mx1Adapter();
        }
        return mInstance;
    }
}

