/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import javax.annotation.Nonnull;
import jmri.Turnout;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.Mx1Turnout;
import jmri.managers.AbstractTurnoutManager;

public class Mx1TurnoutManager
extends AbstractTurnoutManager {
    public Mx1TurnoutManager(Mx1SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public Mx1SystemConnectionMemo getMemo() {
        return (Mx1SystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        Mx1Turnout t = new Mx1Turnout(addr, this.getMemo().getMx1TrafficController(), this.getSystemPrefix());
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }
}

