/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import java.util.Vector;
import jmri.jmrix.zimo.Mx1CommandStation;
import jmri.jmrix.zimo.Mx1Interface;
import jmri.jmrix.zimo.Mx1Listener;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Mx1TrafficController
implements Mx1Interface {
    public static final boolean ASCII = false;
    public static final boolean BINARY = true;
    boolean protocol = false;
    protected Vector<Mx1Listener> listeners = new Vector();
    Mx1CommandStation mCommandStation;
    Mx1SystemConnectionMemo adaptermemo;
    private static final Logger log = LoggerFactory.getLogger(Mx1TrafficController.class);

    public Mx1TrafficController() {
    }

    Mx1TrafficController(Mx1CommandStation pCommandStation, boolean prot) {
        this.mCommandStation = pCommandStation;
        this.protocol = prot;
    }

    public boolean getProtocol() {
        return this.protocol;
    }

    @Override
    public abstract boolean status();

    @Override
    public abstract void sendMx1Message(Mx1Message var1, Mx1Listener var2);

    @Override
    public synchronized void addMx1Listener(int mask, Mx1Listener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    @Override
    public synchronized void removeMx1Listener(int mask, Mx1Listener l) {
        if (this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(Mx1Message m, Mx1Listener replyTo) {
        Vector v;
        Mx1TrafficController mx1TrafficController = this;
        synchronized (mx1TrafficController) {
            v = (Vector)this.listeners.clone();
        }
        if (log.isDebugEnabled()) {
            log.debug("notify of incoming packet: {}", (Object)m.toString());
        }
        int cnt = v.size();
        int i = 0;
        while (i < cnt) {
            Mx1Listener client = this.listeners.elementAt(i);
            if (client != replyTo) {
                client.message(m);
            }
            ++i;
        }
    }

    public Mx1CommandStation getCommandStation() {
        return this.mCommandStation;
    }

    public Mx1SystemConnectionMemo getAdapterMemo() {
        return this.adaptermemo;
    }

    public void setAdapterMemo(Mx1SystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    public String getUserName() {
        if (this.adaptermemo == null) {
            return "Zimo";
        }
        return this.adaptermemo.getUserName();
    }

    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "Z";
        }
        return this.adaptermemo.getSystemPrefix();
    }
}

