/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.zimo.Mx1Listener;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.Mx1TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1Throttle
extends AbstractThrottle
implements Mx1Listener {
    private Mx1TrafficController tc = null;
    DccLocoAddress address;
    int addressLo = 0;
    int addressHi = 0;
    private static final Logger log = LoggerFactory.getLogger(Mx1Throttle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mx1Throttle(Mx1SystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.tc = memo.getMx1TrafficController();
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        Mx1Throttle mx1Throttle = this;
        synchronized (mx1Throttle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        if (address.isLongAddress()) {
            this.addressLo = address.getNumber();
            this.addressHi = address.getNumber() >> 8;
            this.addressHi += 192;
        } else {
            this.addressLo = address.getNumber();
        }
        this.tc.addMx1Listener(-1, this);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    protected void sendFunctionGroup1() {
        this.sendSpeedCmd();
    }

    @Override
    protected void sendFunctionGroup2() {
        this.sendSpeedCmd();
    }

    @Override
    protected void sendFunctionGroup3() {
        this.sendSpeedCmd();
    }

    @Override
    protected void sendFunctionGroup4() {
    }

    @Override
    protected void sendFunctionGroup5() {
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        this.speedSetting = speed;
        this.sendSpeedCmd();
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSpeedCmd() {
        int value = 0;
        int cData1 = this.isForward ? 32 : 0;
        cData1 += this.getFunction(0) ? 16 : 0;
        Mx1Throttle mx1Throttle = this;
        synchronized (mx1Throttle) {
            if (this.speedStepMode == SpeedStepMode.NMRA_DCC_128) {
                value = (int)(126.0f * this.speedSetting);
                if (value > 0) {
                    ++value;
                }
                if (value > 127) {
                    value = 127;
                }
                if (value < 0) {
                    value = 1;
                }
                value &= 0x7F;
                cData1 += 12;
            } else if (this.speedStepMode == SpeedStepMode.NMRA_DCC_28) {
                value = (int)(28.0f * this.speedSetting);
                if (value > 0) {
                    value += 3;
                }
                if (value > 32) {
                    value = 31;
                }
                if (value < 0) {
                    value = 2;
                }
                int speedC = (value & 0x1F) >> 1;
                int c = (value & 1) << 4;
                value = (this.isForward ? 96 : 64) | (speedC += c);
                cData1 += 8;
            }
        }
        Mx1Message m = Mx1Message.getLocoControl(this.address.getNumber(), value, true, cData1, this.getFunction1to8(), this.getFunction9to12());
        this.tc.sendMx1Message(m, this);
    }

    int getFunction1to8() {
        int data = (this.getFunction(1) ? 1 : 0) | (this.getFunction(2) ? 2 : 0) | (this.getFunction(3) ? 4 : 0) | (this.getFunction(4) ? 8 : 0) | (this.getFunction(5) ? 16 : 0) | (this.getFunction(6) ? 32 : 0) | (this.getFunction(7) ? 64 : 0) | (this.getFunction(8) ? 128 : 0);
        return data;
    }

    int getFunction9to12() {
        int data = (this.getFunction(9) ? 1 : 0) | (this.getFunction(10) ? 2 : 0) | (this.getFunction(11) ? 4 : 0) | (this.getFunction(12) ? 8 : 0);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        Mx1Throttle mx1Throttle = this;
        synchronized (mx1Throttle) {
            this.setSpeedSetting(this.speedSetting);
        }
        log.debug("setIsForward= {}", (Object)forward);
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }

    @Override
    public void message(Mx1Message m) {
    }
}

