/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.swing.ComponentFactory;
import jmri.jmrix.zimo.Mx1CommandStation;
import jmri.jmrix.zimo.Mx1PowerManager;
import jmri.jmrix.zimo.Mx1Programmer;
import jmri.jmrix.zimo.Mx1ProgrammerManager;
import jmri.jmrix.zimo.Mx1ThrottleManager;
import jmri.jmrix.zimo.Mx1TrafficController;
import jmri.jmrix.zimo.Mx1TurnoutManager;
import jmri.jmrix.zimo.swing.Mx1ComponentFactory;
import jmri.managers.DefaultProgrammerManager;
import jmri.util.NamedBeanComparator;

public class Mx1SystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    ComponentFactory componentFactory = null;
    public static final int MX1 = 0;
    public static final int MXULF = 1;
    public static final int MX10 = 2;
    int connectionType = 0;
    private Mx1TrafficController st;

    public Mx1SystemConnectionMemo(Mx1TrafficController st) {
        super("Z", "MX-1");
        this.st = st;
        InstanceManager.store(this, Mx1SystemConnectionMemo.class);
        this.componentFactory = new Mx1ComponentFactory(this);
        InstanceManager.store(this.componentFactory, ComponentFactory.class);
    }

    public Mx1SystemConnectionMemo() {
        super("Z", "MX-1");
        InstanceManager.store(this, Mx1SystemConnectionMemo.class);
        this.componentFactory = new Mx1ComponentFactory(this);
        InstanceManager.store(this.componentFactory, ComponentFactory.class);
    }

    public void setConnectionType(int connection) {
        this.connectionType = connection;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public Mx1TrafficController getMx1TrafficController() {
        return this.st;
    }

    public void setMx1TrafficController(Mx1TrafficController st) {
        this.st = st;
    }

    @Deprecated
    public void configureCommandStation() {
    }

    @Override
    public void configureManagers() {
        DefaultProgrammerManager programmerManager = this.getProgrammerManager();
        this.store(programmerManager, DefaultProgrammerManager.class);
        if (programmerManager.isAddressedModePossible()) {
            this.store(programmerManager, AddressedProgrammerManager.class);
            InstanceManager.store(programmerManager, AddressedProgrammerManager.class);
        }
        if (programmerManager.isGlobalProgrammerAvailable()) {
            this.store(programmerManager, GlobalProgrammerManager.class);
            InstanceManager.store(programmerManager, GlobalProgrammerManager.class);
        }
        Mx1PowerManager powerManager = new Mx1PowerManager(this);
        this.store(powerManager, PowerManager.class);
        InstanceManager.store(powerManager, PowerManager.class);
        Mx1ThrottleManager throttleManager = new Mx1ThrottleManager(this);
        this.store(throttleManager, ThrottleManager.class);
        InstanceManager.setThrottleManager(throttleManager);
        if (this.getProtocol()) {
            Mx1TurnoutManager turnoutManager = new Mx1TurnoutManager(this);
            this.store(turnoutManager, TurnoutManager.class);
            InstanceManager.setTurnoutManager(turnoutManager);
        }
        this.register();
    }

    boolean getProtocol() {
        if (this.getMx1TrafficController() != null) {
            return this.getMx1TrafficController().getProtocol();
        }
        return false;
    }

    public DefaultProgrammerManager getProgrammerManager() {
        return (DefaultProgrammerManager)this.classObjectMap.computeIfAbsent(DefaultProgrammerManager.class, c -> this.generateDefaultProgrammerManagerForConnection());
    }

    private DefaultProgrammerManager generateDefaultProgrammerManagerForConnection() {
        DefaultProgrammerManager programmerManager = this.getProtocol() ? new Mx1ProgrammerManager((Programmer)new Mx1Programmer(this.getMx1TrafficController()), this) : new DefaultProgrammerManager(new Mx1Programmer(this.getMx1TrafficController()), this);
        return programmerManager;
    }

    public void setProgrammerManager(DefaultProgrammerManager p) {
        this.store(p, DefaultProgrammerManager.class);
    }

    public Mx1TurnoutManager getTurnoutManager() {
        return (Mx1TurnoutManager)this.classObjectMap.get(TurnoutManager.class);
    }

    @Deprecated
    public void setCommandStation(Mx1CommandStation cs) {
    }

    public Mx1PowerManager getPowerManager() {
        return (Mx1PowerManager)this.classObjectMap.get(PowerManager.class);
    }

    public Mx1ThrottleManager getThrottleManager() {
        return (Mx1ThrottleManager)this.classObjectMap.get(ThrottleManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.zimo.ZimoActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        Mx1ThrottleManager throttleManager;
        this.st = null;
        InstanceManager.deregister(this, Mx1SystemConnectionMemo.class);
        if (this.componentFactory != null) {
            InstanceManager.deregister(this.componentFactory, ComponentFactory.class);
        }
        if ((throttleManager = (Mx1ThrottleManager)this.classObjectMap.get(ThrottleManager.class)) != null) {
            this.deregister(throttleManager, ThrottleManager.class);
            InstanceManager.deregister(throttleManager, Mx1ThrottleManager.class);
        }
        super.dispose();
    }
}

