/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import jmri.jmrix.zimo.Mx1CommandStation;
import jmri.jmrix.zimo.Mx1Listener;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1PortController;
import jmri.jmrix.zimo.Mx1TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1Packetizer
extends Mx1TrafficController {
    public static final boolean ASCII = false;
    public static final boolean BINARY = true;
    boolean protocol = false;
    LinkedList<byte[]> xmtList = new LinkedList();
    ConcurrentHashMap<Integer, MessageQueued> xmtPackets = new ConcurrentHashMap(16, 0.9f, 1);
    XmtHandler xmtHandler = new XmtHandler();
    RetryHandler retryHandler = new RetryHandler(this);
    RcvHandler rcvHandler = new RcvHandler(this);
    private Mx1PortController controller = null;
    DataInputStream istream = null;
    OutputStream ostream = null;
    private byte[] rcvBuffer = new byte[1];
    byte lastSequence = 0;
    static final int SOH = 1;
    static final int EOT = 23;
    static final int DLE = 16;
    final int[] crc8bit_table;
    private static final Logger log = LoggerFactory.getLogger(Mx1Packetizer.class);

    public Mx1Packetizer(Mx1CommandStation pCommandStation, boolean prot) {
        super(pCommandStation, prot);
        int[] nArray = new int[256];
        nArray[1] = 94;
        nArray[2] = 188;
        nArray[3] = 226;
        nArray[4] = 97;
        nArray[5] = 63;
        nArray[6] = 221;
        nArray[7] = 131;
        nArray[8] = 194;
        nArray[9] = 156;
        nArray[10] = 126;
        nArray[11] = 32;
        nArray[12] = 163;
        nArray[13] = 253;
        nArray[14] = 31;
        nArray[15] = 65;
        nArray[16] = 157;
        nArray[17] = 195;
        nArray[18] = 33;
        nArray[19] = 127;
        nArray[20] = 252;
        nArray[21] = 162;
        nArray[22] = 64;
        nArray[23] = 30;
        nArray[24] = 95;
        nArray[25] = 1;
        nArray[26] = 227;
        nArray[27] = 189;
        nArray[28] = 62;
        nArray[29] = 96;
        nArray[30] = 130;
        nArray[31] = 220;
        nArray[32] = 35;
        nArray[33] = 125;
        nArray[34] = 159;
        nArray[35] = 193;
        nArray[36] = 66;
        nArray[37] = 28;
        nArray[38] = 254;
        nArray[39] = 160;
        nArray[40] = 225;
        nArray[41] = 191;
        nArray[42] = 93;
        nArray[43] = 3;
        nArray[44] = 128;
        nArray[45] = 222;
        nArray[46] = 60;
        nArray[47] = 98;
        nArray[48] = 190;
        nArray[49] = 224;
        nArray[50] = 2;
        nArray[51] = 92;
        nArray[52] = 223;
        nArray[53] = 129;
        nArray[54] = 99;
        nArray[55] = 61;
        nArray[56] = 124;
        nArray[57] = 34;
        nArray[58] = 192;
        nArray[59] = 158;
        nArray[60] = 29;
        nArray[61] = 67;
        nArray[62] = 161;
        nArray[63] = 255;
        nArray[64] = 70;
        nArray[65] = 24;
        nArray[66] = 250;
        nArray[67] = 164;
        nArray[68] = 39;
        nArray[69] = 121;
        nArray[70] = 155;
        nArray[71] = 197;
        nArray[72] = 132;
        nArray[73] = 218;
        nArray[74] = 56;
        nArray[75] = 102;
        nArray[76] = 229;
        nArray[77] = 187;
        nArray[78] = 89;
        nArray[79] = 7;
        nArray[80] = 219;
        nArray[81] = 133;
        nArray[82] = 103;
        nArray[83] = 57;
        nArray[84] = 186;
        nArray[85] = 228;
        nArray[86] = 6;
        nArray[87] = 88;
        nArray[88] = 25;
        nArray[89] = 71;
        nArray[90] = 165;
        nArray[91] = 251;
        nArray[92] = 120;
        nArray[93] = 38;
        nArray[94] = 196;
        nArray[95] = 154;
        nArray[96] = 101;
        nArray[97] = 59;
        nArray[98] = 217;
        nArray[99] = 135;
        nArray[100] = 4;
        nArray[101] = 90;
        nArray[102] = 184;
        nArray[103] = 230;
        nArray[104] = 167;
        nArray[105] = 249;
        nArray[106] = 27;
        nArray[107] = 69;
        nArray[108] = 198;
        nArray[109] = 152;
        nArray[110] = 122;
        nArray[111] = 36;
        nArray[112] = 248;
        nArray[113] = 166;
        nArray[114] = 68;
        nArray[115] = 26;
        nArray[116] = 153;
        nArray[117] = 199;
        nArray[118] = 37;
        nArray[119] = 123;
        nArray[120] = 58;
        nArray[121] = 100;
        nArray[122] = 134;
        nArray[123] = 216;
        nArray[124] = 91;
        nArray[125] = 5;
        nArray[126] = 231;
        nArray[127] = 185;
        nArray[128] = 140;
        nArray[129] = 210;
        nArray[130] = 48;
        nArray[131] = 110;
        nArray[132] = 237;
        nArray[133] = 179;
        nArray[134] = 81;
        nArray[135] = 15;
        nArray[136] = 78;
        nArray[137] = 16;
        nArray[138] = 242;
        nArray[139] = 172;
        nArray[140] = 47;
        nArray[141] = 113;
        nArray[142] = 147;
        nArray[143] = 205;
        nArray[144] = 17;
        nArray[145] = 79;
        nArray[146] = 173;
        nArray[147] = 243;
        nArray[148] = 112;
        nArray[149] = 46;
        nArray[150] = 204;
        nArray[151] = 146;
        nArray[152] = 211;
        nArray[153] = 141;
        nArray[154] = 111;
        nArray[155] = 49;
        nArray[156] = 178;
        nArray[157] = 236;
        nArray[158] = 14;
        nArray[159] = 80;
        nArray[160] = 175;
        nArray[161] = 241;
        nArray[162] = 19;
        nArray[163] = 77;
        nArray[164] = 206;
        nArray[165] = 144;
        nArray[166] = 114;
        nArray[167] = 44;
        nArray[168] = 109;
        nArray[169] = 51;
        nArray[170] = 209;
        nArray[171] = 143;
        nArray[172] = 12;
        nArray[173] = 82;
        nArray[174] = 176;
        nArray[175] = 238;
        nArray[176] = 50;
        nArray[177] = 108;
        nArray[178] = 142;
        nArray[179] = 208;
        nArray[180] = 83;
        nArray[181] = 13;
        nArray[182] = 239;
        nArray[183] = 177;
        nArray[184] = 240;
        nArray[185] = 174;
        nArray[186] = 76;
        nArray[187] = 18;
        nArray[188] = 145;
        nArray[189] = 207;
        nArray[190] = 45;
        nArray[191] = 115;
        nArray[192] = 202;
        nArray[193] = 148;
        nArray[194] = 118;
        nArray[195] = 40;
        nArray[196] = 171;
        nArray[197] = 245;
        nArray[198] = 23;
        nArray[199] = 73;
        nArray[200] = 8;
        nArray[201] = 86;
        nArray[202] = 180;
        nArray[203] = 234;
        nArray[204] = 105;
        nArray[205] = 55;
        nArray[206] = 213;
        nArray[207] = 139;
        nArray[208] = 87;
        nArray[209] = 9;
        nArray[210] = 235;
        nArray[211] = 181;
        nArray[212] = 54;
        nArray[213] = 104;
        nArray[214] = 138;
        nArray[215] = 212;
        nArray[216] = 149;
        nArray[217] = 203;
        nArray[218] = 41;
        nArray[219] = 119;
        nArray[220] = 244;
        nArray[221] = 170;
        nArray[222] = 72;
        nArray[223] = 22;
        nArray[224] = 233;
        nArray[225] = 183;
        nArray[226] = 85;
        nArray[227] = 11;
        nArray[228] = 136;
        nArray[229] = 214;
        nArray[230] = 52;
        nArray[231] = 106;
        nArray[232] = 43;
        nArray[233] = 117;
        nArray[234] = 151;
        nArray[235] = 201;
        nArray[236] = 74;
        nArray[237] = 20;
        nArray[238] = 246;
        nArray[239] = 168;
        nArray[240] = 116;
        nArray[241] = 42;
        nArray[242] = 200;
        nArray[243] = 150;
        nArray[244] = 21;
        nArray[245] = 75;
        nArray[246] = 169;
        nArray[247] = 247;
        nArray[248] = 182;
        nArray[249] = 232;
        nArray[250] = 10;
        nArray[251] = 84;
        nArray[252] = 215;
        nArray[253] = 137;
        nArray[254] = 107;
        nArray[255] = 53;
        this.crc8bit_table = nArray;
        this.protocol = prot;
    }

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMx1Message(Mx1Message m, Mx1Listener reply) {
        byte[] msg;
        if (this.protocol) {
            this.processPacketForSending(m);
            msg = m.getRawPacket();
            if (m.replyL1Expected()) {
                this.xmtPackets.put(m.getSequenceNo(), new MessageQueued(m, reply));
            }
        } else {
            int len = m.getNumDataElements();
            m.setElement(len - 1, 13);
            msg = new byte[len];
            int i = 0;
            while (i < len) {
                msg[i] = (byte)m.getElement(i);
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug("queue outgoing packet: {}", (Object)m.toString());
            }
        }
        this.notifyLater(m, reply);
        XmtHandler xmtHandler = this.xmtHandler;
        synchronized (xmtHandler) {
            this.xmtList.addLast(msg);
            this.xmtHandler.notify();
        }
    }

    byte getNextSequenceNo() {
        this.lastSequence = (byte)(this.lastSequence + 1);
        if ((this.lastSequence & 0xFF) == 255) {
            this.lastSequence = 0;
        }
        return this.lastSequence;
    }

    void processPacketForSending(Mx1Message m) {
        ArrayList<Byte> msgFormat = new ArrayList<Byte>();
        msgFormat.add((byte)1);
        msgFormat.add((byte)1);
        m.setSequenceNo(this.getNextSequenceNo());
        int i = 0;
        while (i < m.getNumDataElements()) {
            this.formatByteToPacket((byte)m.getElement(i), msgFormat);
            ++i;
        }
        if (m.getLongMessage()) {
            int crc = this.get16BitCRC(m);
            this.formatByteToPacket((byte)(crc >>> 8 & 0xFF), msgFormat);
            this.formatByteToPacket((byte)(crc & 0xFF), msgFormat);
        } else {
            byte checksum = this.get8BitCRC(m);
            this.formatByteToPacket(checksum, msgFormat);
        }
        msgFormat.add((byte)23);
        byte[] msg = new byte[msgFormat.size()];
        int i2 = 0;
        while (i2 < msgFormat.size()) {
            msg[i2] = msgFormat.get(i2);
            ++i2;
        }
        m.setRawPacket(msg);
        m.setTimeStamp(System.currentTimeMillis());
    }

    void formatByteToPacket(byte b, ArrayList<Byte> message) {
        if ((b = (byte)(b & 0xFF)) == 1 || b == 23 || b == 16) {
            message.add((byte)16);
            message.add((byte)(b ^ 0x20));
        } else {
            message.add((byte)(b & 0xFF));
        }
    }

    public void connectPort(Mx1PortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(Mx1PortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected Mx1PortController");
        }
        this.controller = null;
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        while ((nchars = istream.read(this.rcvBuffer, 0, 1)) <= 0) {
        }
        return this.rcvBuffer[0];
    }

    void notifyLater(Mx1Message m, Mx1Listener reply) {
        Mx1Message thisMsg = m;
        Mx1Packetizer thisTc = this;
        Mx1Listener thisLst = reply;
        Runnable r = new Runnable(thisMsg, thisTc, thisLst){
            Mx1Message msgForLater;
            Mx1Packetizer myTc;
            Mx1Listener myListener;
            {
                this.msgForLater = mx1Message;
                this.myTc = mx1Packetizer2;
                this.myListener = mx1Listener;
            }

            @Override
            public void run() {
                this.myTc.notify(this.msgForLater, this.myListener);
            }
        };
        log.debug("schedule notify of incoming packet");
        SwingUtilities.invokeLater(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void isAckReplyRequired(Mx1Message m) {
        if (m.isCRCError()) {
            Mx1Message nack = new Mx1Message(3, true);
            nack.setElement(1, 16);
            nack.setElement(2, 0);
            this.processPacketForSending(nack);
            byte[] msg = nack.getRawPacket();
            this.notify(nack, null);
            XmtHandler xmtHandler = this.xmtHandler;
            synchronized (xmtHandler) {
                this.xmtList.addFirst(msg);
                this.xmtHandler.notify();
            }
            return;
        }
        if ((m.getElement(1) & 0x80) != 128) {
            if ((m.getElement(1) & 0x40) == 64 || (m.getElement(1) & 0x60) == 96) {
                return;
            }
            if ((m.getElement(2) & 0x13) == 19) {
                this.l1AckPacket(m);
            } else if ((m.getElement(1) & 0x20) == 32) {
                this.l2AckPacket(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void l1AckPacket(Mx1Message m) {
        Mx1Message ack = new Mx1Message(5, true);
        ack.setElement(1, 80);
        ack.setElement(2, m.getElement(2) & 0xFF);
        ack.setElement(3, m.getElement(0) & 0xFF);
        this.processPacketForSending(ack);
        byte[] msg = ack.getRawPacket();
        this.notify(ack, null);
        XmtHandler xmtHandler = this.xmtHandler;
        synchronized (xmtHandler) {
            this.xmtList.addFirst(msg);
            this.xmtHandler.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void l2AckPacket(Mx1Message m) {
        Mx1Message ack = new Mx1Message(5, true);
        ack.setElement(1, 112);
        ack.setElement(2, m.getElement(2) & 0xFF);
        ack.setElement(3, m.getElement(0) & 0xFF);
        this.processPacketForSending(ack);
        byte[] msg = ack.getRawPacket();
        this.notify(ack, null);
        XmtHandler xmtHandler = this.xmtHandler;
        synchronized (xmtHandler) {
            this.xmtList.addFirst(msg);
            this.xmtHandler.notify();
        }
    }

    public void startThreads() {
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        Thread retryThread = new Thread((Runnable)this.retryHandler, "MX1 retry handler");
        retryThread.start();
        int xmtpriority = 9 > priority ? 9 : 10;
        Thread xmtThread = new Thread((Runnable)this.xmtHandler, "MX1 transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        xmtThread.setPriority(9);
        xmtThread.start();
        Thread rcvThread = new Thread((Runnable)this.rcvHandler, "MX1 receive handler");
        rcvThread.setPriority(10);
        rcvThread.start();
    }

    public int get16BitCRC(Mx1Message m) {
        int POLYNOMIAL = 33800;
        int PRESET_VALUE = 0;
        byte[] array = new byte[m.getNumDataElements()];
        int i = 0;
        while (i < m.getNumDataElements()) {
            array[i] = (byte)m.getElement(i);
            ++i;
        }
        int current_crc_value = PRESET_VALUE;
        int i2 = 0;
        while (i2 < array.length) {
            current_crc_value ^= array[i2] & 0xFF;
            int j = 0;
            while (j < 8) {
                current_crc_value = (current_crc_value & 1) != 0 ? current_crc_value >>> 1 ^ POLYNOMIAL : (current_crc_value >>>= 1);
                ++j;
            }
            ++i2;
        }
        return current_crc_value & 0xFFFF;
    }

    byte get8BitCRC(Mx1Message m) {
        int checksum = 255;
        int i = 0;
        while (i < m.getNumDataElements()) {
            checksum = this.crc8bit_table[checksum ^ m.getElement(i) & 0xFF];
            ++i;
        }
        return (byte)(checksum & 0xFF);
    }

    static class MessageQueued {
        Mx1Message msg;
        Mx1Listener reply;

        MessageQueued(Mx1Message m, Mx1Listener r) {
            this.msg = m;
            this.reply = r;
        }

        Mx1Message getMessage() {
            return this.msg;
        }

        Mx1Listener getListener() {
            return this.reply;
        }
    }

    class RcvHandler
    implements Runnable {
        Mx1Packetizer trafficController;

        public RcvHandler(Mx1Packetizer lt) {
            this.trafficController = lt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Mx1Packetizer.this.protocol) {
                while (true) {
                    try {
                        while (true) {
                            int i;
                            Mx1Message msg;
                            int b22;
                            int firstByte = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                            int secondByte = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                            while (firstByte != 1 && secondByte != 1) {
                                log.debug("Skipping: {} {}", (Object)Integer.toHexString(firstByte), (Object)Integer.toHexString(secondByte));
                                firstByte = secondByte;
                                secondByte = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                            }
                            ArrayList<Integer> message = new ArrayList<Integer>();
                            while ((b22 = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF) != 23) {
                                if (b22 == 16) {
                                    b22 = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                                    b22 ^= 0x20;
                                }
                                message.add(b22);
                                log.debug("char is: {}", (Object)Integer.toHexString(b22));
                            }
                            RcvHandler b22 = Mx1Packetizer.this.rcvHandler;
                            synchronized (b22) {
                                Mx1Packetizer.this.xmtPackets.remove(message.get(3));
                            }
                            if (((Integer)message.get(1) & 0x80) == 128) {
                                msg = new Mx1Message(message.size() - 2, true);
                                i = 0;
                                while (i < message.size() - 2) {
                                    msg.setElement(i, (Integer)message.get(i));
                                    ++i;
                                }
                            } else {
                                msg = new Mx1Message(message.size() - 1, true);
                                i = 0;
                                while (i < message.size() - 1) {
                                    msg.setElement(i, (Integer)message.get(i));
                                    ++i;
                                }
                                if ((Integer)message.get(message.size() - 1) != (Mx1Packetizer.this.get8BitCRC(msg) & 0xFF)) {
                                    log.error("Message with invalid CRC received Expecting:{} found:{}", (Object)(Mx1Packetizer.this.get8BitCRC(msg) & 0xFF), message.get(message.size() - 1));
                                    msg.setCRCError();
                                } else {
                                    Mx1Packetizer.this.xmtPackets.remove(message.get(3));
                                }
                            }
                            Mx1Packetizer.this.isAckReplyRequired(msg);
                            Mx1Message thisMsg = msg;
                            Mx1Packetizer thisTc = this.trafficController;
                            Runnable r = new Runnable(thisMsg, thisTc){
                                Mx1Message msgForLater;
                                Mx1Packetizer myTc;
                                {
                                    this.msgForLater = mx1Message;
                                    this.myTc = mx1Packetizer;
                                }

                                @Override
                                public void run() {
                                    this.myTc.notify(this.msgForLater, null);
                                }
                            };
                            log.debug("schedule notify of incoming packet");
                            SwingUtilities.invokeLater(r);
                        }
                    }
                    catch (IOException e) {
                        log.debug("IOException, should only happen with HexFIle", (Throwable)e);
                        Mx1Packetizer.this.disconnectPort(Mx1Packetizer.this.controller);
                        return;
                    }
                    catch (RuntimeException e) {
                        log.warn("run: unexpected exception:", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    while (true) {
                        int opCode = Mx1Packetizer.this.istream.readByte() & 0xFF;
                        log.debug("RcvHandler: Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        int len = 1;
                        Mx1Message msgn = new Mx1Message(15);
                        msgn.setElement(0, opCode);
                        int i = 1;
                        while (i < 15) {
                            int b = Mx1Packetizer.this.istream.readByte() & 0xFF;
                            ++len;
                            if (b == 13 || b == 10) {
                                msgn.setElement(i, b);
                                break;
                            }
                            msgn.setElement(i, b);
                            ++i;
                        }
                        Mx1Message msg = new Mx1Message(len);
                        int i2 = 0;
                        while (i2 < len) {
                            msg.setElement(i2, msgn.getElement(i2) & 0xFF);
                            ++i2;
                        }
                        Mx1Message thisMsg = msg;
                        Mx1Packetizer thisTc = this.trafficController;
                        Runnable r = new Runnable(thisMsg, thisTc){
                            Mx1Message msgForLater;
                            Mx1Packetizer myTc;
                            {
                                this.msgForLater = mx1Message;
                                this.myTc = mx1Packetizer;
                            }

                            @Override
                            public void run() {
                                this.myTc.notify(this.msgForLater, null);
                            }
                        };
                        log.debug("schedule notify of incoming packet");
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (EOFException eOFException) {
                    log.debug("EOFException, is serial I/O using timeouts?");
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFIle: {}", (Throwable)e);
                    Mx1Packetizer.this.disconnectPort(Mx1Packetizer.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected exception: {}", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class RetryHandler
    implements Runnable {
        Mx1Packetizer trafficController;

        public RetryHandler(Mx1Packetizer lt) {
            this.trafficController = lt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="false postive, guarded by if statement")
        public void run() {
            while (true) {
                if (Mx1Packetizer.this.xmtPackets.isEmpty()) {
                    try {
                        RetryHandler retryHandler = this;
                        synchronized (retryHandler) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                Iterator iterator = ((ConcurrentHashMap.KeySetView)Mx1Packetizer.this.xmtPackets.keySet()).iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    MessageQueued mq = Mx1Packetizer.this.xmtPackets.get(key);
                    Mx1Message m = mq.getMessage();
                    if (m.getRetry() <= 0) {
                        Mx1Packetizer.this.xmtPackets.remove(key);
                        continue;
                    }
                    if (m.getTimeStamp() + 200L >= System.currentTimeMillis()) break;
                    m.setRetries(m.getRetry() - 1);
                    m.setTimeStamp(System.currentTimeMillis());
                    this.trafficController.notify(m, mq.getListener());
                    XmtHandler xmtHandler = Mx1Packetizer.this.xmtHandler;
                    synchronized (xmtHandler) {
                        log.warn("Packet not replied to so will retry");
                        Mx1Packetizer.this.xmtList.addFirst(m.getRawPacket());
                        Mx1Packetizer.this.xmtHandler.notify();
                    }
                }
                if (Mx1Packetizer.this.xmtPackets.isEmpty()) continue;
                try {
                    RetryHandler retryHandler = this;
                    synchronized (retryHandler) {
                        this.wait(200L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="while loop controls access")
    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        log.debug("check for input");
                        byte[] msg = null;
                        Runnable runnable = this;
                        synchronized (runnable) {
                            msg = Mx1Packetizer.this.xmtList.removeFirst();
                        }
                        try {
                            if (Mx1Packetizer.this.ostream != null) {
                                log.debug("start write to stream");
                                Mx1Packetizer.this.ostream.write(msg);
                                Mx1Packetizer.this.ostream.flush();
                                if (Mx1Packetizer.this.protocol) {
                                    runnable = Mx1Packetizer.this.retryHandler;
                                    synchronized (runnable) {
                                        Mx1Packetizer.this.retryHandler.notify();
                                    }
                                }
                                log.debug("end write to stream");
                                continue;
                            }
                            log.warn("send message: no connection established");
                        }
                        catch (IOException e) {
                            log.warn("send message: IOException: {}", (Object)e.toString());
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    log.debug("start wait");
                    try {
                        XmtHandler xmtHandler = this;
                        synchronized (xmtHandler) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.debug("end wait");
                    continue;
                }
                break;
            }
        }
    }
}

