/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import javax.swing.JOptionPane;
import jmri.jmrix.NetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1Message
extends NetMessage {
    boolean protocol = false;
    static final int PRIMARY = 0;
    static final int ACKREP1 = 64;
    static final int REPLY2 = 32;
    static final int ACK2 = 96;
    static final int MX1 = 0;
    static final int MX8 = 1;
    static final int MX9 = 2;
    static final boolean CS = true;
    static final boolean PC = false;
    long timeStamp = 0L;
    int retries = 3;
    byte[] rawPacket;
    boolean crcError = false;
    static final int NO_ERROR = 0;
    static final int ERR_ADDRESS = 1;
    static final int ERR_INDEX = 2;
    static final int ERR_FORWARD = 3;
    static final int ERR_BUSY = 4;
    static final int ERR_NO_MOT = 5;
    static final int ERR_NO_DCC = 6;
    static final int ERR_CV_ADDRESS = 7;
    static final int ERR_SECTION = 8;
    static final int ERR_NO_MODUL = 9;
    static final int ERR_MESSAGE = 10;
    static final int ERR_SPEED = 11;
    static final int TRACKCTL = 2;
    static final int PROGCMD = 19;
    static final int LOCOCMD = 3;
    static final int ACCCMD = 7;
    private static final Logger log = LoggerFactory.getLogger(Mx1Message.class);

    public Mx1Message(int len) {
        this(len, false);
    }

    public Mx1Message(int len, boolean protocol) {
        super(len);
        this.protocol = protocol;
        if (!(protocol || len <= 15 && len >= 0)) {
            log.error("Invalid length in ctor: {}", (Object)len);
        }
    }

    public Mx1Message(Integer[] contents) {
        super(contents.length);
        this.protocol = true;
        int i = 0;
        while (i < contents.length) {
            this.setElement(i, contents[i]);
            ++i;
        }
    }

    public Mx1Message(byte[] contents) {
        super(contents.length);
        this.protocol = true;
        int i = 0;
        while (i < contents.length) {
            this.setElement(i, contents[i] & 0xFF);
            ++i;
        }
    }

    public boolean getLongMessage() {
        return this.protocol && (this.getElement(1) & 0x80) == 128;
    }

    public int getModule() {
        int mod = this.getElement(1) & 0xF;
        if ((mod & 3) == 0) {
            return 0;
        }
        if ((mod & 3) == 1) {
            return 1;
        }
        if ((mod & 3) == 2) {
            return 2;
        }
        return mod;
    }

    public int getMessageType() {
        return this.getElement(1) & 0x60;
    }

    public int getPrimaryMessage() {
        return this.getElement(2);
    }

    public boolean messageSource() {
        return (this.getElement(0) & 8) != 8;
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    protected void setTimeStamp(long ts) {
        this.timeStamp = ts;
    }

    public int getRetry() {
        return this.retries;
    }

    public void setRetries(int i) {
        this.retries = i;
    }

    public boolean replyL1Expected() {
        return true;
    }

    public void setRawPacket(byte[] b) {
        this.rawPacket = b;
    }

    protected byte[] getRawPacket() {
        return this.rawPacket;
    }

    public void setSequenceNo(byte s) {
        this.setElement(0, s & 0xFF);
    }

    public int getSequenceNo() {
        return this.getElement(0) & 0xFF;
    }

    public void setCRCError() {
        this.crcError = true;
    }

    public boolean isCRCError() {
        return this.crcError;
    }

    @Override
    public boolean checkParity() {
        int len = this.getNumDataElements();
        return this.getElement(len - 1) == 15;
    }

    @Override
    public void setParity() {
        JOptionPane.showMessageDialog(null, "B-Programma komt tot hier!");
        int len = this.getNumDataElements();
        this.setElement(len - 1, 13);
    }

    public String getStringMsg() {
        StringBuilder txt;
        block48: {
            block49: {
                txt = new StringBuilder();
                if (!this.protocol) break block48;
                if (this.isCRCError()) {
                    txt.append(" === CRC ERROR === ");
                }
                if (this.getNumDataElements() <= 3) {
                    txt.append("Short Packet ");
                    return txt.toString();
                }
                if ((this.getElement(1) & 0x10) == 16) {
                    txt.append("From PC");
                } else {
                    txt.append("From CS");
                }
                txt.append(" Seq ").append(this.getElement(0) & 0xFF);
                if (this.getLongMessage()) {
                    txt.append(" (L)");
                } else {
                    txt.append(" (S)");
                }
                switch (this.getMessageType()) {
                    case 0: {
                        txt.append(" Prim");
                        break;
                    }
                    case 64: {
                        txt.append(" Ack/Reply 1");
                        break;
                    }
                    case 32: {
                        txt.append(" Reply 2");
                        break;
                    }
                    case 96: {
                        txt.append(" Ack 2");
                        break;
                    }
                    default: {
                        txt.append(" Unknown msg");
                    }
                }
                if (this.getModule() != 0) break block49;
                txt.append(" to/from CS (MX1)");
                switch (this.getPrimaryMessage()) {
                    case 2: {
                        int offset = 0;
                        if (this.getMessageType() == 64) {
                            ++offset;
                        }
                        txt.append(" Track Control ");
                        if ((this.getElement(3 + offset) & 3) == 3) {
                            txt.append(" Query Track Status ");
                            break;
                        }
                        if ((this.getElement(3 + offset) & 1) == 1) {
                            txt.append(" Turn Track Off ");
                            break;
                        }
                        if ((this.getElement(3 + offset) & 2) == 2) {
                            txt.append(" Turn Track On ");
                            break;
                        }
                        txt.append(" Stop All Locos ");
                        break;
                    }
                    case 3: {
                        txt.append(" Loco Control : ");
                        if (this.getMessageType() == 0) {
                            txt.append(this.getLocoAddress(this.getElement(3), this.getElement(4)));
                            txt.append((this.getElement(6) & 0x20) == 32 ? " Fwd " : " Rev ");
                            txt.append((this.getElement(6) & 0x10) == 16 ? " F0: On " : " F0: Off ");
                            txt.append(this.decodeFunctionStates(this.getElement(7), this.getElement(8)));
                            break;
                        }
                        break block48;
                    }
                    case 4: {
                        txt.append(" Loco Funct ");
                        break;
                    }
                    case 5: {
                        txt.append(" Loco Acc/Dec ");
                        break;
                    }
                    case 6: {
                        txt.append(" Shuttle ");
                        break;
                    }
                    case 7: {
                        txt.append(" Accessory ");
                        if (this.getMessageType() == 0) {
                            txt.append(this.getLocoAddress(this.getElement(3), this.getElement(4)));
                            txt.append((this.getElement(5) & 4) == 4 ? " Thrown " : " Closed ");
                            break;
                        }
                        break block48;
                    }
                    case 8: {
                        txt.append(" Loco Status ");
                        break;
                    }
                    case 9: {
                        txt.append(" Acc Status ");
                        break;
                    }
                    case 10: {
                        txt.append(" Address Control ");
                        break;
                    }
                    case 11: {
                        txt.append(" CS State ");
                        break;
                    }
                    case 12: {
                        txt.append(" Read/Write CS CV ");
                        break;
                    }
                    case 13: {
                        txt.append(" CS Equip Query ");
                        break;
                    }
                    case 17: {
                        txt.append(" Tool Type ");
                        break;
                    }
                    case 19: {
                        int offset = 0;
                        if (this.getMessageType() == 64) {
                            txt.append(" Prog CV ");
                            break;
                        }
                        if (this.getMessageType() == 32) {
                            ++offset;
                        }
                        if (this.getMessageType() == 96) {
                            txt.append("Ack to CS Message");
                            break;
                        }
                        if (this.getNumDataElements() == 7 && this.getMessageType() == 64) {
                            txt.append(" Error Occured ");
                            txt.append(this.getErrorCode(this.getElement(6)));
                            txt.append(" Loco: ").append(this.getLocoAddress(this.getElement(3 + offset), this.getElement(4 + offset)));
                            break;
                        }
                        if (this.getMessageType() == 0 && this.getNumDataElements() == 8) {
                            txt.append(" Write CV ");
                        } else {
                            txt.append(" Read CV ");
                        }
                        txt.append("Loco: ").append(this.getLocoAddress(this.getElement(3 + offset), this.getElement(4 + offset)));
                        if ((this.getElement(3 + offset) & 0x80) == 128) {
                            txt.append(" DCC");
                        }
                        int cv = ((this.getElement(5 + offset) & 0xFF) << 8) + (this.getElement(6 + offset) & 0xFF);
                        txt.append(" CV: ").append(cv);
                        if (this.getNumDataElements() >= 8 + offset) {
                            txt.append(" Set To: ").append(this.getElement(7 + offset) & 0xFF);
                            break;
                        }
                        break block48;
                    }
                    case 254: {
                        txt.append(" Cur Acc Memory ");
                        break;
                    }
                    case 255: {
                        txt.append(" Cur Loco Memory ");
                        break;
                    }
                    default: {
                        txt.append(" Unknown ");
                        break;
                    }
                }
                break block48;
            }
            if ((this.getElement(1) & 1) == 1) {
                txt.append(" to/from Accessory Mod (MX8)");
            } else if ((this.getElement(1) & 2) == 2) {
                txt.append(" to/from Track Section (MX9)");
            } else {
                txt.append(" unknown");
            }
        }
        return txt.toString();
    }

    private String decodeFunctionStates(int cData2, int cData3) {
        StringBuilder txt = new StringBuilder();
        txt.append((cData2 & 1) == 1 ? " F1: On " : " F1: Off ");
        txt.append((cData2 & 2) == 2 ? " F2: On " : " F2: Off ");
        txt.append((cData2 & 4) == 4 ? " F3: On " : " F3: Off ");
        txt.append((cData2 & 8) == 8 ? " F4: On " : " F4: Off ");
        txt.append((cData2 & 0x10) == 16 ? " F5: On " : " F5: Off ");
        txt.append((cData2 & 0x20) == 32 ? " F6: On " : " F6: Off ");
        txt.append((cData2 & 0x40) == 64 ? " F7: On " : " F7: Off ");
        txt.append((cData2 & 0x80) == 128 ? " F8: On " : " F8: Off ");
        txt.append((cData3 & 1) == 1 ? " F9: On " : " F9: Off ");
        txt.append((cData3 & 2) == 2 ? " F10: On " : " F10: Off ");
        txt.append((cData3 & 4) == 4 ? " F11: On " : " F11: Off ");
        txt.append((cData3 & 8) == 8 ? " F12: On " : " F12: Off ");
        return txt.toString();
    }

    public int getLocoAddress() {
        int offset = 0;
        if (this.getMessageType() == 32) {
            ++offset;
        } else if (this.getMessageType() == 64) {
            offset = 2;
        }
        if (this.getNumDataElements() == 4 + offset) {
            return this.getLocoAddress(this.getElement(3 + offset), this.getElement(4 + offset));
        }
        return -1;
    }

    public int getCvValue() {
        int offset = 0;
        if (this.getMessageType() == 32) {
            ++offset;
        } else if (this.getMessageType() == 64) {
            offset = 2;
        }
        if (this.getNumDataElements() >= 8 + offset) {
            return this.getElement(7 + offset) & 0xFF;
        }
        return -1;
    }

    int getLocoAddress(int hi, int lo) {
        if ((hi &= 0x3F) == 0) {
            return lo;
        }
        hi = (hi & 0xFF) - 192 << 8;
        return hi += lo & 0xFF;
    }

    String getErrorCode(int i) {
        switch (i) {
            case 0: {
                return "No Error";
            }
            case 1: {
                return "Invalid Address";
            }
            case 2: {
                return "Invalid Index";
            }
            case 3: {
                return "Could not be Forwarded";
            }
            case 4: {
                return "CMD Busy";
            }
            case 5: {
                return "Motorola Jump Off";
            }
            case 6: {
                return "DCC Jump Off";
            }
            case 7: {
                return "Invalid CV";
            }
            case 8: {
                return "Invalid Section";
            }
            case 9: {
                return "No Module Found";
            }
            case 10: {
                return "Error in Message";
            }
            case 11: {
                return "Invalid Speed";
            }
        }
        return "Unknown Error";
    }

    public static Mx1Message getCmdStnDetails() {
        Mx1Message m = new Mx1Message(4);
        m.setElement(1, 16);
        m.setElement(2, 19);
        m.setElement(3, 0);
        return m;
    }

    public static Mx1Message setPowerOff() {
        Mx1Message m = new Mx1Message(4, true);
        m.setElement(1, 16);
        m.setElement(2, 2);
        m.setElement(3, 1);
        return m;
    }

    public static Mx1Message setPowerOn() {
        Mx1Message m = new Mx1Message(4, true);
        m.setElement(1, 16);
        m.setElement(2, 2);
        m.setElement(3, 2);
        return m;
    }

    public static Mx1Message getTrackStatus() {
        Mx1Message m = new Mx1Message(4, true);
        m.setElement(1, 16);
        m.setElement(2, 2);
        m.setElement(3, 3);
        return m;
    }

    public static Mx1Message getDecProgCmd(int locoAddress, int cv, int value, boolean dcc) {
        Mx1Message m = value == -1 ? new Mx1Message(7, true) : new Mx1Message(8, true);
        m.setElement(0, 0);
        m.setElement(1, 16);
        m.setElement(2, 19);
        int locoHi = locoAddress >> 8;
        locoHi = dcc ? (locoHi += 128) : (locoHi += 64);
        m.setElement(3, locoHi);
        m.setElement(4, locoAddress & 0xFF);
        m.setElement(5, cv >> 8);
        m.setElement(6, cv & 0xFF);
        if (value != -1) {
            m.setElement(7, value);
        }
        return m;
    }

    public static Mx1Message getLocoControl(int locoAddress, int speed, boolean dcc, int cData1, int cData2, int cData3) {
        Mx1Message m = new Mx1Message(9, true);
        m.setElement(0, 0);
        m.setElement(1, 16);
        m.setElement(2, 3);
        int locoHi = locoAddress >> 8;
        locoHi = dcc ? (locoHi += 128) : (locoHi += 64);
        m.setElement(3, locoHi);
        m.setElement(4, locoAddress & 0xFF);
        m.setElement(5, speed);
        m.setElement(6, cData1);
        m.setElement(7, cData2);
        m.setElement(8, cData3);
        return m;
    }

    public static Mx1Message getSwitchMsg(int accAddress, int setting, boolean dcc) {
        Mx1Message m = new Mx1Message(6, true);
        m.setElement(0, 0);
        m.setElement(1, 16);
        m.setElement(2, 7);
        int accHi = accAddress >> 8;
        accHi = dcc ? (accHi += 128) : (accHi += 64);
        m.setElement(3, accHi);
        m.setElement(4, accAddress & 0xFF);
        m.setElement(5, 0);
        if (setting == 4) {
            m.setElement(5, 4);
        }
        return m;
    }
}

