/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa.swing.xpaconfig;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.jmrix.xpa.XpaListener;
import jmri.jmrix.xpa.XpaMessage;
import jmri.jmrix.xpa.XpaSystemConnectionMemo;
import jmri.jmrix.xpa.swing.xpaconfig.Bundle;
import jmri.util.JmriJFrame;

public class XpaConfigureFrame
extends JmriJFrame
implements XpaListener {
    final XpaSystemConnectionMemo memo;
    final JComboBox<String> addrBox = new JComboBox();
    final JButton setAddr = new JButton();
    final JRadioButton zeroEmergencyOff = new JRadioButton();
    final JRadioButton zeroEmergencyStop = new JRadioButton();
    final JButton setZero = new JButton();
    final JComboBox<String> functionBox = new JComboBox();
    final JButton setFunction = new JButton();
    protected final String[] validTimes = new String[]{"0.2s", "0.4s", "0.6s", "0.8s", "1.0s", "1.2s", "1.4s", "1.6s", "1.8s", "2.0s"};
    protected final int[] validTimeValues = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60};
    protected final String[] validXNetAddresses = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    final JButton xpaReset = new JButton();

    public XpaConfigureFrame(XpaSystemConnectionMemo m) {
        this.setTitle(Bundle.getMessage("MenuItemXpaConfigTool"));
        this.memo = m;
    }

    @Override
    public void initComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane0 = new JPanel();
        pane0.setLayout(new FlowLayout());
        pane0.add(new JLabel(Bundle.getMessage("XpAddressLabel")));
        pane0.add(this.addrBox);
        pane0.add(this.setAddr);
        pane0.setAlignmentX(0.5f);
        this.getContentPane().add(pane0);
        JPanel pane1 = new JPanel();
        pane1.setLayout(new FlowLayout());
        pane1.add(new JLabel(Bundle.getMessage("ZeroButtonLabel")));
        pane1.add(this.zeroEmergencyOff);
        pane1.add(this.zeroEmergencyStop);
        pane1.add(this.setZero);
        pane1.setAlignmentX(0.5f);
        this.getContentPane().add(pane1);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        pane2.add(new JLabel(Bundle.getMessage("MomentaryDurLabel")));
        pane2.add(this.functionBox);
        pane2.add(this.setFunction);
        pane2.setAlignmentX(0.5f);
        this.getContentPane().add(pane2);
        this.getContentPane().add(this.xpaReset);
        this.setAddr.setText(Bundle.getMessage("ButtonSetAddress"));
        this.setAddr.setVisible(true);
        this.setAddr.addActionListener(this::setAddrActionPerformed);
        this.addrBox.setVisible(true);
        this.addrBox.setToolTipText(Bundle.getMessage("SetAddressToolTip"));
        String[] stringArray = this.validXNetAddresses;
        int n = this.validXNetAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            String validXNetAddress = stringArray[n2];
            this.addrBox.addItem(validXNetAddress);
            ++n2;
        }
        this.addrBox.setSelectedIndex(0);
        this.zeroEmergencyOff.setText(Bundle.getMessage("XNetCSStatusEmergencyOff"));
        this.zeroEmergencyOff.setSelected(true);
        this.zeroEmergencyOff.addActionListener(this::zeroEmergencyOffActionPerformed);
        this.zeroEmergencyStop.setText(Bundle.getMessage("XNetCSStatusEmergencyStop"));
        this.zeroEmergencyStop.setSelected(false);
        this.zeroEmergencyStop.addActionListener(this::zeroEmergencyStopActionPerformed);
        this.setZero.setText(Bundle.getMessage("ButtonSetZero"));
        this.setZero.addActionListener(this::setZeroActionPerformed);
        this.setFunction.setText(Bundle.getMessage("ButtonSetDuration"));
        this.setFunction.setVisible(true);
        this.setFunction.addActionListener(this::setFunctionActionPerformed);
        this.functionBox.setVisible(true);
        this.functionBox.setToolTipText(Bundle.getMessage("SetDurationToolTip"));
        String[] stringArray2 = this.validTimes;
        int n3 = this.validTimes.length;
        int n4 = 0;
        while (n4 < n3) {
            String validTime = stringArray2[n4];
            this.functionBox.addItem(validTime);
            ++n4;
        }
        this.functionBox.setSelectedIndex(0);
        this.xpaReset.setText(Bundle.getMessage("ButtonReset"));
        this.xpaReset.setVisible(true);
        this.xpaReset.addActionListener(this::xpaResetActionPerformed);
        this.pack();
    }

    public void setAddrActionPerformed(ActionEvent e) {
        XpaMessage m = XpaMessage.getDeviceSettingMsg(this.addrBox.getSelectedIndex() + 1);
        this.memo.getXpaTrafficController().sendXpaMessage(m, this);
    }

    public void setFunctionActionPerformed(ActionEvent e) {
        XpaMessage m = XpaMessage.getDeviceSettingMsg(this.validTimeValues[this.functionBox.getSelectedIndex()]);
        this.memo.getXpaTrafficController().sendXpaMessage(m, this);
    }

    public void xpaResetActionPerformed(ActionEvent e) {
        XpaMessage m = XpaMessage.getDeviceSettingMsg(99);
        this.memo.getXpaTrafficController().sendXpaMessage(m, this);
    }

    public void zeroEmergencyOffActionPerformed(ActionEvent e) {
        this.zeroEmergencyOff.setSelected(true);
        this.zeroEmergencyStop.setSelected(false);
    }

    public void zeroEmergencyStopActionPerformed(ActionEvent e) {
        this.zeroEmergencyStop.setSelected(true);
        this.zeroEmergencyOff.setSelected(false);
    }

    public void setZeroActionPerformed(ActionEvent e) {
        XpaMessage m = this.zeroEmergencyOff.isSelected() ? XpaMessage.getDeviceSettingMsg(40) : XpaMessage.getDeviceSettingMsg(41);
        this.memo.getXpaTrafficController().sendXpaMessage(m, this);
    }

    @Override
    public void message(XpaMessage m) {
    }

    @Override
    public void reply(XpaMessage r) {
    }
}

