/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import jmri.jmrix.xpa.XpaInterface;
import jmri.jmrix.xpa.XpaListener;
import jmri.jmrix.xpa.XpaMessage;
import jmri.jmrix.xpa.XpaPortController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpaTrafficController
implements XpaInterface,
Runnable {
    final LinkedList<byte[]> xmtList = new LinkedList();
    final XmtHandler xmtHandler = new XmtHandler();
    Thread xmtThread = null;
    protected final ArrayList<XpaListener> cmdListeners = new ArrayList();
    XpaListener lastSender = null;
    private XpaPortController controller = null;
    DataInputStream istream = null;
    OutputStream ostream = null;
    private static final Logger log = LoggerFactory.getLogger(XpaTrafficController.class);

    public XpaTrafficController() {
        if (log.isDebugEnabled()) {
            log.debug("setting instance: {}", (Object)this);
        }
    }

    public void startTransmitThread() {
        if (this.xmtThread == null) {
            this.xmtThread = new Thread((Runnable)this.xmtHandler, "XPA transmit handler");
            this.xmtThread.setPriority(9);
            this.xmtThread.start();
        }
    }

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    @Override
    public synchronized void addXpaListener(XpaListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.cmdListeners.contains(l)) {
            this.cmdListeners.add(l);
        }
    }

    @Override
    public synchronized void removeXpaListener(XpaListener l) {
        this.cmdListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMessage(XpaMessage m, XpaListener notMe) {
        ArrayList<XpaListener> v;
        XpaTrafficController xpaTrafficController = this;
        synchronized (xpaTrafficController) {
            v = new ArrayList<XpaListener>(this.cmdListeners);
        }
        for (XpaListener client : v) {
            if (notMe == client) continue;
            if (log.isDebugEnabled()) {
                log.debug("notify client: {}", (Object)client);
            }
            try {
                client.message(m);
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {}\nException {}", (Object)client, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReply(XpaMessage r) {
        ArrayList<XpaListener> v;
        XpaTrafficController xpaTrafficController = this;
        synchronized (xpaTrafficController) {
            v = new ArrayList<XpaListener>(this.cmdListeners);
        }
        for (XpaListener client : v) {
            if (log.isDebugEnabled()) {
                log.debug("notify client: {}", (Object)client);
            }
            try {
                if (this.lastSender == client) continue;
                client.reply(r);
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {}\nException {}", (Object)client, (Object)e);
            }
        }
        if (this.lastSender != null) {
            this.lastSender.reply(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NO_NOTIFY_NOT_NOTIFYALL"}, justification="Notify is used because Having more than one thread waiting on xmtHandler is an error.")
    public synchronized void sendXpaMessage(XpaMessage m, XpaListener reply) {
        if (log.isDebugEnabled()) {
            log.debug("sendXpaMessage message: [{}]", (Object)m);
        }
        this.lastSender = reply;
        this.notifyMessage(m, reply);
        int len = m.getNumDataElements();
        int cr = 1;
        byte[] msg = new byte[len + cr];
        int i = 0;
        while (i < len) {
            msg[i] = (byte)m.getElement(i);
            ++i;
        }
        msg[len] = 13;
        XmtHandler xmtHandler = this.xmtHandler;
        synchronized (xmtHandler) {
            this.xmtList.addLast(msg);
            this.xmtHandler.notify();
        }
    }

    public void connectPort(XpaPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
        this.sendXpaMessage(XpaMessage.getDefaultInitMsg(), null);
    }

    public void disconnectPort(XpaPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected XpaPortController");
        }
        this.controller = null;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.handleOneIncomingReply();
                }
            }
            catch (IOException e) {
                log.warn("run: Exception: {}", (Object)e.toString());
                continue;
            }
            break;
        }
    }

    void handleOneIncomingReply() throws IOException {
        XpaMessage msg = new XpaMessage();
        int i = 0;
        while (i < 64) {
            byte char1 = this.istream.readByte();
            msg.setElement(i, char1);
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug("dispatch reply of length {}", (Object)i);
        }
        XpaMessage thisMsg = msg;
        XpaTrafficController thisTc = this;
        Runnable r = new Runnable(thisMsg, thisTc){
            final XpaMessage msgForLater;
            final XpaTrafficController myTc;
            {
                this.msgForLater = xpaMessage;
                this.myTc = xpaTrafficController2;
            }

            @Override
            public void run() {
                log.debug("Delayed notify starts");
                this.myTc.notifyReply(this.msgForLater);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "NO_NOTIFY_NOT_NOTIFYALL"}, justification="while loop controls access")
        public void run() {
            while (true) {
                try {
                    while (true) {
                        byte[] msg;
                        if (log.isDebugEnabled()) {
                            log.debug("check for input");
                        }
                        Object object = this;
                        synchronized (object) {
                            msg = XpaTrafficController.this.xmtList.removeFirst();
                        }
                        try {
                            if (XpaTrafficController.this.ostream != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("write message: {}", (Object)Arrays.toString(msg));
                                }
                                object = XpaTrafficController.this.ostream;
                                synchronized (object) {
                                    XpaTrafficController.this.ostream.write(msg);
                                    XpaTrafficController.this.ostream.notify();
                                    continue;
                                }
                            }
                            log.warn("sendMessage: no connection established");
                        }
                        catch (IOException e) {
                            log.warn("sendMessage: Exception: {}", (Object)e.toString());
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (log.isDebugEnabled()) {
                        log.debug("start wait");
                    }
                    try {
                        XmtHandler xmtHandler = this;
                        synchronized (xmtHandler) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("end wait");
                    continue;
                }
                break;
            }
        }
    }
}

