/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa;

import java.util.EnumSet;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.xpa.XpaSystemConnectionMemo;
import jmri.jmrix.xpa.XpaThrottle;
import jmri.jmrix.xpa.XpaTrafficController;

public class XpaThrottleManager
extends AbstractThrottleManager {
    private final XpaTrafficController tc;

    public XpaThrottleManager(XpaSystemConnectionMemo m) {
        super(m);
        this.userName = m.getUserName();
        this.tc = m.getXpaTrafficController();
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        XpaThrottle throttle = new XpaThrottle(address, this.tc);
        this.notifyThrottleKnown(throttle, address);
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return XpaThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !XpaThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    static boolean isLongAddress(int num) {
        return num >= 100;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.INCREMENTAL);
    }
}

