/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa;

import jmri.JmriException;
import jmri.jmrix.xpa.XpaListener;
import jmri.jmrix.xpa.XpaMessage;
import jmri.jmrix.xpa.XpaSystemConnectionMemo;
import jmri.jmrix.xpa.XpaTrafficController;
import jmri.managers.AbstractPowerManager;

public class XpaPowerManager
extends AbstractPowerManager<XpaSystemConnectionMemo>
implements XpaListener {
    XpaTrafficController tc;
    boolean waiting = false;
    int onReply = 1;

    public XpaPowerManager(XpaSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getXpaTrafficController();
        this.tc.addXpaListener(this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            this.waiting = true;
            this.onReply = 2;
        } else if (v == 4) {
            this.waiting = true;
            this.onReply = 4;
        }
        XpaMessage l = XpaMessage.getEStopMsg();
        this.tc.sendXpaMessage(l, this);
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() {
        this.tc.removeXpaListener(this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use XpaPowerManager after dispose");
        }
    }

    @Override
    public void reply(XpaMessage m) {
        if (this.waiting) {
            int old = this.power;
            this.power = this.onReply;
            this.firePowerPropertyChange(old, this.power);
        }
        this.waiting = false;
    }

    @Override
    public void message(XpaMessage m) {
    }
}

