/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa;

import java.util.Arrays;
import jmri.jmrix.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpaMessage
implements Message {
    public static final int MAX_SIZE = 64;
    private int _nDataChars = 0;
    private byte[] _dataChars = null;
    private static final Logger log = LoggerFactory.getLogger((String)XpaMessage.class.getName());

    public XpaMessage(int i) {
        if (i < 1) {
            log.error("invalid length in call to ctor");
        }
        this._nDataChars = i;
        this._dataChars = new byte[i];
    }

    public XpaMessage(String s) {
        if (s.length() < 1) {
            log.error("zero length string in call to ctor");
        }
        this._nDataChars = s.length();
        this._dataChars = s.getBytes();
    }

    public XpaMessage() {
        this(64);
    }

    public XpaMessage(XpaMessage m) {
        if (m == null) {
            log.error("copy ctor of null message");
            return;
        }
        this._nDataChars = m._nDataChars;
        this._dataChars = new byte[this._nDataChars];
        System.arraycopy(m._dataChars, 0, this._dataChars, 0, this._nDataChars);
    }

    public boolean equals(Object m) {
        if (m != null && m instanceof XpaMessage && ((XpaMessage)m).getNumDataElements() == this.getNumDataElements()) {
            return Arrays.equals(((XpaMessage)m)._dataChars, this._dataChars);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + this._nDataChars;
        hash = 79 * hash + Arrays.hashCode(this._dataChars);
        return hash;
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = (byte)(v & 0x7F);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this._nDataChars) {
            s.append((char)this._dataChars[i]);
            ++i;
        }
        return s.toString();
    }

    static XpaMessage getDefaultInitMsg() {
        return new XpaMessage("ATX0E0;");
    }

    static XpaMessage getEStopMsg() {
        return new XpaMessage("ATDT0;");
    }

    static XpaMessage getIdleMsg(int address) {
        return new XpaMessage("ATDT#" + address + "*5;");
    }

    static XpaMessage getIncSpeedMsg(int address, int steps) {
        StringBuilder buf = new StringBuilder("ATDT#" + address + "*");
        int i = 0;
        while (i < steps) {
            buf.append("3");
            ++i;
        }
        String message = String.valueOf(buf.toString()) + ";";
        return new XpaMessage(message);
    }

    static XpaMessage getDecSpeedMsg(int address, int steps) {
        StringBuilder buf = new StringBuilder("ATDT#" + address + "*");
        int i = 0;
        while (i < steps) {
            buf.append("1");
            ++i;
        }
        String Message2 = String.valueOf(buf.toString()) + ";";
        return new XpaMessage(Message2);
    }

    static XpaMessage getDirForwardMsg(int address) {
        return new XpaMessage("ATDT#" + address + "*52;");
    }

    static XpaMessage getDirReverseMsg(int address) {
        return new XpaMessage("ATDT#" + address + "*58;");
    }

    static XpaMessage getFunctionMsg(int address, int function) {
        return new XpaMessage("ATDT#" + address + "**" + function + ";");
    }

    static XpaMessage getSwitchNormalMsg(int address) {
        return new XpaMessage("ATDT#" + address + "#3;");
    }

    static XpaMessage getSwitchReverseMsg(int address) {
        return new XpaMessage("ATDT#" + address + "#1;");
    }

    public static XpaMessage getDeviceSettingMsg(int setting) {
        return new XpaMessage("ATDT*" + setting + "*");
    }
}

