/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialPortController;
import jmri.jmrix.tmcc.SerialReply;
import jmri.jmrix.tmcc.SerialTrafficController;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends SerialPortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    static final int SENSOR_MSG_RATE = 10;
    private boolean outputBufferEmpty = true;
    private boolean checkBuffer = true;
    char EDC_OPS = (char)79;
    char EDC_PROG = (char)80;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new TmccSystemConnectionMemo("T", "TMCC Simulator"));
        this.setManufacturer("Lionel TMCC");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            log.debug("tempPipeI created");
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            log.debug("inpipe created {}", (Object)(this.inpipe != null ? 1 : 0));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    public boolean okToSend() {
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public void configure() {
        log.debug("set tc for memo {}", (Object)this.getSystemConnectionMemo().getUserName());
        SerialTrafficController control = new SerialTrafficController(this.getSystemConnectionMemo());
        control.connectPort(this);
        this.getSystemConnectionMemo().setTrafficController(control);
        this.getSystemConnectionMemo().configureManagers();
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("TMCC Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        super.connect();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        log.debug("DataInputStream pin returned");
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        log.debug("DataOutputStream pout returned");
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("TMCC Simulator Started");
        while (true) {
            int i;
            StringBuilder buf;
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("interrupted, ending");
                return;
            }
            SerialMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                buf = new StringBuilder();
                buf.append("TMCC Simulator Thread received message: ");
                if (m != null) {
                    i = 0;
                    while (i < m.getNumDataElements()) {
                        buf.append(Integer.toHexString(0xFF & m.getElement(i))).append(" ");
                        ++i;
                    }
                } else {
                    buf.append("null message buffer");
                }
            }
            if (m == null) continue;
            SerialReply r = this.generateReply(m);
            this.writeReply(r);
            if (!log.isDebugEnabled()) continue;
            buf = new StringBuilder();
            buf.append("TMCC Simulator Thread sent reply: ");
            i = 0;
            while (i < r.getNumDataElements()) {
                buf.append(Integer.toHexString(0xFF & r.getElement(i))).append(" ");
                ++i;
            }
            log.debug(buf.toString());
        }
    }

    private SerialMessage readMessage() {
        SerialMessage msg = null;
        try {
            if (this.inpipe != null && this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {}
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private SerialReply generateReply(SerialMessage msg) {
        log.debug("Generate Reply to message type {} (string = {})", (Object)Character.valueOf(msg.toString().charAt(0)), (Object)msg.toString());
        SerialReply reply = new SerialReply();
        char command = msg.toString().charAt(0);
        log.debug("Message type = {}", (Object)Character.valueOf(command));
        log.debug("non-reply message detected");
        log.debug("Reply generated = {}", (Object)reply.toString());
        return reply;
    }

    private void writeReply(SerialReply r) {
        if (r == null) {
            return;
        }
        int i = 0;
        while (i < r.getNumDataElements()) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {}
            ++i;
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {}
    }

    private SerialMessage loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        SerialMessage msg = new SerialMessage(nchars);
        int i = 0;
        while (i < nchars) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
            ++i;
        }
        return msg;
    }
}

