/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.jmrix.tmcc.SerialListener;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialReply;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import jmri.jmrix.tmcc.packetgen.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;

public class SerialPacketGenFrame
extends JmriJFrame
implements SerialListener {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    private TmccSystemConnectionMemo _memo = null;

    public SerialPacketGenFrame(TmccSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("SendToolTip"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexBytesToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setTitle(Bundle.getMessage("SendCommandTitle"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.packetTextField);
        this.getContentPane().add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.sendButtonActionPerformed(e);
            }
        });
        this.getContentPane().add(new JSeparator(0));
        this.pack();
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this._memo.getTrafficController().sendSerialMessage(this.createPacket(input), this);
    }

    SerialMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length != 3) {
            return null;
        }
        SerialMessage m = new SerialMessage();
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        return m;
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public void reply(SerialReply r) {
    }
}

