/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.swing.ComponentFactory;
import jmri.jmrix.tmcc.SerialThrottleManager;
import jmri.jmrix.tmcc.SerialTrafficController;
import jmri.jmrix.tmcc.SerialTurnoutManager;
import jmri.jmrix.tmcc.swing.TmccComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmccSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    ComponentFactory cf;
    private SerialTrafficController trafficController;
    private static final Logger log = LoggerFactory.getLogger(TmccSystemConnectionMemo.class);

    public TmccSystemConnectionMemo() {
        this("T", "Lionel TMCC");
    }

    public TmccSystemConnectionMemo(SerialTrafficController tc) {
        super("T", "Lionel TMCC");
        this.trafficController = tc;
        log.debug("TMCC SystemConnectionMemo with TC");
        InstanceManager.store(this, TmccSystemConnectionMemo.class);
        this.cf = new TmccComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created TMCCSystemConnectionMemo");
    }

    public TmccSystemConnectionMemo(@Nonnull String prefix, @Nonnull String name) {
        super(prefix, name);
        log.debug("TMCC SystemConnectionMemo prefix={}", (Object)prefix);
        InstanceManager.store(this, TmccSystemConnectionMemo.class);
        this.cf = new TmccComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created TMCCSystemConnectionMemo");
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    public SerialTrafficController getTrafficController() {
        if (this.trafficController == null) {
            this.setTrafficController(new SerialTrafficController(this));
            log.debug("Auto create of TMCC SerialTrafficController for initial configuration");
        }
        return this.trafficController;
    }

    public void setTrafficController(SerialTrafficController tc) {
        this.trafficController = tc;
        tc.setSystemConnectionMemo(this);
    }

    @Override
    public void configureManagers() {
        log.debug("configureManagers");
        SerialTurnoutManager turnoutManager = this.getTurnoutManager();
        this.store(turnoutManager, TurnoutManager.class);
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        ThrottleManager throttleManager = this.getThrottleManager();
        this.store(throttleManager, ThrottleManager.class);
        InstanceManager.setThrottleManager(this.getThrottleManager());
        this.register();
    }

    public ThrottleManager getThrottleManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (SerialThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> new SerialThrottleManager(this));
    }

    public void setThrottleManager(ThrottleManager t) {
        this.classObjectMap.put(ThrottleManager.class, t);
    }

    public SerialTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (SerialTurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> new SerialTurnoutManager(this));
    }

    @Override
    public void dispose() {
        this.trafficController = null;
        InstanceManager.deregister(this, TmccSystemConnectionMemo.class);
        super.dispose();
    }
}

